-module(megaco_text_parser_v2).
-export([parse/1, parse_and_scan/1, format_error/1]).
-file("megaco_text_parser_v2.yrl", 1463).

%% The following directive is needed for (significantly) faster compilation
%% of the generated .erl file by the HiPE compiler.  Please do not remove.
-compile([{hipe,[{regalloc,linear_scan}]}]).

-include("megaco_text_parser_v2.hrl").



-file("/ldisk/daily_build/otp_prebuild_r11b.2007-06-11_19/otp_src_R11B-5/bootstrap/lib/parsetools/include/yeccpre.hrl", 0).
%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved via the world wide web at http://www.erlang.org/.
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Initial Developer of the Original Code is Ericsson Utvecklings AB.
%% Portions created by Ericsson are Copyright 1999, Ericsson Utvecklings
%% AB. All Rights Reserved.''
%% 
%%     $Id $
%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The parser generator will insert appropriate declarations before this line.%

parse(Tokens) ->
    yeccpars0(Tokens, false).

parse_and_scan({F, A}) -> % Fun or {M, F}
    yeccpars0([], {F, A});
parse_and_scan({M, F, A}) ->
    yeccpars0([], {{M, F}, A}).

format_error(Message) ->
    case io_lib:deep_char_list(Message) of
	true ->
	    Message;
	_ ->
	    io_lib:write(Message)
    end.

% To be used in grammar files to throw an error message to the parser
% toplevel. Doesn't have to be exported!
-compile({nowarn_unused_function,{return_error,2}}).
return_error(Line, Message) ->
    throw({error, {Line, ?MODULE, Message}}).

yeccpars0(Tokens, MFA) ->
    try yeccpars1(Tokens, MFA, 0, [], [])
    catch 
        throw: {error, {_Line, ?MODULE, _M}} = Error -> 
                   Error % probably from return_error/1
    end.

% Don't change yeccpars1/6 too much, it is called recursively by yeccpars2/8!
yeccpars1([Token | Tokens], Tokenizer, State, States, Vstack) ->
    yeccpars2(State, element(1, Token), States, Vstack, Token, Tokens,
	      Tokenizer);
yeccpars1([], {F, A}, State, States, Vstack) ->
    case apply(F, A) of
        {ok, Tokens, _Endline} ->
	    yeccpars1(Tokens, {F, A}, State, States, Vstack);
        {eof, _Endline} ->
            yeccpars1([], false, State, States, Vstack);
        {error, Descriptor, _Endline} ->
            {error, Descriptor}
    end;
yeccpars1([], false, State, States, Vstack) ->
    yeccpars2(State, '$end', States, Vstack, {'$end', 999999}, [], false).

% For internal use only.
yeccerror(Token) ->
    {error,
     {element(2, Token), ?MODULE,
      ["syntax error before: ", yecctoken2string(Token)]}}.

yecctoken2string({atom, _, A}) -> io_lib:write(A);
yecctoken2string({integer,_,N}) -> io_lib:write(N);
yecctoken2string({float,_,F}) -> io_lib:write(F);
yecctoken2string({char,_,C}) -> io_lib:write_char(C);
yecctoken2string({var,_,V}) -> io_lib:format('~s', [V]);
yecctoken2string({string,_,S}) -> io_lib:write_string(S);
yecctoken2string({reserved_symbol, _, A}) -> io_lib:format('~w', [A]);
yecctoken2string({_Cat, _, Val}) -> io_lib:format('~w', [Val]);
yecctoken2string({'dot', _}) -> io_lib:format('~w', ['.']);
yecctoken2string({'$end', _}) ->
    [];
yecctoken2string({Other, _}) when is_atom(Other) ->
    io_lib:format('~w', [Other]);
yecctoken2string(Other) ->
    io_lib:write(Other).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



-file("./megaco_text_parser_v2.erl", 106).

yeccpars2(0, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [0 | __Ss], [__T | __Stack]);
yeccpars2(0, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_0_(__Stack),
 yeccpars2(1, __Cat, [0 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(1, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 5, [1 | __Ss], [__T | __Stack]);
yeccpars2(1, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_1_(__Stack),
 yeccpars2(4, __Cat, [1 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(2, '$end', _, __Stack, _, _, _) ->
 {ok, hd(__Stack)};
yeccpars2(2, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(3, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_3_(__Stack),
 yeccpars2(yeccgoto(optSep, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(4, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(5, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 6, [5 | __Ss], [__T | __Stack]);
yeccpars2(5, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(6, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(7, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [7 | __Ss], [__T | __Stack]);
yeccpars2(7, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(8, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_8_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(9, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_9_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(10, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_10_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(11, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_11_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(12, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_12_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(13, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_13_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(14, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_14_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(15, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_15_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(16, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_16_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(17, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_17_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(18, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_18_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(19, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_19_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(20, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_20_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(21, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_21_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(22, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_22_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(23, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_23_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(24, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_24_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(25, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_25_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(26, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_26_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(27, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_27_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(28, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_28_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(29, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_29_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(30, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_30_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(31, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_31_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(32, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_32_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(33, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_33_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(34, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_34_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(35, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_35_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(36, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_36_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(37, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_37_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(38, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_38_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(39, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_39_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(40, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_40_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(41, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_41_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(42, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_42_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(43, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_43_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(44, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_44_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(45, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_45_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(46, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_46_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(47, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_47_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(48, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_48_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(49, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_49_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(50, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_50_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(51, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_51_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(52, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_52_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(53, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_53_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(54, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_54_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(55, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_55_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(56, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_56_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(57, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_57_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(58, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_58_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(59, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_59_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(60, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_60_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(61, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_61_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(62, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_62_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(63, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_63_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(64, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_64_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(65, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_65_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(66, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_66_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(67, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_67_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(68, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_68_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(69, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_69_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(70, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_70_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(71, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_71_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(72, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_72_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(73, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_73_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(74, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_74_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(75, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_75_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(76, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_76_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(77, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_77_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(78, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_78_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(79, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_79_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(80, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_80_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(81, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_81_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(82, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_82_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(83, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_83_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(84, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_84_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(85, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_85_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(86, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_86_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(87, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_87_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(88, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_88_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(89, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_89_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(90, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_90_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(91, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_91_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(92, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_92_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(93, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_93_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(94, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_94_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(95, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [95 | __Ss], [__T | __Stack]);
yeccpars2(95, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(96, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [96 | __Ss], [__T | __Stack]);
yeccpars2(96, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(97, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [97 | __Ss], [__T | __Stack]);
yeccpars2(97, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(98, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [98 | __Ss], [__T | __Stack]);
yeccpars2(98, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_98_(__Stack),
 yeccpars2(99, __Cat, [98 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(99, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_99_(__Stack),
 __Nss = lists:nthtail(7, __Ss),
 yeccpars2(yeccgoto(authenticationHeader, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(100, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 107, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 108, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [100 | __Ss], [__T | __Stack]);
yeccpars2(100, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_100_(__Stack),
 yeccpars2(103, __Cat, [100 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(101, endOfMessage, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 102, [101 | __Ss], [__T | __Stack]);
yeccpars2(101, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(102, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_102_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(megacoMessage, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(103, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'MtpAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 865, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(104, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 132, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 133, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 134, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 135, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 136, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(105, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(mId, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(106, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(mId, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(107, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(108, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 111, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_108_(__Stack),
 yeccpars2(110, __Cat, [108 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(109, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 111, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [109 | __Ss], [__T | __Stack]);
yeccpars2(109, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_109_(__Stack),
 yeccpars2(118, __Cat, [109 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(110, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 113, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(111, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 111, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_111_(__Stack),
 yeccpars2(112, __Cat, [111 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(112, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_112_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(daddr, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(113, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 114, [113 | __Ss], [__T | __Stack]);
yeccpars2(113, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_113_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(domainAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(114, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(115, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_115_(__Stack),
 yeccpars2(yeccgoto(portNumber, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(116, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_116_(__Stack),
 yeccpars2(117, __Cat, [116 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(117, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_117_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(domainAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(118, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_118_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(daddr, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(119, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 120, [119 | __Ss], [__T | __Stack]);
yeccpars2(119, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(120, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 121, [120 | __Ss], [__T | __Stack]);
yeccpars2(120, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_120_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(domainName, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(121, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(122, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [122 | __Ss], [__T | __Stack]);
yeccpars2(122, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_122_(__Stack),
 yeccpars2(123, __Cat, [122 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(123, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_123_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(domainName, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(124, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_124_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(125, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_125_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(126, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_126_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(127, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_127_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(128, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_128_(__Stack),
 yeccpars2(yeccgoto(messageBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(129, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 133, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 134, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 135, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 136, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_129_(__Stack),
 yeccpars2(yeccgoto(transactionList, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(130, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_130_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(message, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(131, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_131_(__Stack),
 yeccpars2(yeccgoto(messageBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(132, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 784, [132 | __Ss], [__T | __Stack]);
yeccpars2(132, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(133, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 856, [133 | __Ss], [__T | __Stack]);
yeccpars2(133, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(134, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 714, [134 | __Ss], [__T | __Stack]);
yeccpars2(134, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(135, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 706, [135 | __Ss], [__T | __Stack]);
yeccpars2(135, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(136, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 137, [136 | __Ss], [__T | __Stack]);
yeccpars2(136, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 138, [136 | __Ss], [__T | __Stack]);
yeccpars2(136, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(137, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 698, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [137 | __Ss], [__T | __Stack]);
yeccpars2(137, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(138, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 140, [138 | __Ss], [__T | __Stack]);
yeccpars2(138, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(139, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 692, [139 | __Ss], [__T | __Stack]);
yeccpars2(139, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_139_(__Stack),
 yeccpars2(691, __Cat, [139 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(140, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 141, [140 | __Ss], [__T | __Stack]);
yeccpars2(140, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(141, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(142, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_142_(__Stack),
 yeccpars2(yeccgoto(contextID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(143, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 144, [143 | __Ss], [__T | __Stack]);
yeccpars2(143, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(144, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 157, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 158, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 159, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 160, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 161, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 162, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 163, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 164, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 165, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 166, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 167, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 168, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 169, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(145, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_145_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(146, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(147, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(148, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_148_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(149, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(150, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(actionRequestItem, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(151, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(actionRequestItem, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(152, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(actionRequestItem, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(153, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(154, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 477, [154 | __Ss], [__T | __Stack]);
yeccpars2(154, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(155, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(156, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 473, [156 | __Ss], [__T | __Stack]);
yeccpars2(156, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_156_(__Stack),
 yeccpars2(472, __Cat, [156 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(157, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_157_(__Stack),
 yeccpars2(yeccgoto(ammToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(158, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 469, [158 | __Ss], [__T | __Stack]);
yeccpars2(158, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(159, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 466, [159 | __Ss], [__T | __Stack]);
yeccpars2(159, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(160, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 456, [160 | __Ss], [__T | __Stack]);
yeccpars2(160, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(161, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_161_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(162, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_162_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(163, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_163_(__Stack),
 yeccpars2(yeccgoto(ammToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(164, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_164_(__Stack),
 yeccpars2(yeccgoto(ammToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(165, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 419, [165 | __Ss], [__T | __Stack]);
yeccpars2(165, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(166, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 417, [166 | __Ss], [__T | __Stack]);
yeccpars2(166, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(167, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 368, [167 | __Ss], [__T | __Stack]);
yeccpars2(167, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(168, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 188, [168 | __Ss], [__T | __Stack]);
yeccpars2(168, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(169, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 170, [169 | __Ss], [__T | __Stack]);
yeccpars2(169, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(170, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [170 | __Ss], [__T | __Stack]);
yeccpars2(170, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(171, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 184, [171 | __Ss], [__T | __Stack]);
yeccpars2(171, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_171_(__Stack),
 yeccpars2(183, __Cat, [171 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(172, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(terminationA, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(173, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 175, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(174, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_174_(__Stack),
 yeccpars2(yeccgoto(terminationID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(175, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(176, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(terminationB, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(177, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 178, [177 | __Ss], [__T | __Stack]);
yeccpars2(177, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(178, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 180, [178 | __Ss], [__T | __Stack]);
yeccpars2(178, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 181, [178 | __Ss], [__T | __Stack]);
yeccpars2(178, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 182, [178 | __Ss], [__T | __Stack]);
yeccpars2(178, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(179, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_179_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(topologyTriple, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(180, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_180_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(181, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_181_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(182, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_182_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(183, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 187, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(184, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(185, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 184, [185 | __Ss], [__T | __Stack]);
yeccpars2(185, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_185_(__Stack),
 yeccpars2(186, __Cat, [185 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(186, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_186_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(topologyTripleList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(187, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_187_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(topologyDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(188, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [188 | __Ss], [__T | __Stack]);
yeccpars2(188, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(189, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 191, [189 | __Ss], [__T | __Stack]);
yeccpars2(189, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_189_(__Stack),
 yeccpars2(190, __Cat, [189 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(190, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_190_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(subtractRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(191, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 193, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(192, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 367, [192 | __Ss], [__T | __Stack]);
yeccpars2(192, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(193, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 194, [193 | __Ss], [__T | __Stack]);
yeccpars2(193, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(194, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 208, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 209, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 210, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 211, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 212, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 213, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 214, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 215, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 216, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 217, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_194_(__Stack),
 yeccpars2(206, __Cat, [194 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(195, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_195_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(196, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_196_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(197, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_197_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(198, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_198_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(199, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_199_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(200, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_200_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(201, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_201_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(202, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_202_(__Stack),
 yeccpars2(yeccgoto(indAudauditReturnParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(203, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 358, [203 | __Ss], [__T | __Stack]);
yeccpars2(203, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_203_(__Stack),
 yeccpars2(357, __Cat, [203 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(204, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(205, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 354, [205 | __Ss], [__T | __Stack]);
yeccpars2(205, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_205_(__Stack),
 yeccpars2(353, __Cat, [205 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(206, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 352, [206 | __Ss], [__T | __Stack]);
yeccpars2(206, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(207, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_207_(__Stack),
 yeccpars2(yeccgoto(indAuddigitMapDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(208, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_208_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(209, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 338, [209 | __Ss], [__T | __Stack]);
yeccpars2(209, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_209_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(210, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 331, [210 | __Ss], [__T | __Stack]);
yeccpars2(210, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_210_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(211, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 304, [211 | __Ss], [__T | __Stack]);
yeccpars2(211, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_211_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(212, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_212_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(213, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_213_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(214, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_214_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(215, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 300, [215 | __Ss], [__T | __Stack]);
yeccpars2(215, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_215_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(216, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 223, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_216_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(217, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 218, [217 | __Ss], [__T | __Stack]);
yeccpars2(217, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_217_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(218, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [218 | __Ss], [__T | __Stack]);
yeccpars2(218, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(219, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_219_(__Stack),
 yeccpars2(yeccgoto(pkgdName, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(220, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 221, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(221, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_221_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudstatisticsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(222, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_222_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(indAudsignalsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(223, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 229, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 230, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(224, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_224_(__Stack),
 yeccpars2(yeccgoto(indAudsignalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(225, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 239, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_225_(__Stack),
 yeccpars2(yeccgoto(signalRequest, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(226, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(signalName, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(227, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 238, [227 | __Ss], [__T | __Stack]);
yeccpars2(227, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(228, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_228_(__Stack),
 yeccpars2(yeccgoto(indAudsignalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(229, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_229_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(optIndAudsignalParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(230, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 231, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_230_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(231, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [231 | __Ss], [__T | __Stack]);
yeccpars2(231, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(232, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 234, [232 | __Ss], [__T | __Stack]);
yeccpars2(232, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(233, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_233_(__Stack),
 yeccpars2(yeccgoto(signalListId, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(234, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [234 | __Ss], [__T | __Stack]);
yeccpars2(234, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(235, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(signalListParm, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(236, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 237, [236 | __Ss], [__T | __Stack]);
yeccpars2(236, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(237, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_237_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(indAudsignalList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(238, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_238_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(optIndAudsignalParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(239, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 242, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 243, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 244, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 245, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 246, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(240, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 296, [240 | __Ss], [__T | __Stack]);
yeccpars2(240, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_240_(__Stack),
 yeccpars2(295, __Cat, [240 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(241, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 270, [241 | __Ss], [__T | __Stack]);
yeccpars2(241, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 271, [241 | __Ss], [__T | __Stack]);
yeccpars2(241, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 272, [241 | __Ss], [__T | __Stack]);
yeccpars2(241, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 273, [241 | __Ss], [__T | __Stack]);
yeccpars2(241, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(242, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 267, [242 | __Ss], [__T | __Stack]);
yeccpars2(242, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_242_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(243, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_243_COMMA(__Stack),
 yeccpars2(yeccgoto(sigParameter, hd(__Ss)), 'COMMA', __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(243, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_243_RBRKT(__Stack),
 yeccpars2(yeccgoto(sigParameter, hd(__Ss)), 'RBRKT', __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(243, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_243_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(244, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 255, [244 | __Ss], [__T | __Stack]);
yeccpars2(244, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_244_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(245, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 250, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_245_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(246, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 247, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_246_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(247, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [247 | __Ss], [__T | __Stack]);
yeccpars2(247, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(248, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_248_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(249, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_249_(__Stack),
 yeccpars2(yeccgoto(streamID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(250, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 252, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 253, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 254, [250 | __Ss], [__T | __Stack]);
yeccpars2(250, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(251, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_251_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(252, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_252_(__Stack),
 yeccpars2(yeccgoto(signalType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(253, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_253_(__Stack),
 yeccpars2(yeccgoto(signalType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(254, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_254_(__Stack),
 yeccpars2(yeccgoto(signalType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(255, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 256, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(256, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 258, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 259, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 260, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 261, [256 | __Ss], [__T | __Stack]);
yeccpars2(256, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(257, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 263, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_257_(__Stack),
 yeccpars2(262, __Cat, [257 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(258, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_258_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(259, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_259_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(260, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_260_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(261, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_261_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(262, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 266, [262 | __Ss], [__T | __Stack]);
yeccpars2(262, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(263, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 258, [263 | __Ss], [__T | __Stack]);
yeccpars2(263, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 259, [263 | __Ss], [__T | __Stack]);
yeccpars2(263, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 260, [263 | __Ss], [__T | __Stack]);
yeccpars2(263, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 261, [263 | __Ss], [__T | __Stack]);
yeccpars2(263, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(264, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 263, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_264_(__Stack),
 yeccpars2(265, __Cat, [264 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(265, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_265_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(notificationReasons, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(266, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_266_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(267, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(268, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_268_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(269, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_269_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(270, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 281, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 282, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 276, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [270 | __Ss], [__T | __Stack]);
yeccpars2(270, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(271, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 276, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [271 | __Ss], [__T | __Stack]);
yeccpars2(271, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(272, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 276, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [272 | __Ss], [__T | __Stack]);
yeccpars2(272, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(273, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 276, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(274, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_274_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(275, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_275_(__Stack),
 yeccpars2(yeccgoto(value, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(276, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_276_(__Stack),
 yeccpars2(yeccgoto(value, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(277, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_277_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(278, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_278_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(279, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_279_(__Stack),
 yeccpars2(yeccgoto(alternativeValue, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(280, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_280_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(281, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 276, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(282, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 276, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [282 | __Ss], [__T | __Stack]);
yeccpars2(282, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(283, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 285, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 286, [283 | __Ss], [__T | __Stack]);
yeccpars2(283, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_283_(__Stack),
 yeccpars2(284, __Cat, [283 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(284, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 291, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(285, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 276, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(286, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 276, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [286 | __Ss], [__T | __Stack]);
yeccpars2(286, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(287, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 286, [287 | __Ss], [__T | __Stack]);
yeccpars2(287, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_287_(__Stack),
 yeccpars2(288, __Cat, [287 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(288, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_288_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(valueList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(289, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 290, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(290, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_290_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(alternativeValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(291, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_291_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(alternativeValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(292, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 286, [292 | __Ss], [__T | __Stack]);
yeccpars2(292, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_292_(__Stack),
 yeccpars2(293, __Cat, [292 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(293, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 294, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(294, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_294_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(alternativeValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(295, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 299, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(296, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 242, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 243, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 244, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 245, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 246, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(297, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 296, [297 | __Ss], [__T | __Stack]);
yeccpars2(297, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_297_(__Stack),
 yeccpars2(298, __Cat, [297 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(298, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_298_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameters, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(299, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_299_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(signalRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(300, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [300 | __Ss], [__T | __Stack]);
yeccpars2(300, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(301, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_301_(__Stack),
 yeccpars2(yeccgoto(packagesItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(302, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 303, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(303, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_303_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudpackagesDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(304, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 310, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 311, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 312, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(305, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_305_(__Stack),
 yeccpars2(yeccgoto(indAudmediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(306, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_306_(__Stack),
 yeccpars2(yeccgoto(indAudmediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(307, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_307_(__Stack),
 yeccpars2(yeccgoto(indAudmediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(308, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 330, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(309, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_309_(__Stack),
 yeccpars2(yeccgoto(indAudstreamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(310, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 322, [310 | __Ss], [__T | __Stack]);
yeccpars2(310, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(311, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 317, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(312, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 313, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(313, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(314, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_314_(__Stack),
 yeccpars2(yeccgoto(indAudterminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(315, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 316, [315 | __Ss], [__T | __Stack]);
yeccpars2(315, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(316, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_316_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudterminationStateDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(317, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(318, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 319, [318 | __Ss], [__T | __Stack]);
yeccpars2(318, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(319, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 310, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(320, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 321, [320 | __Ss], [__T | __Stack]);
yeccpars2(320, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(321, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_321_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(indAudstreamDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(322, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [322 | __Ss], [__T | __Stack]);
yeccpars2(322, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(323, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_323_(__Stack),
 yeccpars2(yeccgoto(indAudlocalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(324, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 326, [324 | __Ss], [__T | __Stack]);
yeccpars2(324, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_324_(__Stack),
 yeccpars2(325, __Cat, [324 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(325, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 329, [325 | __Ss], [__T | __Stack]);
yeccpars2(325, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(326, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(327, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 326, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_327_(__Stack),
 yeccpars2(328, __Cat, [327 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(328, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_328_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(indAudlocalParmList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(329, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_329_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(indAudlocalControlDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(330, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_330_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudmediaDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(331, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(332, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_332_(__Stack),
 yeccpars2(yeccgoto(requestID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(333, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 334, [333 | __Ss], [__T | __Stack]);
yeccpars2(333, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(334, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(335, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(indAudrequestedEvent, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(336, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 337, [336 | __Ss], [__T | __Stack]);
yeccpars2(336, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(337, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_337_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(indAudeventsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(338, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [338 | __Ss], [__T | __Stack]);
yeccpars2(338, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(339, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 343, [339 | __Ss], [__T | __Stack]);
yeccpars2(339, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_339_(__Stack),
 yeccpars2(342, __Cat, [339 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(340, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 341, [340 | __Ss], [__T | __Stack]);
yeccpars2(340, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(341, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_341_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(indAudeventBufferDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(342, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_342_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(indAudeventSpec, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(343, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 348, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [343 | __Ss], [__T | __Stack]);
yeccpars2(343, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(344, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_344_(__Stack),
 yeccpars2(yeccgoto(eventParameterName, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(345, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 351, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(346, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_346_(__Stack),
 yeccpars2(yeccgoto(indAudeventSpecParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(347, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_347_(__Stack),
 yeccpars2(yeccgoto(indAudeventSpecParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(348, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 349, [348 | __Ss], [__T | __Stack]);
yeccpars2(348, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_348_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(349, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [349 | __Ss], [__T | __Stack]);
yeccpars2(349, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(350, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_350_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(eventStream, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(351, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_351_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(optIndAudeventSpecParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(352, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_352_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(auditDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(353, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_353_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(auditDescriptorBody, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(354, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [354 | __Ss], [__T | __Stack]);
yeccpars2(354, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 208, [354 | __Ss], [__T | __Stack]);
yeccpars2(354, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 209, [354 | __Ss], [__T | __Stack]);
yeccpars2(354, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 210, [354 | __Ss], [__T | __Stack]);
yeccpars2(354, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 211, [354 | __Ss], [__T | __Stack]);
yeccpars2(354, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 212, [354 | __Ss], [__T | __Stack]);
yeccpars2(354, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 213, [354 | __Ss], [__T | __Stack]);
yeccpars2(354, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 214, [354 | __Ss], [__T | __Stack]);
yeccpars2(354, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 215, [354 | __Ss], [__T | __Stack]);
yeccpars2(354, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 216, [354 | __Ss], [__T | __Stack]);
yeccpars2(354, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 217, [354 | __Ss], [__T | __Stack]);
yeccpars2(354, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(355, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 354, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_355_(__Stack),
 yeccpars2(356, __Cat, [355 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(356, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_356_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(auditItemList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(357, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_357_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(indAudterminationAudit, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(358, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 360, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 361, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 362, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 363, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 364, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 365, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(359, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 358, [359 | __Ss], [__T | __Stack]);
yeccpars2(359, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_359_(__Stack),
 yeccpars2(366, __Cat, [359 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(360, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 338, [360 | __Ss], [__T | __Stack]);
yeccpars2(360, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(361, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 331, [361 | __Ss], [__T | __Stack]);
yeccpars2(361, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(362, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 304, [362 | __Ss], [__T | __Stack]);
yeccpars2(362, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(363, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 300, [363 | __Ss], [__T | __Stack]);
yeccpars2(363, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(364, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 223, [364 | __Ss], [__T | __Stack]);
yeccpars2(364, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(365, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 218, [365 | __Ss], [__T | __Stack]);
yeccpars2(365, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(366, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_366_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(indAudterminationAuditList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(367, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_367_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(optAuditDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(368, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [368 | __Ss], [__T | __Stack]);
yeccpars2(368, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(369, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 370, [369 | __Ss], [__T | __Stack]);
yeccpars2(369, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(370, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 372, [370 | __Ss], [__T | __Stack]);
yeccpars2(370, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(371, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 416, [371 | __Ss], [__T | __Stack]);
yeccpars2(371, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(372, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 373, [372 | __Ss], [__T | __Stack]);
yeccpars2(372, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(373, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 387, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 208, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 209, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 210, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 211, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 388, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 389, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 212, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 213, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 214, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 215, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 390, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 391, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 392, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 216, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 217, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 393, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 394, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(374, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_374_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(375, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_375_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(376, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_376_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(377, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_377_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(378, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 412, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_378_(__Stack),
 yeccpars2(411, __Cat, [378 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(379, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_379_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(380, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_380_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(381, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_381_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(382, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_382_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(383, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_383_(__Stack),
 yeccpars2(yeccgoto(extensionParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(384, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 270, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 271, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 272, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 273, [384 | __Ss], [__T | __Stack]);
yeccpars2(384, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(385, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_385_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(386, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_386_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(387, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 408, [387 | __Ss], [__T | __Stack]);
yeccpars2(387, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_387_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(388, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 406, [388 | __Ss], [__T | __Stack]);
yeccpars2(388, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_388_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(389, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 404, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_389_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(390, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 402, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_390_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(391, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 400, [391 | __Ss], [__T | __Stack]);
yeccpars2(391, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_391_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(392, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 397, [392 | __Ss], [__T | __Stack]);
yeccpars2(392, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_392_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(393, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_393_COMMA(__Stack),
 yeccpars2(yeccgoto(timeStamp, hd(__Ss)), 'COMMA', __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(393, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_393_RBRKT(__Stack),
 yeccpars2(yeccgoto(timeStamp, hd(__Ss)), 'RBRKT', __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(393, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_393_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(394, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 395, [394 | __Ss], [__T | __Stack]);
yeccpars2(394, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_394_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(395, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(396, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_396_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeVersion, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(397, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 107, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 108, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [397 | __Ss], [__T | __Stack]);
yeccpars2(397, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_397_(__Stack),
 yeccpars2(103, __Cat, [397 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(398, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_398_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(399, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_399_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(400, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 276, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(401, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_401_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeReason, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(402, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [402 | __Ss], [__T | __Stack]);
yeccpars2(402, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(403, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_403_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeProfile, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(404, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 107, [404 | __Ss], [__T | __Stack]);
yeccpars2(404, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 108, [404 | __Ss], [__T | __Stack]);
yeccpars2(404, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [404 | __Ss], [__T | __Stack]);
yeccpars2(404, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_404_(__Stack),
 yeccpars2(103, __Cat, [404 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(405, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_405_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeMgcId, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(406, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [406 | __Ss], [__T | __Stack]);
yeccpars2(406, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(407, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_407_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeMethod, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(408, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [408 | __Ss], [__T | __Stack]);
yeccpars2(408, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(409, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_409_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeDelay, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(410, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_410_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(extension, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(411, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 415, [411 | __Ss], [__T | __Stack]);
yeccpars2(411, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(412, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 387, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 208, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 209, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 210, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 211, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 388, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 389, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 212, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 213, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 214, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 215, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 390, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 391, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 392, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 216, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 217, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 393, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 394, [412 | __Ss], [__T | __Stack]);
yeccpars2(412, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(413, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 412, [413 | __Ss], [__T | __Stack]);
yeccpars2(413, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_413_(__Stack),
 yeccpars2(414, __Cat, [413 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(414, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_414_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(415, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_415_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(serviceChangeDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(416, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_416_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(serviceChangeRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(417, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(418, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_418_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(priority, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(419, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [419 | __Ss], [__T | __Stack]);
yeccpars2(419, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(420, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 421, [420 | __Ss], [__T | __Stack]);
yeccpars2(420, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(421, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 132, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 425, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(422, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_422_(__Stack),
 yeccpars2(yeccgoto(notifyRequestBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(423, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 455, [423 | __Ss], [__T | __Stack]);
yeccpars2(423, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(424, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_424_(__Stack),
 yeccpars2(yeccgoto(notifyRequestBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(425, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 426, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(426, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(427, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 428, [427 | __Ss], [__T | __Stack]);
yeccpars2(427, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(428, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [428 | __Ss], [__T | __Stack]);
yeccpars2(428, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 432, [428 | __Ss], [__T | __Stack]);
yeccpars2(428, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_428_(__Stack),
 yeccpars2(430, __Cat, [428 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(429, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [429 | __Ss], [__T | __Stack]);
yeccpars2(429, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_429_(__Stack),
 yeccpars2(450, __Cat, [429 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(430, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(431, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 434, [431 | __Ss], [__T | __Stack]);
yeccpars2(431, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_431_(__Stack),
 yeccpars2(433, __Cat, [431 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(432, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_432_(__Stack),
 yeccpars2(yeccgoto(timeStamp, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(433, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 437, [433 | __Ss], [__T | __Stack]);
yeccpars2(433, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(434, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 432, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_434_(__Stack),
 yeccpars2(430, __Cat, [434 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(435, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 434, [435 | __Ss], [__T | __Stack]);
yeccpars2(435, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_435_(__Stack),
 yeccpars2(436, __Cat, [435 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(436, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_436_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(observedEvents, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(437, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_437_(__Stack),
 __Nss = lists:nthtail(6, __Ss),
 yeccpars2(yeccgoto(observedEventsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(438, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 440, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_438_(__Stack),
 yeccpars2(439, __Cat, [438 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(439, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_439_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(observedEvent, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(440, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(441, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 446, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_441_(__Stack),
 yeccpars2(445, __Cat, [441 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(442, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(observedEventParameter, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(443, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 270, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 271, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 272, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 273, [443 | __Ss], [__T | __Stack]);
yeccpars2(443, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(444, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_444_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(eventStreamOrOther, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(445, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 449, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(446, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(447, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 446, [447 | __Ss], [__T | __Stack]);
yeccpars2(447, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_447_(__Stack),
 yeccpars2(448, __Cat, [447 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(448, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_448_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(observedEventParameters, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(449, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_449_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(observedEventBody, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(450, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 451, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(451, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_451_(__Stack),
 yeccpars2(452, __Cat, [451 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(452, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [452 | __Ss], [__T | __Stack]);
yeccpars2(452, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(453, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 440, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_453_(__Stack),
 yeccpars2(454, __Cat, [453 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(454, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_454_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(observedEvent, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(455, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_455_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(notifyRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(456, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 458, [456 | __Ss], [__T | __Stack]);
yeccpars2(456, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 459, [456 | __Ss], [__T | __Stack]);
yeccpars2(456, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 460, [456 | __Ss], [__T | __Stack]);
yeccpars2(456, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(457, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 462, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_457_(__Stack),
 yeccpars2(461, __Cat, [457 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(458, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_458_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(459, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_459_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(460, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_460_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(461, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 465, [461 | __Ss], [__T | __Stack]);
yeccpars2(461, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(462, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 458, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 459, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 460, [462 | __Ss], [__T | __Stack]);
yeccpars2(462, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(463, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 462, [463 | __Ss], [__T | __Stack]);
yeccpars2(463, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_463_(__Stack),
 yeccpars2(464, __Cat, [463 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(464, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_464_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(contextAuditProperties, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(465, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_465_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(contextAudit, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(466, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(467, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 191, [467 | __Ss], [__T | __Stack]);
yeccpars2(467, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_467_(__Stack),
 yeccpars2(468, __Cat, [467 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(468, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_468_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(auditRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(469, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [469 | __Ss], [__T | __Stack]);
yeccpars2(469, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(470, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 191, [470 | __Ss], [__T | __Stack]);
yeccpars2(470, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_470_(__Stack),
 yeccpars2(471, __Cat, [470 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(471, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_471_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(auditRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(472, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 476, [472 | __Ss], [__T | __Stack]);
yeccpars2(472, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(473, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 157, [473 | __Ss], [__T | __Stack]);
yeccpars2(473, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 158, [473 | __Ss], [__T | __Stack]);
yeccpars2(473, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 159, [473 | __Ss], [__T | __Stack]);
yeccpars2(473, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 160, [473 | __Ss], [__T | __Stack]);
yeccpars2(473, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 161, [473 | __Ss], [__T | __Stack]);
yeccpars2(473, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 162, [473 | __Ss], [__T | __Stack]);
yeccpars2(473, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 163, [473 | __Ss], [__T | __Stack]);
yeccpars2(473, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 164, [473 | __Ss], [__T | __Stack]);
yeccpars2(473, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 165, [473 | __Ss], [__T | __Stack]);
yeccpars2(473, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 166, [473 | __Ss], [__T | __Stack]);
yeccpars2(473, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 167, [473 | __Ss], [__T | __Stack]);
yeccpars2(473, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 168, [473 | __Ss], [__T | __Stack]);
yeccpars2(473, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 169, [473 | __Ss], [__T | __Stack]);
yeccpars2(473, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(474, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 473, [474 | __Ss], [__T | __Stack]);
yeccpars2(474, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_474_(__Stack),
 yeccpars2(475, __Cat, [474 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(475, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_475_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(actionRequestItems, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(476, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_476_(__Stack),
 __Nss = lists:nthtail(6, __Ss),
 yeccpars2(yeccgoto(actionRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(477, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(478, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 480, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_478_(__Stack),
 yeccpars2(479, __Cat, [478 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(479, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_479_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(ammRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(480, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 193, [480 | __Ss], [__T | __Stack]);
yeccpars2(480, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 490, [480 | __Ss], [__T | __Stack]);
yeccpars2(480, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 491, [480 | __Ss], [__T | __Stack]);
yeccpars2(480, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 492, [480 | __Ss], [__T | __Stack]);
yeccpars2(480, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 493, [480 | __Ss], [__T | __Stack]);
yeccpars2(480, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 494, [480 | __Ss], [__T | __Stack]);
yeccpars2(480, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 495, [480 | __Ss], [__T | __Stack]);
yeccpars2(480, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 496, [480 | __Ss], [__T | __Stack]);
yeccpars2(480, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(481, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_481_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(482, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_482_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(483, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_483_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(484, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_484_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(485, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_485_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(486, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_486_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(487, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_487_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(488, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_488_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(489, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 687, [489 | __Ss], [__T | __Stack]);
yeccpars2(489, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_489_(__Stack),
 yeccpars2(686, __Cat, [489 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(490, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_490_(__Stack),
 yeccpars2(yeccgoto(digitMapDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(491, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 678, [491 | __Ss], [__T | __Stack]);
yeccpars2(491, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_491_(__Stack),
 yeccpars2(yeccgoto(eventBufferDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(492, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 618, [492 | __Ss], [__T | __Stack]);
yeccpars2(492, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_492_(__Stack),
 yeccpars2(yeccgoto(eventsDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(493, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 548, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(494, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 527, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 528, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(495, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 516, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(496, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 497, [496 | __Ss], [__T | __Stack]);
yeccpars2(496, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_496_(__Stack),
 yeccpars2(yeccgoto(signalsDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(497, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 501, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [497 | __Ss], [__T | __Stack]);
yeccpars2(497, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(498, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_498_(__Stack),
 yeccpars2(yeccgoto(signalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(499, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 512, [499 | __Ss], [__T | __Stack]);
yeccpars2(499, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_499_(__Stack),
 yeccpars2(511, __Cat, [499 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(500, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_500_(__Stack),
 yeccpars2(yeccgoto(signalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(501, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 502, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_501_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(502, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(503, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 504, [503 | __Ss], [__T | __Stack]);
yeccpars2(503, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(504, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(505, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 507, [505 | __Ss], [__T | __Stack]);
yeccpars2(505, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_505_(__Stack),
 yeccpars2(506, __Cat, [505 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(506, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 510, [506 | __Ss], [__T | __Stack]);
yeccpars2(506, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(507, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(508, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 507, [508 | __Ss], [__T | __Stack]);
yeccpars2(508, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_508_(__Stack),
 yeccpars2(509, __Cat, [508 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(509, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_509_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(signalListParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(510, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_510_(__Stack),
 __Nss = lists:nthtail(6, __Ss),
 yeccpars2(yeccgoto(signalList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(511, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 515, [511 | __Ss], [__T | __Stack]);
yeccpars2(511, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(512, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 501, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(513, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 512, [513 | __Ss], [__T | __Stack]);
yeccpars2(513, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_513_(__Stack),
 yeccpars2(514, __Cat, [513 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(514, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_514_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(signalParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(515, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_515_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(signalsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(516, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [516 | __Ss], [__T | __Stack]);
yeccpars2(516, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(517, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_517_(__Stack),
 yeccpars2(yeccgoto(muxType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(518, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 520, [518 | __Ss], [__T | __Stack]);
yeccpars2(518, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(519, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_519_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(muxDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(520, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [520 | __Ss], [__T | __Stack]);
yeccpars2(520, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(521, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 523, [521 | __Ss], [__T | __Stack]);
yeccpars2(521, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_521_(__Stack),
 yeccpars2(522, __Cat, [521 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(522, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 526, [522 | __Ss], [__T | __Stack]);
yeccpars2(522, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(523, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [523 | __Ss], [__T | __Stack]);
yeccpars2(523, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(524, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 523, [524 | __Ss], [__T | __Stack]);
yeccpars2(524, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_524_(__Stack),
 yeccpars2(525, __Cat, [524 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(525, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_525_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(terminationIDListRepeat, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(526, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_526_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(terminationIDList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(527, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(528, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(529, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_529_(__Stack),
 yeccpars2(yeccgoto(modemType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(530, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 532, [530 | __Ss], [__T | __Stack]);
yeccpars2(530, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_530_(__Stack),
 yeccpars2(531, __Cat, [530 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(531, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 535, [531 | __Ss], [__T | __Stack]);
yeccpars2(531, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(532, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(533, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 532, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_533_(__Stack),
 yeccpars2(534, __Cat, [533 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(534, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_534_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(modemTypeList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(535, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 537, [535 | __Ss], [__T | __Stack]);
yeccpars2(535, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_535_(__Stack),
 yeccpars2(536, __Cat, [535 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(536, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_536_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(modemDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(537, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(538, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 542, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_538_(__Stack),
 yeccpars2(541, __Cat, [538 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(539, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 270, [539 | __Ss], [__T | __Stack]);
yeccpars2(539, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 271, [539 | __Ss], [__T | __Stack]);
yeccpars2(539, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 272, [539 | __Ss], [__T | __Stack]);
yeccpars2(539, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 273, [539 | __Ss], [__T | __Stack]);
yeccpars2(539, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(540, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_540_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(propertyParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(541, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 545, [541 | __Ss], [__T | __Stack]);
yeccpars2(541, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(542, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(543, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 542, [543 | __Ss], [__T | __Stack]);
yeccpars2(543, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_543_(__Stack),
 yeccpars2(544, __Cat, [543 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(544, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_544_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(propertyParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(545, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_545_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(optPropertyParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(546, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 537, [546 | __Ss], [__T | __Stack]);
yeccpars2(546, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_546_(__Stack),
 yeccpars2(547, __Cat, [546 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(547, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_547_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(modemDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(548, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 554, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'LocalDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 555, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'RemoteDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 556, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 557, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 558, [548 | __Ss], [__T | __Stack]);
yeccpars2(548, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(549, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_549_(__Stack),
 yeccpars2(yeccgoto(mediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(550, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_550_(__Stack),
 yeccpars2(yeccgoto(mediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(551, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_551_(__Stack),
 yeccpars2(yeccgoto(mediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(552, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 614, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_552_(__Stack),
 yeccpars2(613, __Cat, [552 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(553, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_553_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(554, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 589, [554 | __Ss], [__T | __Stack]);
yeccpars2(554, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(555, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_555_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(556, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_556_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(557, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 580, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(558, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 559, [558 | __Ss], [__T | __Stack]);
yeccpars2(558, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(559, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 564, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 565, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(560, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 576, [560 | __Ss], [__T | __Stack]);
yeccpars2(560, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_560_(__Stack),
 yeccpars2(575, __Cat, [560 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(561, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_561_(__Stack),
 yeccpars2(yeccgoto(terminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(562, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_562_(__Stack),
 yeccpars2(yeccgoto(terminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(563, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_563_(__Stack),
 yeccpars2(yeccgoto(terminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(564, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 571, [564 | __Ss], [__T | __Stack]);
yeccpars2(564, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_564_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(565, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 566, [565 | __Ss], [__T | __Stack]);
yeccpars2(565, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_565_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(566, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 568, [566 | __Ss], [__T | __Stack]);
yeccpars2(566, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 569, [566 | __Ss], [__T | __Stack]);
yeccpars2(566, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 570, [566 | __Ss], [__T | __Stack]);
yeccpars2(566, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(567, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_567_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceStates, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(568, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_568_(__Stack),
 yeccpars2(yeccgoto(serviceState, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(569, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_569_(__Stack),
 yeccpars2(yeccgoto(serviceState, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(570, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_570_(__Stack),
 yeccpars2(yeccgoto(serviceState, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(571, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 573, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 574, [571 | __Ss], [__T | __Stack]);
yeccpars2(571, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(572, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_572_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(eventBufferControl, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(573, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_573_(__Stack),
 yeccpars2(yeccgoto(eventBufferControlState, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(574, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_574_(__Stack),
 yeccpars2(yeccgoto(eventBufferControlState, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(575, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 579, [575 | __Ss], [__T | __Stack]);
yeccpars2(575, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(576, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 564, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 565, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [576 | __Ss], [__T | __Stack]);
yeccpars2(576, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(577, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 576, [577 | __Ss], [__T | __Stack]);
yeccpars2(577, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_577_(__Stack),
 yeccpars2(578, __Cat, [577 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(578, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_578_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(terminationStateParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(579, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_579_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(terminationStateDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(580, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'EmergencyOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'Nx64Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [580 | __Ss], [__T | __Stack]);
yeccpars2(580, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(581, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 582, [581 | __Ss], [__T | __Stack]);
yeccpars2(581, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(582, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 554, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'LocalDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 555, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, 'RemoteDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 556, [582 | __Ss], [__T | __Stack]);
yeccpars2(582, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(583, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 585, [583 | __Ss], [__T | __Stack]);
yeccpars2(583, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_583_(__Stack),
 yeccpars2(584, __Cat, [583 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(584, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 588, [584 | __Ss], [__T | __Stack]);
yeccpars2(584, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(585, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 554, [585 | __Ss], [__T | __Stack]);
yeccpars2(585, 'LocalDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 555, [585 | __Ss], [__T | __Stack]);
yeccpars2(585, 'RemoteDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 556, [585 | __Ss], [__T | __Stack]);
yeccpars2(585, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(586, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 585, [586 | __Ss], [__T | __Stack]);
yeccpars2(586, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_586_(__Stack),
 yeccpars2(587, __Cat, [586 | __Ss], __New