/* 
 * otpCalc - A one time password calculator.
 *
 * Copyright (C) 2001 Anthony D. Urso
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 *
 */

#include <gtk/gtk.h>

#include "callbacks.h"
#include "macros.h"

GtkWidget *te_challenge;
GtkWidget *te_passwd;
GtkWidget *te_response;

unsigned short hash;
unsigned short newline = 1;
unsigned short autopaste = 1;

int main(int argc, char *argv[])
{

	GtkWidget *wi_top, *ta_top, *la_challenge, *bu_calc, *la_passwd,
		  *bu_clear, *mb_top, *mi_file, *me_file, *mi_file_quit,
		  *mi_sett, *me_sett, *mi_sett_rmd160, *mi_sett_sha1,
		  *mi_sett_md5, *mi_sett_md4, *mi_sett_skey, *mi_help,
		  *me_help, *mi_help_about;
	GtkAccelGroup *accel_group;
	GSList *hashes = NULL;


	gtk_init(&argc, &argv);

	netwarn();

	/* Setup the main window... */
	wi_top = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(wi_top), "otpCalc");
	gtk_window_set_policy(GTK_WINDOW(wi_top), FALSE, FALSE, TRUE);
	gtk_window_set_wmclass(GTK_WINDOW(wi_top), "otpCalc", "Calc");

	gtk_signal_connect(GTK_OBJECT(wi_top), "delete_event",
			   GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

	gtk_signal_connect(GTK_OBJECT(wi_top), "focus_in_event",
			   GTK_SIGNAL_FUNC(focus), NULL);

	gtk_signal_connect(GTK_OBJECT(wi_top), "selection_received",
			   GTK_SIGNAL_FUNC(selector), NULL);
	/* Done. */


	/* Setup the accelrator group... */
	accel_group = gtk_accel_group_new();
	gtk_window_add_accel_group(GTK_WINDOW(wi_top), accel_group);
	/* Done. */


	/* Setup the main container... */
	ta_top = gtk_table_new(4, 3, FALSE);
	gtk_container_add(GTK_CONTAINER(wi_top), ta_top);
	gtk_table_set_row_spacings(GTK_TABLE(ta_top), 0);
	gtk_widget_show(ta_top);
	/* Done. */

	
	/* Setup the file menu... */
	me_file = gtk_menu_new();
	mi_file_quit = gtk_menu_item_new_with_label("Quit");
	gtk_menu_append(GTK_MENU(me_file), mi_file_quit);
	gtk_signal_connect_object(GTK_OBJECT(mi_file_quit), "activate",
				  GTK_SIGNAL_FUNC(gtk_main_quit), NULL);

	gtk_widget_add_accelerator(mi_file_quit, "activate", accel_group, 0x071,
				   GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	gtk_widget_show(mi_file_quit);
	/* Done. */


	/* Setup the hash menu... */
	me_sett = gtk_menu_new();

	mi_sett_sha1 = gtk_radio_menu_item_new_with_label(hashes, "sha1");
	gtk_menu_append(GTK_MENU(me_sett), mi_sett_sha1);
	gtk_signal_connect_object(GTK_OBJECT(mi_sett_sha1), "activate",
				  GTK_SIGNAL_FUNC(sethash), (void *)SHA1);
	hashes = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(mi_sett_sha1));
	gtk_widget_show(mi_sett_sha1);

	mi_sett_rmd160 = gtk_radio_menu_item_new_with_label(hashes, "rmd160");
	gtk_menu_append(GTK_MENU(me_sett), mi_sett_rmd160);
	gtk_signal_connect_object(GTK_OBJECT(mi_sett_rmd160), "activate",
				  GTK_SIGNAL_FUNC(sethash), (void *)RMD160);
	hashes = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(mi_sett_rmd160));
	gtk_widget_show(mi_sett_rmd160);

	mi_sett_md5 = gtk_radio_menu_item_new_with_label(hashes, "md5");
	gtk_menu_append(GTK_MENU(me_sett), mi_sett_md5);
	gtk_signal_connect_object(GTK_OBJECT(mi_sett_md5), "activate",
				  GTK_SIGNAL_FUNC(sethash), (void *)MD5);
	hashes = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(mi_sett_md5));
	gtk_widget_show(mi_sett_md5);

	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mi_sett_md5), TRUE);

	mi_sett_md4 = gtk_radio_menu_item_new_with_label(hashes, "md4");
	gtk_menu_append(GTK_MENU(me_sett), mi_sett_md4);
	gtk_signal_connect_object(GTK_OBJECT(mi_sett_md4), "activate",
				  GTK_SIGNAL_FUNC(sethash), (void *)MD4);
	hashes = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(mi_sett_md4));
	gtk_widget_show(mi_sett_md4);

	mi_sett_skey = gtk_radio_menu_item_new_with_label(hashes, "s/key");
	gtk_menu_append(GTK_MENU(me_sett), mi_sett_skey);
	gtk_signal_connect_object(GTK_OBJECT(mi_sett_skey), "activate",
				  GTK_SIGNAL_FUNC(sethash), (void *)SKEY);
	hashes = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(mi_sett_skey));
	gtk_widget_show(mi_sett_skey);
	/* Done. */


	/* Setup the help menu... */
	me_help = gtk_menu_new();
	mi_help_about = gtk_menu_item_new_with_label("About...");
	gtk_menu_append(GTK_MENU(me_help), mi_help_about);
	gtk_signal_connect_object(GTK_OBJECT(mi_help_about), "activate",
				  GTK_SIGNAL_FUNC(about), NULL);
	gtk_widget_show(mi_help_about);
	/* Done. */


	/* Setup the menu bar... */
	mb_top = gtk_menu_bar_new();
	gtk_menu_bar_set_shadow_type(GTK_MENU_BAR(mb_top), GTK_SHADOW_NONE); 
	gtk_table_attach(GTK_TABLE(ta_top), mb_top, 0, 3, 0, 1,
			 (GtkAttachOptions)(GTK_FILL),
			 (GtkAttachOptions)(0), 0, 0);
	gtk_widget_show(mb_top);

	mi_file = gtk_menu_item_new_with_label("File");
	gtk_widget_show(mi_file);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mi_file), me_file);
	gtk_menu_bar_append(GTK_MENU_BAR(mb_top), mi_file);

	mi_sett = gtk_menu_item_new_with_label("Settings");
	gtk_widget_show(mi_sett);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mi_sett), me_sett);
	gtk_menu_bar_append(GTK_MENU_BAR(mb_top), mi_sett);

	mi_help = gtk_menu_item_new_with_label("Help");
	gtk_widget_show(mi_help);
	gtk_menu_item_set_submenu(GTK_MENU_ITEM(mi_help), me_help);
	gtk_menu_bar_append(GTK_MENU_BAR(mb_top), mi_help);
	gtk_menu_item_right_justify(GTK_MENU_ITEM(mi_help));
	/* Done. */


	/* Setup the "Challenge:" label... */
	la_challenge = gtk_label_new("Challenge:");
	gtk_table_attach(GTK_TABLE(ta_top), la_challenge, 0, 1, 1, 2,
			 (GtkAttachOptions)(GTK_FILL),
			 (GtkAttachOptions)(0), 0, 0);
	gtk_misc_set_padding(GTK_MISC(la_challenge), 5, 0);
	gtk_widget_show(la_challenge);
	/* Done. */


	/* Setup the "Password:" label... */
	la_passwd = gtk_label_new("Password:");
	gtk_table_attach(GTK_TABLE(ta_top), la_passwd, 0, 1, 2, 3,
			 (GtkAttachOptions)(GTK_FILL),
			 (GtkAttachOptions)(0), 0, 0);
	gtk_misc_set_padding(GTK_MISC(la_passwd), 5, 0);
	gtk_widget_show(la_passwd);
	/* Done. */


	/* Setup the server challenge text entry... */
	te_challenge = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(ta_top), te_challenge, 1, 2, 1, 2,
			 (GtkAttachOptions)(GTK_FILL),
			 (GtkAttachOptions)(0), 0, 0);
	gtk_widget_show(te_challenge);
	/* Done. */

	
	/* Setup the "Calculate" button... */
	bu_calc = gtk_button_new_with_label("Calculate");
	gtk_button_set_relief(GTK_BUTTON(bu_calc), GTK_RELIEF_HALF);
	gtk_table_attach(GTK_TABLE(ta_top), bu_calc, 2, 3, 1, 2,
			 (GtkAttachOptions)(GTK_FILL),
			 (GtkAttachOptions)(0), 5, 0);
	gtk_widget_show(bu_calc);

	gtk_signal_connect_object(GTK_OBJECT(bu_calc), "clicked",
				  GTK_SIGNAL_FUNC(calculate), NULL);
	/* Done. */


	/* Setup the password text entry... */
	te_passwd = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(ta_top), te_passwd, 1, 2, 2, 3,
			 (GtkAttachOptions)(GTK_EXPAND|GTK_FILL),
			 (GtkAttachOptions)(0), 0, 0);
	gtk_entry_set_visibility(GTK_ENTRY(te_passwd), FALSE);
	gtk_widget_show(te_passwd);

	gtk_signal_connect(GTK_OBJECT(te_passwd), "activate",
			   GTK_SIGNAL_FUNC(click), bu_calc);
	/* Done. */


	/* Setup the "Clear" button... */
	bu_clear = gtk_button_new_with_label("Clear");
	gtk_button_set_relief(GTK_BUTTON(bu_clear), GTK_RELIEF_HALF);
	gtk_table_attach(GTK_TABLE(ta_top), bu_clear, 2, 3, 2, 3,
			 (GtkAttachOptions)(GTK_FILL),
			 (GtkAttachOptions)(0), 5, 0);
	gtk_widget_show(bu_clear);

	gtk_signal_connect(GTK_OBJECT(bu_clear), "clicked",
			   GTK_SIGNAL_FUNC(clear), NULL);
	/* Done. */


	/* Setup the response text display... */
	te_response = gtk_entry_new();
	gtk_table_attach(GTK_TABLE(ta_top), te_response, 0, 3, 3, 4,
			 (GtkAttachOptions)(GTK_EXPAND|GTK_FILL),
			 (GtkAttachOptions)(0), 5, 5);
	gtk_editable_set_editable(GTK_EDITABLE(te_response), FALSE);
	gtk_widget_show(te_response);
	/* Done. */


	gtk_widget_show(wi_top);

	gtk_main();

	return 0;

}
