/****************************************************************************
 *
 *  Copyright (C) 2000-2001 RealNetworks, Inc. All rights reserved.
 *
 *  This program is free software.  It may be distributed under the terms
 *  in the file LICENSE, found in the top level of the source distribution.
 *
 */

#ifndef _PROXYTRAN_H
#define _PROXYTRAN_H

#include "tran.h"
#include "rtspprot.h"

class CProxyTransport : public CTransport
{
private: // Unimplemented
    CProxyTransport( const CProxyTransport& );
    CProxyTransport& operator=( const CProxyTransport& );

public:
    CProxyTransport(void);
    virtual ~CProxyTransport( void );

    bool Init( int nPorts );
    bool Init( int nChannels, UINT16 chan, CRtspProtocol * pProt );
    void Close( );
    void SetPeer( const CString& strHost, UINT16 port );
    void SetPeer( const CInetAddr& host, UINT16 port );

    void SetSibling(CProxyTransport * pSibling);

    UINT16 GetBasePort( void );

    virtual void SendPacket( UINT chan, CPacket* ppkt );

    void OnPacket( UINT chan, CBuffer* pbuf );

protected:
    class CPassthruProtocol : public CStreamResponse
    {
    public:
        CPassthruProtocol( CProxyTransport* pOwner );
        virtual ~CPassthruProtocol( void );

        bool Init( UINT16 port );
        bool Init( UINT16 chan, CRtspProtocol * pProt);

        void Close();

        void SetPeer( const CString& strHost, UINT16 port );
        void SetPeer( const CInetAddr& host, UINT16 port );

        void SendPacket( CPacket* ppkt );

        virtual void OnConnectDone( int err );
        virtual void OnReadReady  ( void );
        virtual void OnWriteReady ( void );
        virtual void OnExceptReady( void );
        virtual void OnClosed     ( void );

    protected:
        CProxyTransport*    m_pOwner;
        CSocket*            m_pSock;
        UINT16              m_chan;
    };

protected:
    UINT              m_nPorts;
    UINT16            m_portBase;
    CPassthruProtocol m_protData;
    CPassthruProtocol m_protCtrl; // RTP only
    CProxyTransport*  m_pSibling;
};

#endif //ndef _PROXYTRAN_H
