/***** BEGIN LICENSE BLOCK *****
 * Version: CPL 1.0/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Common Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.eclipse.org/legal/cpl-v10.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * Copyright (C) 2002-2004 Anders Bengtsson <ndrsbngtssn@yahoo.se>
 * Copyright (C) 2002-2004 Jan Arne Petersen <jpetersen@uni-bonn.de>
 * Copyright (C) 2004 Thomas E Enebo <enebo@acm.org>
 * Copyright (C) 2004 Stefan Matthias Aust <sma@3plus4.de>
 * 
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the CPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the CPL, the GPL or the LGPL.
 ***** END LICENSE BLOCK *****/
package org.jruby.main;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;

import org.ablaf.ast.IAstEncoder;
import org.jruby.ast.util.RubyAstMarshal;
import org.jruby.common.NullWarnings;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.DefaultRubyParser;
import org.jruby.parser.RubyParserConfiguration;
import org.jruby.parser.RubyParserPool;
import org.jruby.parser.RubyParserResult;

/**
 * 
 * @author jpetersen
 */
public class ASTSerializer {
    public ASTSerializer() {
        super();
    }
    
    public static void serialize(File input, File outputFile) throws IOException {
        OutputStream output = new BufferedOutputStream(new FileOutputStream(outputFile));
        IAstEncoder encoder = RubyAstMarshal.getInstance().openEncoder(output);
        try {
        	serialize(input, encoder);
        } finally {
        	encoder.close();
        }
    }
    
    public static void serialize(File input, IAstEncoder encoder) throws IOException {
        Reader reader = new BufferedReader(new FileReader(input));
        RubyParserConfiguration config = new RubyParserConfiguration();
        config.setLocalVariables(new ArrayList());

        DefaultRubyParser parser = null;
        RubyParserResult result = null;
        try {
            parser = RubyParserPool.getInstance().borrowParser();
            parser.setWarnings(new NullWarnings());
            parser.init(config);
            result = parser.parse(LexerSource.getSource(input.toString(), reader));
        } catch (SyntaxException e) {
            // ignore the syntax exception
        } finally {
            RubyParserPool.getInstance().returnParser(parser);
        }
        reader.close();
        
        encoder.writeNode(result.getAST());
    }
}
