/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.event;

import fr.jayasoft.ivy.event.IvyEvent;
import fr.jayasoft.ivy.filter.AndFilter;
import fr.jayasoft.ivy.filter.Filter;
import fr.jayasoft.ivy.filter.NoFilter;
import fr.jayasoft.ivy.filter.NotFilter;
import fr.jayasoft.ivy.filter.OrFilter;
import fr.jayasoft.ivy.matcher.ExactPatternMatcher;
import fr.jayasoft.ivy.matcher.Matcher;
import fr.jayasoft.ivy.matcher.PatternMatcher;

public class IvyEventFilter
implements Filter {
    private static final String NOT = "NOT ";
    private static final String OR = " OR ";
    private static final String AND = " AND ";
    private PatternMatcher _matcher;
    private Filter _nameFilter;
    private Filter _attFilter;

    public IvyEventFilter(String event, String filterExpression, PatternMatcher matcher) {
        PatternMatcher patternMatcher = this._matcher = matcher == null ? ExactPatternMatcher.getInstance() : matcher;
        if (event == null) {
            this._nameFilter = NoFilter.INSTANCE;
        } else {
            final Matcher eventNameMatcher = this._matcher.getMatcher(event);
            this._nameFilter = new Filter(){

                public boolean accept(Object o) {
                    IvyEvent e = (IvyEvent)o;
                    return eventNameMatcher.matches(e.getName());
                }
            };
        }
        this._attFilter = filterExpression == null || filterExpression.trim().length() == 0 ? NoFilter.INSTANCE : this.parseExpression(filterExpression);
    }

    private Filter parseExpression(String filterExpression) {
        int index = (filterExpression = filterExpression.trim()).indexOf(AND);
        if (index == -1) {
            index = filterExpression.indexOf(OR);
            if (index == -1) {
                if (filterExpression.startsWith(NOT)) {
                    return new NotFilter(this.parseExpression(filterExpression.substring(NOT.length())));
                }
                index = filterExpression.indexOf("=");
                if (index == -1) {
                    throw new IllegalArgumentException("bad filter expression: " + filterExpression + ": no equal sign found");
                }
                final String attname = filterExpression.substring(0, index).trim();
                String[] values = filterExpression.substring(index + 1).trim().split(",");
                final Matcher[] matchers = new Matcher[values.length];
                for (int i = 0; i < values.length; ++i) {
                    matchers[i] = this._matcher.getMatcher(values[i].trim());
                }
                return new Filter(){

                    public boolean accept(Object o) {
                        IvyEvent e = (IvyEvent)o;
                        String val = (String)e.getAttributes().get(attname);
                        if (val == null) {
                            return false;
                        }
                        for (int i = 0; i < matchers.length; ++i) {
                            if (!matchers[i].matches(val)) continue;
                            return true;
                        }
                        return false;
                    }
                };
            }
            return new OrFilter(this.parseExpression(filterExpression.substring(0, index)), this.parseExpression(filterExpression.substring(index + OR.length())));
        }
        return new AndFilter(this.parseExpression(filterExpression.substring(0, index)), this.parseExpression(filterExpression.substring(index + AND.length())));
    }

    public boolean accept(Object o) {
        if (!(o instanceof IvyEvent)) {
            return false;
        }
        return this._nameFilter.accept(o) && this._attFilter.accept(o);
    }
}

