/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.resolver;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.ArtifactInfo;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.DependencyResolver;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.LatestStrategy;
import fr.jayasoft.ivy.ResolveData;
import fr.jayasoft.ivy.ResolvedModuleRevision;
import fr.jayasoft.ivy.report.ArtifactDownloadReport;
import fr.jayasoft.ivy.report.DownloadReport;
import fr.jayasoft.ivy.report.DownloadStatus;
import fr.jayasoft.ivy.resolver.AbstractResolver;
import fr.jayasoft.ivy.resolver.HasLatestStrategy;
import fr.jayasoft.ivy.resolver.ResolvedModuleRevisionProxy;
import fr.jayasoft.ivy.util.Message;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ChainResolver
extends AbstractResolver {
    private boolean _returnFirst = false;
    private List _chain = new ArrayList();
    private boolean _dual;

    public void add(DependencyResolver resolver) {
        this._chain.add(resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        data = new ResolveData(data, this.doValidate(data));
        ResolvedModuleRevision ret = null;
        ArrayList<Exception> errors = new ArrayList<Exception>();
        Iterator iter = this._chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            LatestStrategy oldLatest = this.setLatestIfRequired(resolver, this.getLatestStrategy());
            ResolvedModuleRevision mr = null;
            try {
                mr = resolver.getDependency(dd, data);
            }
            catch (Exception ex) {
                Message.verbose("problem occured while resolving " + dd + " with " + resolver + ": " + ex);
                errors.add(ex);
            }
            finally {
                if (oldLatest != null) {
                    ChainResolver.setLatest(resolver, oldLatest);
                }
            }
            this.checkInterrupted();
            if (mr == null) continue;
            boolean shouldReturn = this._returnFirst;
            if (!(shouldReturn |= !this.getIvy().getVersionMatcher().isDynamic(dd.getDependencyRevisionId()) && ret != null && !ret.getDescriptor().isDefault())) {
                String mrDesc = mr.getId() + (mr.getDescriptor().isDefault() ? "[default]" : "") + " from " + mr.getResolver().getName();
                Message.debug("\tchecking " + mrDesc + " against " + ret);
                if (ret == null) {
                    Message.debug("\tmodule revision kept as first found: " + mrDesc);
                    ret = mr;
                } else if (this.isAfter(mr, ret, data.getDate())) {
                    Message.debug("\tmodule revision kept as younger: " + mrDesc);
                    ret = mr;
                } else if (!mr.getDescriptor().isDefault() && ret.getDescriptor().isDefault()) {
                    Message.debug("\tmodule revision kept as better (not default): " + mrDesc);
                    ret = mr;
                } else {
                    Message.debug("\tmodule revision discarded as older: " + mrDesc);
                }
                if (this.getIvy().getVersionMatcher().isDynamic(dd.getDependencyRevisionId()) || ret.getDescriptor().isDefault()) continue;
                Message.debug("\tmodule revision found and is not default: returning " + mrDesc);
                return this.resolvedRevision(mr);
            }
            return this.resolvedRevision(mr);
        }
        if (ret == null && !errors.isEmpty()) {
            if (errors.size() == 1) {
                Exception ex = (Exception)errors.get(0);
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                if (ex instanceof ParseException) {
                    throw (ParseException)ex;
                }
                throw new RuntimeException(ex.toString(), ex);
            }
            StringBuffer err = new StringBuffer();
            Iterator iter2 = errors.iterator();
            while (iter2.hasNext()) {
                Exception ex = (Exception)iter2.next();
                err.append(ex).append("\n");
            }
            err.setLength(err.length() - 1);
            throw new RuntimeException("several problems occured while resolving " + dd + ":\n" + err);
        }
        return this.resolvedRevision(ret);
    }

    private ResolvedModuleRevision resolvedRevision(ResolvedModuleRevision mr) {
        if (this.isDual() && mr != null) {
            return new ResolvedModuleRevisionProxy(mr, this);
        }
        return mr;
    }

    private LatestStrategy setLatestIfRequired(DependencyResolver resolver, LatestStrategy latestStrategy) {
        String latestName = ChainResolver.getLatestStrategyName(resolver);
        if (latestName != null && !"default".equals(latestName)) {
            LatestStrategy oldLatest = ChainResolver.getLatest(resolver);
            ChainResolver.setLatest(resolver, latestStrategy);
            return oldLatest;
        }
        return null;
    }

    private boolean isAfter(ResolvedModuleRevision rmr1, ResolvedModuleRevision rmr2, Date date) {
        ArtifactInfo[] ais = new ArtifactInfo[]{new ResolvedModuleRevisionArtifactInfo(rmr2), new ResolvedModuleRevisionArtifactInfo(rmr1)};
        return this.getLatestStrategy().findLatest(ais, date) != ais[0];
    }

    public void reportFailure() {
        Iterator iter = this._chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            resolver.reportFailure();
        }
    }

    public void reportFailure(Artifact art) {
        Iterator iter = this._chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            resolver.reportFailure(art);
        }
    }

    public DownloadReport download(Artifact[] artifacts, Ivy ivy, File cache, boolean useOrigin) {
        ArrayList<Artifact> artifactsToDownload = new ArrayList<Artifact>(Arrays.asList(artifacts));
        DownloadReport report = new DownloadReport();
        Iterator iter = this._chain.iterator();
        while (iter.hasNext() && !artifactsToDownload.isEmpty()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            DownloadReport r = resolver.download(artifactsToDownload.toArray(new Artifact[artifactsToDownload.size()]), ivy, cache, useOrigin);
            ArtifactDownloadReport[] adr = r.getArtifactsReports();
            for (int i = 0; i < adr.length; ++i) {
                if (adr[i].getDownloadStatus() == DownloadStatus.FAILED) continue;
                artifactsToDownload.remove(adr[i].getArtifact());
                report.addArtifactReport(adr[i]);
            }
        }
        iter = artifactsToDownload.iterator();
        while (iter.hasNext()) {
            Artifact art = (Artifact)iter.next();
            ArtifactDownloadReport adr = new ArtifactDownloadReport(art);
            adr.setDownloadStatus(DownloadStatus.FAILED);
            report.addArtifactReport(adr);
        }
        return report;
    }

    public List getResolvers() {
        return this._chain;
    }

    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
        if (this._chain.isEmpty()) {
            throw new IllegalStateException("invalid chain resolver with no sub resolver");
        }
        ((DependencyResolver)this._chain.get(0)).publish(artifact, src, overwrite);
    }

    public boolean isReturnFirst() {
        return this._returnFirst;
    }

    public void setReturnFirst(boolean returnFirst) {
        this._returnFirst = returnFirst;
    }

    public void dumpConfig() {
        Message.verbose("\t" + this.getName() + " [chain] " + this._chain);
        Message.debug("\t\treturn first: " + this.isReturnFirst());
        Message.debug("\t\tdual: " + this.isDual());
        Iterator iter = this._chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver r = (DependencyResolver)iter.next();
            Message.debug("\t\t-> " + r.getName());
        }
    }

    public boolean exists(Artifact artifact) {
        Iterator iter = this._chain.iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            if (!resolver.exists(artifact)) continue;
            return true;
        }
        return false;
    }

    private static void setLatest(DependencyResolver resolver, LatestStrategy latest) {
        if (resolver instanceof HasLatestStrategy) {
            HasLatestStrategy r = (HasLatestStrategy)((Object)resolver);
            r.setLatestStrategy(latest);
        }
    }

    private static LatestStrategy getLatest(DependencyResolver resolver) {
        if (resolver instanceof HasLatestStrategy) {
            HasLatestStrategy r = (HasLatestStrategy)((Object)resolver);
            return r.getLatestStrategy();
        }
        return null;
    }

    private static String getLatestStrategyName(DependencyResolver resolver) {
        if (resolver instanceof HasLatestStrategy) {
            HasLatestStrategy r = (HasLatestStrategy)((Object)resolver);
            return r.getLatest();
        }
        return null;
    }

    public void setDual(boolean b) {
        this._dual = b;
    }

    public boolean isDual() {
        return this._dual;
    }

    public static class ResolvedModuleRevisionArtifactInfo
    implements ArtifactInfo {
        private ResolvedModuleRevision _rmr;

        public ResolvedModuleRevisionArtifactInfo(ResolvedModuleRevision rmr) {
            this._rmr = rmr;
        }

        public String getRevision() {
            return this._rmr.getId().getRevision();
        }

        public long getLastModified() {
            return this._rmr.getPublicationDate().getTime();
        }
    }
}

