/*
 * Decompiled with CFR 0.152.
 */
package org.jayasoft.ivyde.eclipse.ui.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jayasoft.ivyde.eclipse.ui.core.model.IValueProvider;
import org.jayasoft.ivyde.eclipse.ui.core.model.IvyFile;
import org.jayasoft.ivyde.eclipse.ui.core.model.IvyTagAttribute;
import org.jayasoft.ivyde.eclipse.ui.core.model.Proposal;

public class IvyTag {
    private IvyTag _parent;
    private String _name;
    private String _doc;
    private Map _attributes = new HashMap();
    private List _childs = new ArrayList();
    private boolean _allowNoChild = true;

    public IvyTag(String name) {
        this._name = name;
    }

    public IvyTag(String name, IvyTagAttribute[] atts) {
        this._name = name;
        int i = 0;
        while (i < atts.length) {
            this.addAttribute(atts[i]);
            ++i;
        }
    }

    public IvyTag(String name, String doc) {
        this._name = name;
        this._doc = doc;
    }

    public IvyTag(String name, String doc, IvyTagAttribute[] atts) {
        this._name = name;
        this._doc = doc;
        int i = 0;
        while (i < atts.length) {
            this.addAttribute(atts[i]);
            ++i;
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void addAttribute(IvyTagAttribute attribute) {
        attribute.setContainer(this);
        this._attributes.put(attribute.getName(), attribute);
    }

    public void addChildIvyTag(IvyTag att) {
        att.setParent(this);
        this._childs.add(att);
    }

    public boolean hasChild() {
        return this._childs.size() > 0;
    }

    public List getAttributes() {
        return new ArrayList(this._attributes.values());
    }

    public List getChilds() {
        return this._childs;
    }

    public String getEndTag() {
        if (this.getChilds().size() > 0) {
            return "</" + this.getName() + ">";
        }
        return "/>";
    }

    public String getStartTag() {
        return "<" + this.getName() + (this.getChilds().size() > 0 ? ">" : "");
    }

    public String getDoc() {
        return this._doc;
    }

    public void setDoc(String doc) {
        this._doc = doc;
    }

    public IvyTag getParent() {
        return this._parent;
    }

    void setParent(IvyTag parent) {
        this._parent = parent;
    }

    public String toString() {
        return this._name;
    }

    public String[] getPossibleValuesForAttribute(String att, IvyFile ivyfile) {
        IvyTagAttribute ivyTagAttribute = (IvyTagAttribute)this._attributes.get(att);
        if (ivyTagAttribute == null) {
            return null;
        }
        IValueProvider provider = ivyTagAttribute.getValueProvider();
        if (provider != null) {
            String qualifier = ivyfile.getAttributeValueQualifier();
            String[] values = provider.getValuesfor(ivyTagAttribute, ivyfile);
            if (values != null) {
                HashSet<String> ret = new HashSet<String>(values.length);
                int i = 0;
                while (i < values.length) {
                    if (values[i].startsWith(qualifier)) {
                        ret.add(values[i]);
                    }
                    ++i;
                }
                return ret.toArray(new String[ret.size()]);
            }
            return null;
        }
        System.out.println("No provider set for:" + att);
        return null;
    }

    public boolean isAllowNoChild() {
        return this._allowNoChild;
    }

    public void setAllowNoChild(boolean allowNoChild) {
        this._allowNoChild = allowNoChild;
    }

    public Proposal[] getProposals() {
        ArrayList<Proposal> ret = new ArrayList<Proposal>();
        String text = String.valueOf(this.getStartTag()) + this.getEndTag();
        int cursor = this.getStartTag().length();
        ret.add(new Proposal(text, cursor, this.getDoc()));
        if (this._allowNoChild && this.getChilds().size() > 0) {
            ret.add(new Proposal("<" + this.getName() + " />", cursor, this.getDoc()));
        }
        return ret.toArray(new Proposal[ret.size()]);
    }
}

