/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.browser.BrowserDescriptor;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.cgi.server.CustomBrowser;
import org.epic.debug.ui.PerlDebugImages;

public class LaunchConfigurationCGIBrowserTab
extends AbstractLaunchConfigurationTab {
    private Table browsersTable;
    private Label customBrowserPathLabel;
    private Text customBrowserPath;
    private Button customBrowserBrowse;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        Label description = new Label(comp, 0);
        description.setFont(font);
        description.setText("Browser used for showing HTML pages during CGI debugging:");
        this.browsersTable = new Table(comp, 2080);
        GridData gd = new GridData(1808);
        this.browsersTable.setLayoutData((Object)gd);
        this.browsersTable.setFont(font);
        this.browsersTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selEvent) {
                if (selEvent.detail == 32) {
                    TableItem item = (TableItem)selEvent.item;
                    if (item.getChecked()) {
                        TableItem[] items = LaunchConfigurationCGIBrowserTab.this.browsersTable.getItems();
                        int i = 0;
                        while (i < items.length) {
                            if (items[i] != item) {
                                items[i].setChecked(false);
                            }
                            ++i;
                        }
                    } else {
                        item.setChecked(true);
                    }
                    LaunchConfigurationCGIBrowserTab.this.setEnabledCustomBrowserPath();
                }
                LaunchConfigurationCGIBrowserTab.this.updateLaunchConfigurationDialog();
            }

            public void widgetDefaultSelected(SelectionEvent selEvent) {
                LaunchConfigurationCGIBrowserTab.this.updateLaunchConfigurationDialog();
            }
        });
        BrowserDescriptor[] aDescs = BrowserManager.getInstance().getBrowserDescriptors();
        int i = 0;
        while (i < aDescs.length) {
            TableItem item = new TableItem(this.browsersTable, 0);
            item.setText(aDescs[i].getLabel());
            item.setGrayed(aDescs.length == 1);
            ++i;
        }
        TableItem item = new TableItem(this.browsersTable, 0);
        item.setText("Built-in Browser");
        item.setGrayed(aDescs.length == 1);
        this.createCustomBrowserPathPart(comp);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        String attrBrowserID = null;
        String attrBrowserPath = null;
        try {
            attrBrowserID = config.getAttribute("ATTR_BROWSER_ID", null);
            attrBrowserPath = config.getAttribute("ATTR_CUSTOM_BROWSER_PATH", null);
        }
        catch (CoreException e) {
            DebugPlugin.log((Throwable)e);
        }
        TableItem[] items = this.browsersTable.getItems();
        BrowserDescriptor[] browsers = BrowserManager.getInstance().getBrowserDescriptors();
        if (attrBrowserID.equals("org.epic.core.views.browser.BrowserView")) {
            items[items.length - 1].setChecked(true);
        }
        int i = 0;
        while (i < browsers.length) {
            if (browsers[i].getID().equals(attrBrowserID)) {
                items[i].setChecked(true);
            }
            ++i;
        }
        this.customBrowserPath.setText(attrBrowserPath);
        this.setEnabledCustomBrowserPath();
    }

    protected void updateParamsFromConfig(ILaunchConfiguration config) {
        this.initializeFrom(config);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        TableItem[] items = this.browsersTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                String browserID = i == items.length - 1 ? "org.epic.core.views.browser.BrowserView" : BrowserManager.getInstance().getBrowserDescriptors()[i].getID();
                config.setAttribute("ATTR_BROWSER_ID", browserID);
                break;
            }
            ++i;
        }
        config.setAttribute("ATTR_CUSTOM_BROWSER_PATH", this.customBrowserPath.getText());
    }

    public String getBrowserID() {
        TableItem[] items = this.browsersTable.getItems();
        if (items[items.length - 1].getChecked()) {
            return "org.epic.core.views.browser.BrowserView";
        }
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                String browserID = BrowserManager.getInstance().getBrowserDescriptors()[i].getID();
                return browserID;
            }
            ++i;
        }
        return null;
    }

    public void dispose() {
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (CustomBrowser.isCustomBrowserID(this.getBrowserID()) && (this.customBrowserPath.getText() == null || this.customBrowserPath.getText().length() == 0)) {
            this.setErrorMessage("Specify Custom BrowserProject");
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        Preferences pref = HelpPlugin.getDefault().getPluginPreferences();
        String browserPath = pref.getString("custom_browser_path");
        config.setAttribute("ATTR_BROWSER_ID", BrowserManager.getInstance().getDefaultBrowserID());
        config.setAttribute("ATTR_CUSTOM_BROWSER_PATH", browserPath);
    }

    public String getName() {
        return "Browser";
    }

    public Image getImage() {
        return PerlDebugPlugin.getDefaultDesciptorImageRegistry().get(PerlDebugImages.DESC_OBJS_LaunchTabCGI);
    }

    private void setEnabledCustomBrowserPath() {
        TableItem[] items = this.browsersTable.getItems();
        int i = 0;
        while (i < items.length - 1) {
            if (items[i].getChecked()) {
                boolean enabled = "org.eclipse.help.base.custombrowser".equals(BrowserManager.getInstance().getBrowserDescriptors()[i].getID());
                this.customBrowserPathLabel.setEnabled(enabled);
                this.customBrowserPath.setEnabled(enabled);
                this.customBrowserBrowse.setEnabled(enabled);
                break;
            }
            ++i;
        }
    }

    protected void createCustomBrowserPathPart(Composite mainComposite) {
        Font font = mainComposite.getFont();
        new Label(mainComposite, 0);
        Composite bPathComposite = new Composite(mainComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        bPathComposite.setLayout((Layout)layout);
        bPathComposite.setLayoutData((Object)new GridData(768));
        this.customBrowserPathLabel = new Label(bPathComposite, 16384);
        this.customBrowserPathLabel.setFont(font);
        this.customBrowserPath = new Text(bPathComposite, 2048);
        this.customBrowserPath.setLayoutData((Object)new GridData(768));
        this.customBrowserPath.setFont(font);
        this.customBrowserPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                LaunchConfigurationCGIBrowserTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.customBrowserBrowse = new Button(bPathComposite, 0);
        this.customBrowserBrowse.setFont(font);
        this.customBrowserBrowse.setText("Select Custom Browser");
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        this.customBrowserBrowse.setLayoutData((Object)data);
        this.customBrowserBrowse.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                FileDialog d = new FileDialog(LaunchConfigurationCGIBrowserTab.this.getShell());
                d.setText("CustomBrowserPreferencePage.Details");
                String file = d.open();
                if (file != null) {
                    LaunchConfigurationCGIBrowserTab.this.customBrowserPath.setText("\"" + file + "\" %1");
                }
            }
        });
        this.setEnabledCustomBrowserPath();
    }
}

