/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.editors;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.editors.PartitionTypes;

public class PerlPairMatcher
implements ICharacterPairMatcher {
    private static final char NO_PRETENDED_CHAR = '\u0000';
    private final ILog log;
    private ISourceViewer viewer;
    private IDocument fDocument;
    private int fOffset;
    private int fStartPos;
    private int fEndPos;
    private int fAnchor;
    private static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};

    public PerlPairMatcher(ILog log) {
        this.log = log;
    }

    public IRegion match(IDocument document, int offset) {
        this.fOffset = offset;
        if (this.fOffset < 0) {
            return null;
        }
        this.fDocument = document;
        if (this.fDocument != null && this.fDocument.getLength() > 0 && this.matchPairsAt('\u0000') && this.fStartPos != this.fEndPos) {
            return new Region(this.fStartPos, this.fEndPos - this.fStartPos + 1);
        }
        return null;
    }

    public IRegion match(IDocument document, int offset, char pretendPrevChar) {
        this.fOffset = offset;
        if (this.fOffset < 0) {
            return null;
        }
        this.fDocument = document;
        if (this.fDocument != null && this.fDocument.getLength() > 0 && this.matchPairsAt(pretendPrevChar) && this.fStartPos != this.fEndPos) {
            return new Region(this.fStartPos, this.fEndPos - this.fStartPos + 1);
        }
        return null;
    }

    public void setViewer(ISourceViewer viewer) {
        this.viewer = viewer;
    }

    public int getAnchor() {
        return this.fAnchor;
    }

    public int getEndPos() {
        return this.fEndPos;
    }

    public int getStartPos() {
        return this.fStartPos;
    }

    public void dispose() {
        this.clear();
        this.fDocument = null;
    }

    public void clear() {
    }

    private boolean matchPairsAt(char pretendPrevChar) {
        int pairIndex1 = BRACKETS.length;
        int pairIndex2 = BRACKETS.length;
        this.fStartPos = -1;
        this.fEndPos = -1;
        try {
            boolean pretendPeer = pretendPrevChar != '\u0000';
            char prevChar = pretendPeer ? pretendPrevChar : this.fDocument.getChar(Math.max(this.fOffset - 1, 0));
            int i = 0;
            while (i < BRACKETS.length) {
                if (prevChar == BRACKETS[i]) {
                    this.fStartPos = this.fOffset - 1;
                    pairIndex1 = i;
                }
                i += 2;
            }
            i = 1;
            while (i < BRACKETS.length) {
                if (prevChar == BRACKETS[i]) {
                    this.fEndPos = this.fOffset - 1;
                    pairIndex2 = i;
                }
                i += 2;
            }
            if (this.fEndPos > -1) {
                this.fAnchor = 0;
                this.fStartPos = this.searchForOpeningPeer(this.fEndPos, BRACKETS[pairIndex2 - 1], BRACKETS[pairIndex2], this.fDocument, pretendPeer);
                if (this.fStartPos > -1) {
                    return true;
                }
                this.fEndPos = -1;
            } else if (this.fStartPos > -1) {
                this.fAnchor = 1;
                this.fEndPos = this.searchForClosingPeer(this.fStartPos, BRACKETS[pairIndex1], BRACKETS[pairIndex1 + 1], this.fDocument, pretendPeer);
                if (this.fEndPos > -1) {
                    return true;
                }
                this.fStartPos = -1;
            }
        }
        catch (BadLocationException e) {
            this.log.log((IStatus)new Status(4, PerlEditorPlugin.getPluginId(), 0, "Unexpected exception; report it as a bug in plug-in " + PerlEditorPlugin.getPluginId(), (Throwable)e));
        }
        return false;
    }

    private int searchForClosingPeer(int offset, char openingPeer, char closingPeer, IDocument document, boolean pretendPeer) throws BadLocationException {
        int end = this.viewer != null ? Math.min(this.viewer.getBottomIndexEndOffset() + 1, document.getLength()) : document.getLength();
        return this.searchForPeer(offset, end, closingPeer, openingPeer, 1, document, pretendPeer);
    }

    private int searchForOpeningPeer(int offset, char openingPeer, char closingPeer, IDocument document, boolean pretendPeer) throws BadLocationException {
        int end = this.viewer != null ? Math.max(this.viewer.getTopIndexStartOffset(), 0) : 0;
        return this.searchForPeer(offset, end, openingPeer, closingPeer, -1, document, pretendPeer);
    }

    private int searchForPeer(int start, int end, char searchFor, char searchFrom, int direction, IDocument document, boolean pretendPeer) throws BadLocationException {
        String text;
        int max;
        int n = 0;
        int i = start;
        int min = start < end ? start : end;
        int n2 = max = start > end ? start + 1 : end;
        if (start > end && pretendPeer) {
            ++n;
            --i;
            --max;
        }
        if ((text = document.get(min, max - min)).length() == 0) {
            return -1;
        }
        String partitionType = PartitionTypes.getPerlPartition(document, i).getType();
        boolean inLiteralOrComment = this.isLiteralOrComment(partitionType);
        while (direction == 1 && i < end || direction == -1 && i >= end) {
            char c = text.charAt(i - min);
            if (c == searchFor || c == searchFrom) {
                int prevI = i;
                if ((i = this.checkCurrentPartition(document, inLiteralOrComment, i, direction, partitionType)) == -1) break;
                if (i != prevI) continue;
            }
            if (c == searchFor && --n == 0) {
                return i;
            }
            if (c == searchFrom) {
                ++n;
            }
            i += direction;
        }
        return -1;
    }

    private boolean isLiteralOrComment(String partitionType) {
        return partitionType.indexOf("LITERAL1") != -1 || partitionType.indexOf("LITERAL2") != -1 || partitionType.indexOf("COMMENT") != -1;
    }

    private int checkCurrentPartition(IDocument document, boolean inLiteralOrComment, int i, int direction, String partitionType) throws BadLocationException {
        if (inLiteralOrComment) {
            if (!PartitionTypes.getPerlPartition(document, i).getType().equals(partitionType)) {
                return -1;
            }
        } else {
            ITypedRegion partition = PartitionTypes.getPerlPartition(document, i);
            if (this.isLiteralOrComment(partition.getType())) {
                int startIndex = partition.getOffset();
                int endIndex = startIndex + partition.getLength();
                return direction == 1 ? endIndex : startIndex - 1;
            }
        }
        return i;
    }
}

