(load "elf/basic.scm")

;;; JScheme does not provide access to private or protected fields,
;;; because such access may not work, for example in a browser.

;;; The following functions can be used to do that when you really
;;; need to.

(define (find-field class name)
  (find (lambda (f) (.equals (.getName f) name)) ; Memoizable.
	(all-fields class)))		; From elf/describe.scm

(define (field object name)
  (.get (find-field (.getClass object) (.toString name)) object))

(define (field-set! object name value)
  (.set (find-field (.getClass object) (.toString name)) object value))

(define (static-field class name)
  (.get (find-field class (.toString name)) class))

(define (static-field-set! class name value)
  (.set (find-field class (.toString name)) class value))
