;;;
;;; Interface jscheme to psyntax.
;;;

(define void
    (lambda () #null))

(define andmap
    (lambda (f first . rest)
      (or (null? first)
	  (if (null? rest)
	      (let andmap ((first first))
		   (let ((x (car first)) (first (cdr first)))
		     (if (null? first)
			 (f x)
		       (and (f x) (andmap first)))))
            (let andmap ((first first) (rest rest))
		 (let ((x (car first))
		       (xr (map car rest))
		       (first (cdr first))
		       (rest (map cdr rest)))
		   (if (null? first)
		       (apply f (cons x xr))
		     (and (apply f (cons x xr)) (andmap first rest)))))))))

(define ormap
  (lambda (proc list1)
    (and (not (null? list1))
         (or (proc (car list1)) (ormap proc (cdr list1))))))

(define current-eval
  (let ((original-eval eval))
    (lambda args
      (if (null? args) original-eval
	  (set! eval (car args))))))

;;; Just use Jscheme's error for now.
'(define error
  ;; Need something better here.
  (let ((original-error error))
    (lambda (who format-string why what)
      (original-error (string-append "Error in " who ": " why " " what".")))))

(define gensym
  (let ((c 0))
    (lambda ()
      (string->symbol (string-append "g" (set! c (+ c 1)))))))

(define property-table (Hashtable.))
(define getprop
  (lambda (symbol key)
    (let ((it (assoc key (cdr (%getprops symbol)))))
      (if it (cdr it)))))

(define %getprops
  (lambda (symbol)
    (let ((props (.get property-table symbol)))
      (if (eq? props #null)
	  (let ((props (list symbol)))
	    (.put property-table symbol props)
	    props)
	  props))))

(define putprop
  (lambda (symbol key value)
    (let* ((props (%getprops symbol))
	   (it (assoc key (cdr props))))
      (if it (let ((old-value (cdr it)))
	       (set-cdr! it value)
	       old-value)
	  (begin 
	    (set-cdr! props (cons (cons key value) (cdr props)))
	    #f)))))

(define remprop
  (lambda (symbol key)
    (define (remprop0 props key)
      (if (null? (cdr props)) #f
	  (if (eq? (car (car (cdr props))) key)
	      (set-cdr! props (cdr (cdr props)))
	      (remprop0 (cdr props) key))))

    (let ((props (%getprops symbol)))
      (remprop0 props key))))

;;; JScheme is r4rs, but values is r54s.  This is a hack.
;;; Please provide something better.
(define values list)

(define call-with-values
  (lambda (provider consumer)
    (apply consumer (provider))))

(define self-evaluating?
  (lambda (x)
    (or (boolean? x) (number? x) (string? x) (char? x) (null? x)
	(eq? x #null))))

(load "jscheme/psyntax.pp")

(define old-eval (current-eval))

(current-eval (lambda (x . $ignore)
		;; The ignore is for the calls to r5rs eval in eopl2.
		(old-eval (sc-expand x))))

;;; At this point define-syntax rules!