;;; http://sax.sourceforge.net
;;; You need SAX 2.0 for this, like http://xml.apache.org/xerces-j/
(define-class
  ;; This class is a SAXHandler that converts the XML input into a
  ;; symbolic expression.

  ;; Relatively naive structure sharing is used save storage space.
  ;; While DOM can be 10 times the size of the input XML, with
  ;; structure sharing, the resulting s-expression can be about the
  ;; same size as the XML text.

  ;; Sample usage:
  ;; (.parse (elf.SaxExp.)
  ;;   (java.net.URL. "http://www.w3.org/1999/02/22-rdf-syntax-ns"))

  (package elf)

  (import java.io.Reader)
  (import java.util.Hashtable)
  (import org.xml.sax.Attributes)
  (import org.xml.sax.InputSource)
  (import org.xml.sax.Locator)
  (import org.xml.sax.SAXParseException)
  (import org.xml.sax.helpers.DefaultHandler)
  (import jsint.Pair)

  (public class SaxExp extends DefaultHandler)

  (public SaxExp () #f)

  (static
   (load "elf/classpath.scm")
   (import "org.xml.sax.helpers.XMLReaderFactory")
   (import "org.xml.sax.InputSource")

   ;; Tell SAX what parser to use.
   (System.setProperty "org.xml.sax.driver"
		       "org.apache.xerces.parsers.SAXParser")
   )

  ;; Parse XML in Reader to SEXP
  (public Object parse (Reader reader)
	  (let ((xr (XMLReaderFactory.createXMLReader)))
	    (.setContentHandler xr this)
	    (.setErrorHandler xr this)
	    (.parse xr (InputSource. reader)))
	  (let ((result (.pop this)))
	    (.clear (.table$ this))
	    (.stack$ this '())
	    result))

  (public Object parse (java.net.URL url)
	  (.parse this (java.io.BufferedReader. (java.io.InputStreamReader.
					    (.openStream url)))))
  ;; Intern to share structure.
  (public Hashtable table = (java.util.Hashtable. 500))
  (public Object intern (Object x)
	  (let ((it (.get (.table$ this) x)))
	    (if (isNull it)
		(begin (.put (.table$ this) x x)
		       x)
		it)))

  ;; Component stack.
  (public Pair stack = '())
  (public Object top ()
	  (if (null? (.stack$ this))
	      (error this " stack is null!"))
	  (car (.stack$ this)))

  (public void push(Object x)
	  (.stack$ this (cons x (.stack$ this)))) 
  (public Object pop ()
	  (if (null? (.stack$ this))
	      (error this " stack is null!"))
	  (let ((pairs (.stack$ this)))
	    (.stack$ this (cdr pairs))
	    (car pairs)))

  ;; Override the DefaultHandler methods:
  (public void characters(char[] ch int start int length)
	  (let ((s (String. ch start length)))
	    (if (string? (.top this))
		(.push this (string-append (.pop this) s))
		(.push this s))))

  (public void endDocument() #f)
  
  (public void endElement(String uri String localName String qName)
	  (let ((name (string->symbol qName)))
	    (let loop ((it (.top this))
		       (sofar '()))
	      (if (or (eq? it name) (and (pair? it) (eq? (car it) name)))
		  (.push this (cons (.pop this) sofar))
		  (let ((sofar (cons (.pop this) sofar)))
		    (loop (.top this) sofar))))))

  (public void endPrefixMapping(String prefix)
	  (print `(endPrefixMapping ,prefix)))

  (public void error(SAXParseException e)
	  (throw e))

  (public void fatalError(SAXParseException e)
	  (throw e))

  (public void ignorableWhitespace(char[] ch int start int length) #f)

  (public void notationDecl(String name String publicId String systemId)
	  (print `(notationDecl ,name ,publicId ,systemId)))
  
  (public void processingInstruction(String target String data)
	  (print `(processingInstruction ,target ,data)))

  (public InputSource resolveEntity(String publicId String systemId)
	       ;; Default behavior is to return null.
	       #null)

  (public void setDocumentLocator(Locator locator) #f)
  
  (public void skippedEntity(String name)
	  (print `(skippedEntry ,name)))
	  
  (public void startDocument() #f)

  (public void startElement
	  (String uri String localName String qName Attributes attributes)
	  (define (mapAttributes as f)
	    (define (attributes0 i)
	      (if (< i (.getLength as))
		  (cons (f as i) (attributes0 (+ i 1)))
		  '()))
	    (attributes0 0))
	  (define (makeAttribute as i)
	    (let ((type (.getType as i))
		  (value (.getValue as i)))
	      (if (not (equal? type "CDATA"))
		  (.intern this `(,(string->symbol (.getQName as i))
			     ,(string->symbol value)))
		  `(,(string->symbol (.getQName as i))
		    ,value))))
	  (let* ((as (mapAttributes attributes makeAttribute))
		 (element (if (null? as) (string->symbol qName)
			      (cons (string->symbol qName) as))))
	    (.push this element)))

  (public void startPrefixMapping(String prefix String uri)
	  (print `(statPrefixMapping ,prefix ,uri)))

  (public void unparsedEntityDecl
	  (String name String publicId String systemId String notationName)
	  (print `(unparseEntityDecl ,name ,publicId ,systemId
				     ,notationName)))

  (public void warning(SAXParseException e)
	  (jsint.E.warn e))
  )
