/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import jscheme.SchemeSymbol;
import jsint.E;
import jsint.Import;
import jsint.JavaConstructor;
import jsint.JavaField;
import jsint.JavaMethod;
import jsint.U;

public class Symbol
implements Serializable,
SchemeSymbol {
    private String name;
    private Object globalValue = U.UNDEFINED;
    public static final Hashtable symbolTable = new Hashtable(500);
    public static final Symbol BEGIN = Symbol.intern("begin");
    public static final Symbol CAR = Symbol.intern("car");
    public static final Symbol CDR = Symbol.intern("cdr");
    public static final Symbol DEFINE = Symbol.intern("define");
    public static final Symbol IF = Symbol.intern("if");
    public static final Symbol LAMBDA = Symbol.intern("lambda");
    public static final Symbol MACRO = Symbol.intern("macro");
    public static final Symbol NEWLINE = Symbol.intern("newline");
    public static final Symbol NULL = Symbol.intern("null");
    public static final Symbol OR = Symbol.intern("or");
    public static final Symbol QUASIQUOTE = Symbol.intern("quasiquote");
    public static final Symbol QUOTE = Symbol.intern("quote");
    public static final Symbol SET = Symbol.intern("set!");
    public static final Symbol SPACE = Symbol.intern("space");
    public static final Symbol UNQUOTE = Symbol.intern("unquote");
    public static final Symbol UNQUOTE_SPLICING = Symbol.intern("unquote-splicing");
    public static final Symbol PACKAGE = Symbol.intern("package");

    public static void reset() {
        Enumeration E2 = symbolTable.elements();
        while (E2.hasMoreElements()) {
            ((Symbol)E2.nextElement()).globalValue = U.UNDEFINED;
        }
    }

    private Symbol(String name) {
        this.name = name;
    }

    public static synchronized Symbol intern(String name) {
        Symbol result = (Symbol)symbolTable.get(name);
        if (result == null) {
            result = new Symbol(name);
            symbolTable.put(name, result);
        }
        return result;
    }

    public Object getGlobalValue() {
        Object value;
        if (this.globalValue == U.UNDEFINED && (value = Symbol.lookupGlobal(this)) != null) {
            this.globalValue = value;
        }
        if (this.globalValue != U.UNDEFINED) {
            if (this.globalValue instanceof JavaField && ((JavaField)this.globalValue).isStatic) {
                return ((JavaField)this.globalValue).apply(U.NO_ARGS);
            }
            return this.globalValue;
        }
        return E.error("ERROR: undefined variable \"" + this.name + "\"");
    }

    public boolean isDefined() {
        return this.globalValue != U.UNDEFINED;
    }

    public synchronized Object setGlobalValue(Object newval) {
        Object value;
        if (this.globalValue == U.UNDEFINED && (value = Symbol.lookupGlobal(this)) != null) {
            this.globalValue = value;
        }
        if (this.globalValue instanceof JavaField && ((JavaField)this.globalValue).isStatic) {
            return ((JavaField)this.globalValue).apply(new Object[]{newval});
        }
        this.globalValue = newval;
        return this.globalValue;
    }

    public String toString() {
        return this.name;
    }

    static Object lookupGlobal(Symbol var) {
        String fullname;
        String name = fullname = var.toString();
        boolean canAccessPrivateData = false;
        if (fullname.endsWith("#")) {
            canAccessPrivateData = true;
            name = fullname.substring(0, name.length() - 1);
        }
        int firstIndex = name.indexOf(46);
        int lastIndex = name.lastIndexOf(46);
        int fieldIndex = name.lastIndexOf(36);
        int nameLength = name.length();
        Serializable value = null;
        if (firstIndex == -1) {
            return null;
        }
        try {
            if (fieldIndex == nameLength - 1) {
                value = firstIndex == 0 ? (lastIndex > 0 ? new JavaField(name.substring(lastIndex + 1, nameLength - 1), Import.classNamed(name.substring(1, lastIndex)), canAccessPrivateData) : new JavaField(name.substring(1, nameLength - 1), null, canAccessPrivateData)) : new JavaField(name.substring(lastIndex + 1, nameLength - 1), Import.classNamed(name.substring(0, lastIndex)), canAccessPrivateData);
            } else if (firstIndex == 0) {
                if (nameLength == 1) {
                    return var;
                }
                value = lastIndex > 0 ? new JavaMethod(name.substring(lastIndex + 1, nameLength), Import.classNamed(name.substring(1, lastIndex)), false, canAccessPrivateData) : new JavaMethod(name.substring(1, nameLength), null, false, canAccessPrivateData);
            } else {
                String methodName;
                value = lastIndex == nameLength - 1 ? new JavaConstructor(Import.classNamed(name.substring(0, lastIndex)).getName(), canAccessPrivateData) : ("class".equals(methodName = name.substring(lastIndex + 1, nameLength)) ? Import.classNamed(name.substring(0, lastIndex)) : new JavaMethod(name.substring(lastIndex + 1, nameLength), Import.classNamed(name.substring(0, lastIndex)), true, canAccessPrivateData));
            }
            return value;
        }
        catch (Exception e) {
            System.err.println("Javadot WARNING: " + e.getMessage());
            return null;
        }
    }

    static {
        Symbol.intern((String)"null").globalValue = null;
    }
}

