/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import jsint.E;
import jsint.Pair;
import jsint.U;

public class Op {
    public static final int ADD = 0;
    public static final int SUB = 1;
    public static final int MUL = 2;
    public static final int DIV = 3;
    public static final int MOD = 4;
    public static final int AND = 5;
    public static final int OR = 6;
    public static final int XOR = 7;
    public static final int IMP = 8;
    public static final int LSH = 9;
    public static final int RSH = 10;
    public static final int RSHZ = 11;
    public static final int EQ = 12;
    public static final int LT = 13;
    public static final int GT = 14;
    public static final int LE = 15;
    public static final int GE = 16;
    public static final int NE = 17;
    public static final int COMPLEMENT = 18;
    public static final int NEGATE = 19;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;

    public static Number add(Object a, Object b) {
        return Op.genericBinaryOp(0, a, b);
    }

    public static Number sub(Object a, Object b) {
        return Op.genericBinaryOp(1, a, b);
    }

    public static Number mul(Object a, Object b) {
        return Op.genericBinaryOp(2, a, b);
    }

    public static Number div(Object a, Object b) {
        return Op.genericBinaryOp(3, a, b);
    }

    public static Number mod(Object a, Object b) {
        return Op.genericBinaryOp(4, a, b);
    }

    public static Number negate(Object a) {
        return Op.genericUnaryOp(19, a);
    }

    public static Number complement(Object a) {
        return Op.genericUnaryOp(18, a);
    }

    public static Number leftShift(Object a, Object b) {
        return Op.genericBinaryOp(9, a, b);
    }

    public static Number rightShift(Object a, Object b) {
        return Op.genericBinaryOp(10, a, b);
    }

    public static Number rightShiftZ(Object a, Object b) {
        return Op.genericBinaryOp(11, a, b);
    }

    public static boolean eq(Object a, Object b) {
        return Op.genericBinaryComp(12, a, b);
    }

    public static boolean lt(Object a, Object b) {
        return Op.genericBinaryComp(13, a, b);
    }

    public static boolean gt(Object a, Object b) {
        return Op.genericBinaryComp(14, a, b);
    }

    public static boolean le(Object a, Object b) {
        return Op.genericBinaryComp(15, a, b);
    }

    public static boolean ge(Object a, Object b) {
        return Op.genericBinaryComp(16, a, b);
    }

    public static boolean ne(Object a, Object b) {
        return Op.genericBinaryComp(17, a, b);
    }

    public static Number and(Object a, Object b) {
        return Op.genericBinaryOp(5, a, b);
    }

    public static Number xor(Object a, Object b) {
        return Op.genericBinaryOp(7, a, b);
    }

    public static Number or(Object a, Object b) {
        return Op.genericBinaryOp(6, a, b);
    }

    public static Number imp(Object a, Object b) {
        return Op.genericBinaryOp(8, a, b);
    }

    public static Number genericBinaryMultiOp(int op, Number acc, Pair args) {
        while (args != Pair.EMPTY) {
            acc = Op.genericBinaryOp(op, acc, args.first);
            args = (Pair)args.rest;
        }
        return acc;
    }

    private static Number genericBinaryOp(int op, Object a, Object b) {
        Class c = Op.lubNumericClass(a.getClass(), b.getClass());
        if (c == (class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Op.binaryOpInteger(op, (Integer)Op.coerceNumber(a, class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer), (Integer)Op.coerceNumber(b, class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer));
        }
        if (c == (class$java$lang$Long == null ? (class$java$lang$Long = Op.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Op.binaryOpLong(op, (Long)Op.coerceNumber(a, class$java$lang$Long == null ? (class$java$lang$Long = Op.class$("java.lang.Long")) : class$java$lang$Long), (Long)Op.coerceNumber(b, class$java$lang$Long == null ? (class$java$lang$Long = Op.class$("java.lang.Long")) : class$java$lang$Long));
        }
        if (c == (class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Op.binaryOpFloat(op, (Float)Op.coerceNumber(a, class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float), (Float)Op.coerceNumber(b, class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float));
        }
        if (c == (class$java$lang$Double == null ? (class$java$lang$Double = Op.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Op.binaryOpDouble(op, (Double)Op.coerceNumber(a, class$java$lang$Double == null ? (class$java$lang$Double = Op.class$("java.lang.Double")) : class$java$lang$Double), (Double)Op.coerceNumber(b, class$java$lang$Double == null ? (class$java$lang$Double = Op.class$("java.lang.Double")) : class$java$lang$Double));
        }
        return Op.wrongTypeError(a, b);
    }

    private static boolean genericBinaryComp(int op, Object a, Object b) {
        Class c = Op.lubNumericClass(a.getClass(), b.getClass());
        if (c == (class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Op.binaryCompInteger(op, (Integer)Op.coerceNumber(a, class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer), (Integer)Op.coerceNumber(b, class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer));
        }
        if (c == (class$java$lang$Long == null ? (class$java$lang$Long = Op.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Op.binaryCompLong(op, (Long)Op.coerceNumber(a, class$java$lang$Long == null ? (class$java$lang$Long = Op.class$("java.lang.Long")) : class$java$lang$Long), (Long)Op.coerceNumber(b, class$java$lang$Long == null ? (class$java$lang$Long = Op.class$("java.lang.Long")) : class$java$lang$Long));
        }
        if (c == (class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Op.binaryCompFloat(op, (Float)Op.coerceNumber(a, class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float), (Float)Op.coerceNumber(b, class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float));
        }
        if (c == (class$java$lang$Double == null ? (class$java$lang$Double = Op.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Op.binaryCompDouble(op, (Double)Op.coerceNumber(a, class$java$lang$Double == null ? (class$java$lang$Double = Op.class$("java.lang.Double")) : class$java$lang$Double), (Double)Op.coerceNumber(b, class$java$lang$Double == null ? (class$java$lang$Double = Op.class$("java.lang.Double")) : class$java$lang$Double));
        }
        Op.wrongTypeError(a, b);
        return false;
    }

    private static Number genericUnaryOp(int op, Object a) {
        Class c = Op.lubNumericClass(a.getClass(), class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer);
        if (c == (class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return Op.unaryOpInteger(op, (Integer)Op.coerceNumber(a, class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer));
        }
        if (c == (class$java$lang$Long == null ? (class$java$lang$Long = Op.class$("java.lang.Long")) : class$java$lang$Long)) {
            return Op.unaryOpLong(op, (Long)Op.coerceNumber(a, class$java$lang$Long == null ? (class$java$lang$Long = Op.class$("java.lang.Long")) : class$java$lang$Long));
        }
        if (c == (class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float)) {
            return Op.unaryOpFloat(op, (Float)Op.coerceNumber(a, class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float));
        }
        if (c == (class$java$lang$Double == null ? (class$java$lang$Double = Op.class$("java.lang.Double")) : class$java$lang$Double)) {
            return Op.unaryOpDouble(op, (Double)Op.coerceNumber(a, class$java$lang$Double == null ? (class$java$lang$Double = Op.class$("java.lang.Double")) : class$java$lang$Double));
        }
        return Op.wrongTypeError(a);
    }

    private static Number coerceNumber(Object a, Class c) {
        if (a instanceof Number) {
            if (a.getClass() == c) {
                return (Number)a;
            }
            if (c == (class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return new Integer(((Number)a).intValue());
            }
            if (c == (class$java$lang$Double == null ? (class$java$lang$Double = Op.class$("java.lang.Double")) : class$java$lang$Double)) {
                return new Double(((Number)a).doubleValue());
            }
            if (c == (class$java$lang$Long == null ? (class$java$lang$Long = Op.class$("java.lang.Long")) : class$java$lang$Long)) {
                return new Long(((Number)a).longValue());
            }
            if (c == (class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float)) {
                return new Float(((Number)a).floatValue());
            }
            return (Number)E.error("Bad coersion " + a + " to " + c);
        }
        if (a instanceof Character) {
            return Op.coerceNumber(new Integer(((Character)a).charValue()), c);
        }
        return (Number)E.error("Bad coersion " + a + " to " + c);
    }

    public static Character numberToChar(Number a) {
        return new Character((char)a.shortValue());
    }

    public static Number charToNumber(Character a) {
        return new Integer(a.charValue());
    }

    public static Class lubNumericClass(Class a, Class b) {
        if (a == (class$java$lang$Byte == null ? (class$java$lang$Byte = Op.class$("java.lang.Byte")) : class$java$lang$Byte) || a == (class$java$lang$Short == null ? (class$java$lang$Short = Op.class$("java.lang.Short")) : class$java$lang$Short) || a == (class$java$lang$Character == null ? (class$java$lang$Character = Op.class$("java.lang.Character")) : class$java$lang$Character)) {
            a = class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (b == (class$java$lang$Byte == null ? (class$java$lang$Byte = Op.class$("java.lang.Byte")) : class$java$lang$Byte) || b == (class$java$lang$Short == null ? (class$java$lang$Short = Op.class$("java.lang.Short")) : class$java$lang$Short) || b == (class$java$lang$Character == null ? (class$java$lang$Character = Op.class$("java.lang.Character")) : class$java$lang$Character)) {
            b = class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (a == (class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            if (b == (class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            if (b == (class$java$lang$Long == null ? (class$java$lang$Long = Op.class$("java.lang.Long")) : class$java$lang$Long)) {
                return class$java$lang$Long == null ? (class$java$lang$Long = Op.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (b == (class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float)) {
                return class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float;
            }
            return class$java$lang$Double == null ? (class$java$lang$Double = Op.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (a == (class$java$lang$Long == null ? (class$java$lang$Long = Op.class$("java.lang.Long")) : class$java$lang$Long)) {
            if (b == (class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return class$java$lang$Long == null ? (class$java$lang$Long = Op.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (b == (class$java$lang$Long == null ? (class$java$lang$Long = Op.class$("java.lang.Long")) : class$java$lang$Long)) {
                return class$java$lang$Long == null ? (class$java$lang$Long = Op.class$("java.lang.Long")) : class$java$lang$Long;
            }
            if (b == (class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float)) {
                return class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float;
            }
            return class$java$lang$Double == null ? (class$java$lang$Double = Op.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (a == (class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float)) {
            if (b == (class$java$lang$Integer == null ? (class$java$lang$Integer = Op.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                return class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (b == (class$java$lang$Long == null ? (class$java$lang$Long = Op.class$("java.lang.Long")) : class$java$lang$Long)) {
                return class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float;
            }
            if (b == (class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float)) {
                return class$java$lang$Float == null ? (class$java$lang$Float = Op.class$("java.lang.Float")) : class$java$lang$Float;
            }
            return class$java$lang$Double == null ? (class$java$lang$Double = Op.class$("java.lang.Double")) : class$java$lang$Double;
        }
        return class$java$lang$Double == null ? (class$java$lang$Double = Op.class$("java.lang.Double")) : class$java$lang$Double;
    }

    private static Integer unaryOpInteger(int op, Integer a) {
        int a1 = a;
        int c = 0;
        switch (op) {
            case 18: {
                c = ~a1;
                break;
            }
            case 19: {
                c = -a1;
                break;
            }
            default: {
                Op.unknownOpError("unaryOp", op);
            }
        }
        return new Integer(c);
    }

    private static Long unaryOpLong(int op, Long a) {
        long a1 = a;
        long c = 0L;
        switch (op) {
            case 18: {
                c = a1 ^ 0xFFFFFFFFFFFFFFFFL;
                break;
            }
            case 19: {
                c = -a1;
                break;
            }
            default: {
                Op.unknownOpError("unaryOp", op);
            }
        }
        return new Long(c);
    }

    private static Float unaryOpFloat(int op, Float a) {
        float a1 = a.floatValue();
        float c = 0.0f;
        switch (op) {
            case 19: {
                c = -a1;
                break;
            }
            default: {
                Op.unknownOpError("unaryOp", op);
            }
        }
        return new Float(c);
    }

    private static Double unaryOpDouble(int op, Double a) {
        double a1 = a;
        double c = 0.0;
        switch (op) {
            case 19: {
                c = -a1;
                break;
            }
            default: {
                Op.unknownOpError("unaryOp", op);
            }
        }
        return new Double(c);
    }

    private static Integer binaryOpInteger(int op, Integer a, Integer b) {
        int a1 = a;
        int b1 = b;
        int c = 0;
        switch (op) {
            case 0: {
                c = a1 + b1;
                break;
            }
            case 1: {
                c = a1 - b1;
                break;
            }
            case 2: {
                c = a1 * b1;
                break;
            }
            case 3: {
                c = a1 / b1;
                break;
            }
            case 4: {
                c = a1 % b1;
                break;
            }
            case 5: {
                c = a1 & b1;
                break;
            }
            case 7: {
                c = a1 ^ b1;
                break;
            }
            case 6: {
                c = a1 | b1;
                break;
            }
            case 8: {
                c = ~a1 | b1;
                break;
            }
            case 9: {
                c = a1 << b1;
                break;
            }
            case 10: {
                c = a1 >> b1;
                break;
            }
            case 11: {
                c = a1 >>> b1;
                break;
            }
            default: {
                Op.unknownOpError("binaryOp", op);
            }
        }
        return new Integer(c);
    }

    private static Long binaryOpLong(int op, Long a, Long b) {
        long a1 = a;
        long b1 = b;
        long c = 0L;
        switch (op) {
            case 0: {
                c = a1 + b1;
                break;
            }
            case 1: {
                c = a1 - b1;
                break;
            }
            case 2: {
                c = a1 * b1;
                break;
            }
            case 3: {
                c = a1 / b1;
                break;
            }
            case 4: {
                c = a1 % b1;
                break;
            }
            case 5: {
                c = a1 & b1;
                break;
            }
            case 7: {
                c = a1 ^ b1;
                break;
            }
            case 6: {
                c = a1 | b1;
                break;
            }
            case 8: {
                c = a1 ^ 0xFFFFFFFFFFFFFFFFL | b1;
                break;
            }
            case 9: {
                c = a1 << (int)b1;
                break;
            }
            case 10: {
                c = a1 >> (int)b1;
                break;
            }
            case 11: {
                c = a1 >>> (int)b1;
                break;
            }
            default: {
                Op.unknownOpError("binaryOp", op);
            }
        }
        return new Long(c);
    }

    private static Float binaryOpFloat(int op, Float a, Float b) {
        float a1 = a.floatValue();
        float b1 = b.floatValue();
        float c = 0.0f;
        switch (op) {
            case 0: {
                c = a1 + b1;
                break;
            }
            case 1: {
                c = a1 - b1;
                break;
            }
            case 2: {
                c = a1 * b1;
                break;
            }
            case 3: {
                c = a1 / b1;
                break;
            }
            default: {
                Op.unknownOpError("binaryOp", op);
            }
        }
        return new Float(c);
    }

    private static Double binaryOpDouble(int op, Double a, Double b) {
        double a1 = a;
        double b1 = b;
        double c = 0.0;
        switch (op) {
            case 0: {
                c = a1 + b1;
                break;
            }
            case 1: {
                c = a1 - b1;
                break;
            }
            case 2: {
                c = a1 * b1;
                break;
            }
            case 3: {
                c = a1 / b1;
                break;
            }
            default: {
                Op.unknownOpError("binaryOp", op);
            }
        }
        return new Double(c);
    }

    private static boolean binaryCompInteger(int op, Integer a, Integer b) {
        int a1 = a;
        int b1 = b;
        boolean c = false;
        switch (op) {
            case 12: {
                c = a1 == b1;
                break;
            }
            case 13: {
                c = a1 < b1;
                break;
            }
            case 14: {
                c = a1 > b1;
                break;
            }
            case 15: {
                c = a1 <= b1;
                break;
            }
            case 16: {
                c = a1 >= b1;
                break;
            }
            case 17: {
                c = a1 != b1;
                break;
            }
            default: {
                Op.unknownOpError("binaryComp", op);
            }
        }
        return c;
    }

    private static boolean binaryCompLong(int op, Long a, Long b) {
        long a1 = a;
        long b1 = b;
        boolean c = false;
        switch (op) {
            case 12: {
                c = a1 == b1;
                break;
            }
            case 13: {
                c = a1 < b1;
                break;
            }
            case 14: {
                c = a1 > b1;
                break;
            }
            case 15: {
                c = a1 <= b1;
                break;
            }
            case 16: {
                c = a1 >= b1;
                break;
            }
            case 17: {
                c = a1 != b1;
                break;
            }
            default: {
                Op.unknownOpError("binaryComp", op);
            }
        }
        return c;
    }

    private static boolean binaryCompFloat(int op, Float a, Float b) {
        float a1 = a.floatValue();
        float b1 = b.floatValue();
        boolean c = false;
        switch (op) {
            case 12: {
                c = a1 == b1;
                break;
            }
            case 13: {
                c = a1 < b1;
                break;
            }
            case 14: {
                c = a1 > b1;
                break;
            }
            case 15: {
                c = a1 <= b1;
                break;
            }
            case 16: {
                c = a1 >= b1;
                break;
            }
            case 17: {
                c = a1 != b1;
                break;
            }
            default: {
                Op.unknownOpError("binaryComp", op);
            }
        }
        return c;
    }

    private static boolean binaryCompDouble(int op, Double a, Double b) {
        double a1 = a;
        double b1 = b;
        boolean c = false;
        switch (op) {
            case 12: {
                c = a1 == b1;
                break;
            }
            case 13: {
                c = a1 < b1;
                break;
            }
            case 14: {
                c = a1 > b1;
                break;
            }
            case 15: {
                c = a1 <= b1;
                break;
            }
            case 16: {
                c = a1 >= b1;
                break;
            }
            case 17: {
                c = a1 != b1;
                break;
            }
            default: {
                Op.unknownOpError("binaryComp", op);
            }
        }
        return c;
    }

    public static boolean eqv(Object a, Object b) {
        if (a instanceof Number && b instanceof Number) {
            return Op.eq((Number)a, (Number)b);
        }
        if (a == null || b == null) {
            return a == b;
        }
        return a.equals(b);
    }

    public static boolean sameObject(Object a, Object b) {
        return a == b;
    }

    private static Number wrongTypeError(Object a, Object b) {
        return (Number)E.error("binaryOp -- wrong types" + a.getClass() + " " + b.getClass());
    }

    private static Number wrongTypeError(Object a) {
        return (Number)E.error("unaryOp -- wrong type" + a.getClass());
    }

    private static Object unknownOpError(String name, int op) {
        return E.error("Error in " + name + " -- unknown operator number: " + op);
    }

    public static Number addMulti(Pair x) {
        return U.isPair(x) ? (Number)Op.genericBinaryMultiOp(0, Op.toNumber(x.first), (Pair)x.rest) : (Number)U.toNum(0);
    }

    public static Number mulMulti(Pair x) {
        return U.isPair(x) ? (Number)Op.genericBinaryMultiOp(2, Op.toNumber(x.first), (Pair)x.rest) : (Number)U.toNum(1);
    }

    public static Number toNumber(Object x) {
        return x instanceof Number ? (Number)((Number)x) : (Number)(x instanceof Character ? (Number)new Integer(((Character)x).charValue()) : (Number)((Number)E.error(x + " can't be converted to a Number")));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

