/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jsint.E;
import jsint.Importer;
import jsint.SingleImporter;
import jsint.WildImporter;

public class Import {
    private static ClassLoader CLASSLOADER = (class$jsint$Import == null ? (class$jsint$Import = Import.class$("jsint.Import")) : class$jsint$Import).getClassLoader();
    public static final Vector singles = new Vector(50);
    public static final Vector wilds = new Vector(50);
    public static final Hashtable table = new Hashtable(200);
    static /* synthetic */ Class class$jsint$Import;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;

    public static synchronized ClassLoader getClassLoader() {
        return CLASSLOADER;
    }

    public static synchronized void setClassLoader(ClassLoader cl) {
        CLASSLOADER = cl;
    }

    public static synchronized void addImport(String name) {
        if (name.endsWith("*")) {
            Import.addNew(wilds, new WildImporter(name));
            table.clear();
        } else {
            Import.addNew(singles, new SingleImporter(name));
        }
    }

    private static void addNew(Vector v, Object x) {
        if (x != null && !v.contains(x)) {
            v.addElement(x);
        }
    }

    public static Class classNamed(String name) {
        Class c = Import.maybeClassNamed(name);
        return c == null ? (Class)E.error("Can't find " + name + " importing " + singles + " " + wilds) : c;
    }

    public static synchronized Class maybeClassNamed(String name) {
        Class c = (Class)table.get(name);
        if (c != null) {
            return c;
        }
        c = Import.classNamedLookup(name);
        if (c != null) {
            table.put(name, c);
        }
        return c;
    }

    private static Class classNamedLookup(String name) {
        if (name.endsWith("[]")) {
            return Import.classNamedArray(name.substring(0, name.length() - "[]".length()));
        }
        Class c = Import.classNamedImported(name);
        if (c != null) {
            return c;
        }
        return Import.primitiveClassNamed(name);
    }

    private static Class classNamedImported(String name) {
        Vector classes = Import.find(singles, name, new Vector(5));
        if (name.lastIndexOf(".") == -1) {
            if (classes.size() == 0) {
                classes = Import.classNamedNoPackage(name, classes);
            }
            if (classes.size() == 0) {
                classes = Import.find(wilds, name, classes);
            }
        } else {
            Import.addNew(classes, Import.forName(name));
        }
        return Import.returnClass(name, classes);
    }

    private static Class returnClass(String name, Vector classes) {
        int L = classes.size();
        if (L == 0) {
            return null;
        }
        if (L == 1) {
            return (Class)classes.elementAt(0);
        }
        return (Class)E.warn("Class " + name + " is ambiguous " + classes + " choosing " + (Class)classes.elementAt(0));
    }

    private static Vector classNamedNoPackage(String name, Vector classes) {
        Import.addNew(classes, Import.forName(name.startsWith("$") ? name.substring(1, name.length()) : name));
        return classes;
    }

    public static Vector find(Vector imports, String name, Vector classes) {
        Enumeration is = imports.elements();
        while (is.hasMoreElements()) {
            Import.addNew(classes, ((Importer)is.nextElement()).classNamed(name));
        }
        return classes;
    }

    private static Class classNamedArray(String name) {
        Class c = Import.classNamed(name);
        if (c.isPrimitive()) {
            return Import.classNamedArrayPrimitive(c);
        }
        if (c.isArray()) {
            return Import.forName("[" + c.getName());
        }
        return Import.forName("[L" + c.getName() + ";");
    }

    public static Class forName(String name) {
        try {
            return Import.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
        catch (Throwable t) {
            E.warn("Import.forName(" + name + ") got:");
            t.printStackTrace();
            System.err.println("returning null!");
            return null;
        }
    }

    private static Class primitiveClassNamed(String name) {
        return name.equals("void") ? Void.TYPE : (name.equals("boolean") ? Boolean.TYPE : (name.equals("byte") ? Byte.TYPE : (name.equals("char") ? Character.TYPE : (name.equals("short") ? Short.TYPE : (name.equals("int") ? Integer.TYPE : (name.equals("long") ? Long.TYPE : (name.equals("float") ? Float.TYPE : (name.equals("double") ? Double.TYPE : null))))))));
    }

    private static Class classNamedArrayPrimitive(Class c) {
        Class clazz = c == Boolean.TYPE ? (array$Z == null ? (array$Z = Import.class$("[Z")) : array$Z) : (c == Byte.TYPE ? (array$B == null ? (array$B = Import.class$("[B")) : array$B) : (c == Character.TYPE ? (array$C == null ? (array$C = Import.class$("[C")) : array$C) : (c == Short.TYPE ? (array$S == null ? (array$S = Import.class$("[S")) : array$S) : (c == Integer.TYPE ? (array$I == null ? (array$I = Import.class$("[I")) : array$I) : (c == Long.TYPE ? (array$J == null ? (array$J = Import.class$("[J")) : array$J) : (c == Float.TYPE ? (array$F == null ? (array$F = Import.class$("[F")) : array$F) : (c == Double.TYPE ? (array$D == null ? (array$D = Import.class$("[D")) : array$D) : null)))))));
        return clazz;
    }

    private Import() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Import.addImport("java.lang.Object");
        Import.addImport("java.lang.*");
        Import.addImport("java.lang.reflect.*");
        Import.addImport("java.util.*");
        Import.addImport("jsint.*");
    }
}

