/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.PrintWriter;
import jsint.LocalVariable;
import jsint.Pair;
import jsint.Symbol;
import jsint.U;

public class Environment {
    public static final Environment GLOBAL = new Environment(Pair.EMPTY, null, null);
    private Environment parent;
    private Object vars;
    private Object[] vals;

    public Environment(Object vars, Object[] vals, Environment parent) {
        this.vars = vars;
        this.vals = vals;
        this.parent = parent;
    }

    public Object lookup(Symbol var) {
        return this.lookup(var, 0, 0, this.vars);
    }

    public Object lookup(Symbol var, int up, int in, Object vars) {
        if (this == GLOBAL) {
            return var;
        }
        if (vars == var) {
            return new LocalVariable(up, in, var);
        }
        if (!U.isPair(vars)) {
            return this.parent.lookup(var, up + 1, 0, this.parent.vars);
        }
        if (U.first(vars) == var) {
            return new LocalVariable(up, in, var);
        }
        return this.lookup(var, up, in + 1, U.rest(vars));
    }

    public Object get(LocalVariable var) {
        return this.up((int)var.up).vals[var.in];
    }

    public Object set(LocalVariable var, Object newVal) {
        this.up((int)var.up).vals[var.in] = newVal;
        return this.up((int)var.up).vals[var.in];
    }

    Environment up(int levels) {
        return levels == 0 ? this : this.parent.up(levels - 1);
    }

    public String toString() {
        return "{|" + this.toString0() + "|}";
    }

    private String toString0() {
        if (this == GLOBAL) {
            return "GLOBAL";
        }
        return U.stringify(this.vars) + " " + U.stringify(this.vals) + (this.parent == null ? "" : "|" + this.parent.toString0());
    }

    public void show(PrintWriter s) {
        Environment e = this;
        while (e != GLOBAL) {
            Object vars = e.vars;
            Object[] vals = e.vals;
            int i = 0;
            while (U.isPair(vars)) {
                this.show0(s, U.first(vars), vals[i]);
                vars = U.rest(vars);
                ++i;
            }
            if (vars != Pair.EMPTY) {
                this.show0(s, vars, vals[i]);
            }
            e = e.parent;
        }
    }

    private void show0(PrintWriter s, Object var, Object val) {
        String sval = U.stringify(val);
        if (sval.length() > 100) {
            sval = sval.substring(0, 100) + "...";
        }
        s.println("  " + U.stringify(var) + " = " + sval);
    }
}

