/*
 * Decompiled with CFR 0.152.
 */
package demo;

import com.sun.java.swing.action.ActionManager;
import com.sun.java.swing.action.DelegateAction;
import com.sun.java.swing.ui.CommonMenuBar;
import com.sun.java.swing.ui.CommonToolBar;
import com.sun.java.swing.ui.StatusBar;
import demo.MyActionManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class FrameworkDemo
extends JFrame {
    private MyActionDelegate actionDelegate;

    public FrameworkDemo() {
        super("Mark's Application Framework Demo");
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(new MyMenuBar());
        this.getContentPane().add((Component)new MyToolBar(), "North");
        this.getContentPane().add((Component)this.createPanel(), "Center");
        this.getContentPane().add((Component)StatusBar.getInstance(), "South");
        this.registerActions();
        this.pack();
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(400, 200));
        panel.setBackground(UIManager.getColor("Desktop.background"));
        panel.setBorder(UIManager.getBorder("Desktop.border"));
        return panel;
    }

    private void registerActions() {
        if (this.actionDelegate == null) {
            this.actionDelegate = new MyActionDelegate();
        }
        this.registerAction("new-command", this.actionDelegate);
        this.registerAction("open-command", this.actionDelegate);
        this.registerAction("help-command", this.actionDelegate);
        this.registerAction("about-command", this.actionDelegate);
        this.registerAction("exit-command", this.actionDelegate);
        this.registerAction("save-command", this.actionDelegate);
    }

    private void registerAction(String actionName, ActionListener listener) {
        ActionManager manager = MyActionManager.getInstance();
        DelegateAction action = manager.getDelegateAction(actionName);
        action.addActionListener(listener);
    }

    public static void main(String[] args) {
        FrameworkDemo demo = new FrameworkDemo();
        demo.setVisible(true);
    }

    public class MyToolBar
    extends CommonToolBar {
        public MyToolBar() {
            super(MyActionManager.getInstance());
            this.setRollover(true);
        }

        protected void addComponents() {
            this.addButton(this.manager.getAction("new-command"));
            this.addButton(this.manager.getAction("open-command"));
            this.addButton(this.manager.getAction("save-command"));
            this.addSeparator();
            this.addToggleButton(this.manager.getStateChangeAction("show-statusbar-command"));
            ButtonGroup group = new ButtonGroup();
            this.addToggleButton(this.manager.getStateChangeAction("align-left-command"), group);
            this.addToggleButton(this.manager.getStateChangeAction("align-center-command"), group);
            this.addToggleButton(this.manager.getStateChangeAction("align-right-command"), group);
            this.addSeparator();
            this.addButton(this.manager.getAction("help-command"));
            this.addButton(this.manager.getAction("about-command"));
        }
    }

    public class MyMenuBar
    extends CommonMenuBar {
        public MyMenuBar() {
            super(MyActionManager.getInstance());
        }

        protected void configureMenu() {
            this.add(this.createFileMenu());
            this.add(this.createViewMenu());
            this.add(this.createHelpMenu());
        }

        private JMenu createFileMenu() {
            JMenu menu = new JMenu(this.manager.getAction("file-menu-command"));
            this.addMenuItem(menu, this.manager.getAction("new-command"));
            this.addMenuItem(menu, this.manager.getAction("open-command"));
            this.addMenuItem(menu, this.manager.getAction("save-command"));
            menu.addSeparator();
            this.addMenuItem(menu, this.manager.getAction("exit-command"));
            return menu;
        }

        private JMenu createViewMenu() {
            JMenu menu = new JMenu(this.manager.getAction("view-menu-command"));
            this.addCheckBoxMenuItem(menu, this.manager.getStateChangeAction("show-statusbar-command"));
            menu.addSeparator();
            ButtonGroup group = new ButtonGroup();
            this.addRadioButtonMenuItem(menu, group, this.manager.getStateChangeAction("align-left-command"));
            this.addRadioButtonMenuItem(menu, group, this.manager.getStateChangeAction("align-center-command"));
            this.addRadioButtonMenuItem(menu, group, this.manager.getStateChangeAction("align-right-command"));
            return menu;
        }

        private JMenu createHelpMenu() {
            JMenu menu = new JMenu(this.manager.getAction("help-menu-command"));
            this.addMenuItem(menu, this.manager.getAction("help-command"));
            menu.addSeparator();
            this.addMenuItem(menu, this.manager.getAction("about-command"));
            return menu;
        }
    }

    public class MyActionDelegate
    implements ActionListener {
        public void actionPerformed(ActionEvent evt) {
            String command = evt.getActionCommand();
            if (command.equals("exit-command")) {
                FrameworkDemo.this.dispose();
                System.exit(0);
            } else {
                System.out.println(command + " command invoked");
            }
        }
    }
}

