;;; 
;;; EOPL2 compatibility for Jscheme. http://www.cs.indiana.edu/eopl/
;;;

;;; If this file has the path eopl2/jscheme/jscheme-init.scm, then you
;;; can get access to eopl2 code by invoking Jscheme something like
;;; this:

;;; java -classpath jscheme.jar;eopl2 jsint.Scheme jscheme/jscheme-init.scm

;;; To run the tests, evaluate (do-test).
;;; Takes about 13.3  minutes in jdk1.3.1
  ;;and   about 11.42 minutes in J2sdk1.4.0
;;; based on measurements kanderson@bbn.com made on 28FEB02, 700MHz Pentium
;;; The numbers are single runs so no confidence interval is available.
;;; Please send me your timing results..

;;; We use Mark Feeley's pretty printer from slib, and Kent Dybvig's
;;; psyntax package to provide define-syntax.  For this to work, you
;;; need version 4.3 of Jscheme or greater.

(load "elf/classpath.scm")
(extendClassPath "eopl2")
(load "jscheme/psyntax-init.scm")
(load "r5rs.scm")

;;; Use the Mark Feeley's pretty printer from slib.
(load "jscheme/genwrite.scm")
(set! sllgen:pretty-print pretty-print)
(set! eopl:pretty-print pretty-print)
(set! define-datatype:pretty-print pretty-print)

(define eopl:error
  (lambda (who format . data)
    ;; print the message
    (eopl:printf "Error reported by ~s:~%" who)
    (apply eopl:printf (cons format data))
    (newline)
    (error "Yow!")))

(define eopl:error
  (lambda (who format . data)
    (error who format data)))

(define (interaction-environment) 'ignore)

(load "sllgen.scm")
(load "define-datatype.scm")
(load "test-harness.scm")
(load "test-suite.scm")
;;; (load "6-top.scm")
;;; (set! stop-after-first? #f)

(define eopl:error-stop
  (lambda args (error args)))

;;; Reather than using dynamic-wind and call/cc tryCatch does what we want.
(define safely-run-experiment-on-program
  (lambda (experiment pgm error-val)
    (tryCatch
     (experiment pgm)
     (lambda (e) error-val))))

(define define-datatype:tester
  (lambda (example)
    (display "------------------------------")
    (newline)
    (sllgen:pretty-print example)
    (display "-->")
    (newline)
    (tryCatch
     (begin
       (write (eval example (interaction-environment)))
       (newline)
       #t)
     (lambda (e) #f))))

(define pretty-expand (lambda (e) (pretty-print (sc-expand e))))

(define (do-test)
  (load "all-tests.scm")
  (display (time (do-all-tests) 1))
  (newline)
  (exit))