(import "jsint.Symbol")
(define (apropos pattern)
  "Describe all global variables matching Pattern."
  (let ((pattern (.toString pattern)))
    ;; Clone the table because getting a symbol's value can cause a
    ;; Java reflector to be installed.
    (iterate (.clone Symbol.symbolTable$)
	     (lambda (s)
	       (if (> (.indexOf (.toString s) pattern) -1)
		   (display
		    {[s]: [(if (.isDefined s) (.getGlobalValue s) "")]\n}
		    ))))))
