/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import jscheme.JS;
import jsint.BacktraceException;
import jsint.Closure;
import jsint.E;
import jsint.Environment;
import jsint.Import;
import jsint.InputPort;
import jsint.JschemeThrowable;
import jsint.LocalVariable;
import jsint.Macro;
import jsint.Pair;
import jsint.Primitive;
import jsint.Procedure;
import jsint.Symbol;
import jsint.U;

public class Scheme {
    public static boolean EXIT = false;
    public static InputPort input = new InputPort(System.in);
    public static PrintWriter output = new PrintWriter(System.out, true);
    public static PrintWriter error = new PrintWriter(System.err, true);
    public static String version = "Jscheme 5.0 (04/05/2002)";
    public static Symbol EVAL = Symbol.intern("eval");
    public static Symbol LOAD = Symbol.intern("load");

    public static void main(String[] files) {
        String main = null;
        String[] mainArgs = null;
        int i = 0;
        if (!Primitive.primitives_loaded) {
            Primitive.loadPrimitives();
        }
        while (i < (files == null ? 0 : files.length)) {
            if (files[i].startsWith("(")) {
                Scheme.load(new InputPort(new StringReader(files[i])));
            } else if (files[i].startsWith("-")) {
                if (files[i].equals("-s")) {
                    U.useJavaSyntax = false;
                } else if (files[i].equals("-j")) {
                    U.useJavaSyntax = true;
                } else {
                    if (files[i].equals("-main")) {
                        main = files[++i];
                        mainArgs = Scheme.consumeArgs(files, i + 1);
                        break;
                    }
                    Scheme.usage(files[i]);
                }
            } else {
                Scheme.load(files[i]);
            }
            ++i;
        }
        if (!Scheme.loadInit()) {
            if (main == null) {
                Scheme.runJscheme();
            } else if (!main.equals("none")) {
                try {
                    JS.call(main, mainArgs);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        }
    }

    private static void usage(String arg) {
        E.warn("Unrecognized flag: " + arg + "\n" + "Usage: \n" + "  java jsint.Scheme [-s][-j] [(s-expr)] [file] ... [-main procedure arg1 ...]\n\n" + "Where: \n" + "  -s   \n" + "    Use normal Scheme syntax for numbers and characters.\n\n" + "  -j   \n" + "    Use Javalike syntax for numbers and characters.\n\n" + "  (s-exp)  \n" + "    An argument that begins with \"(\" is evaluated.\n\n" + "  -main procedure arg1 ...\n" + "    Rather than starting the normal Scheme.main, \n" + "    collect arg1 ... into a String[] and apply procedure to it.\n" + "    If procedure is none, no main is started.\n");
        System.exit(1);
    }

    private static String[] consumeArgs(String[] files, int i) {
        String[] result = new String[files.length - i];
        int j = 0;
        while (i < files.length) {
            result[j++] = files[i++];
        }
        return result;
    }

    public static void runJscheme() {
        if (EXIT) {
            System.exit(0);
        }
        error.println("\n\n" + version + "\n\n");
        Scheme.readEvalWriteLoop("> ");
        System.exit(0);
    }

    public static boolean loadInit() {
        InputPort in = Scheme.open("init.scm");
        if (in != null) {
            Scheme.load(in);
            return true;
        }
        return false;
    }

    public static void readEvalWriteLoop(String prompt) {
        if (!EXIT) {
            while (true) {
                try {
                    if (EXIT) break;
                    output.print(prompt);
                    output.flush();
                    Object x = input.read();
                    if (x == InputPort.EOF) break;
                    U.write(Scheme.eval(x), output, true);
                    output.println();
                    output.flush();
                }
                catch (Throwable e) {
                    e.printStackTrace(error);
                }
            }
        }
    }

    public static Object load(Object fileName) {
        String name = fileName.toString();
        InputPort iport = Scheme.open(name);
        if (iport == null) {
            return E.warn("(load) can't open \"" + fileName + "\"");
        }
        return Scheme.load(iport);
    }

    public static InputPort open(String name) {
        InputPort iport = Scheme.openFile(name);
        return iport == null ? Scheme.openResource(name) : iport;
    }

    public static InputPort openFile(String name) {
        try {
            return new InputPort(new FileInputStream(name));
        }
        catch (IOException fnf) {
            return null;
        }
        catch (SecurityException se) {
            return null;
        }
        catch (Throwable e) {
            e.printStackTrace(error);
            return null;
        }
    }

    public static InputPort openResource(String name) {
        try {
            ClassLoader loader = Import.getClassLoader();
            InputStream stream = loader == null ? ClassLoader.getSystemResourceAsStream(name) : loader.getResourceAsStream(name);
            return stream == null ? null : new InputPort(stream);
        }
        catch (Throwable e) {
            System.out.println("In openResource(" + name + "):");
            e.printStackTrace(error);
            return null;
        }
    }

    public static Object load(InputPort in) {
        while (true) {
            try {
                Object x = in.read();
                if (x == InputPort.EOF) {
                    return U.TRUE;
                }
                Scheme.evalToplevel(x);
                continue;
            }
            catch (Exception e) {
                E.warn("Error during load (lineno " + in.getLineNumber() + "): ", e);
                e.printStackTrace(error);
                continue;
            }
            break;
        }
    }

    public static Object evalToplevel(Object x) {
        if (U.isPair(x)) {
            Object mx = Macro.expand((Pair)x);
            if (x != mx) {
                return Scheme.evalToplevel(mx);
            }
            if (U.first(x) == Symbol.BEGIN) {
                Object xs = U.rest(x);
                Object result = null;
                while (U.isPair(xs)) {
                    result = Scheme.eval(U.first(xs));
                    xs = U.rest(xs);
                }
                return result;
            }
            return Scheme.eval(x);
        }
        return Scheme.eval(x);
    }

    public static Object eval(Object x) {
        return ((Procedure)EVAL.getGlobalValue()).apply(new Pair(x, Pair.EMPTY));
    }

    public static Object eval(Object x, Environment env) {
        Object analyzedCode = Scheme.analyze(x, env);
        return Scheme.execute(analyzedCode, env);
    }

    public static Object analyze(Object x, Environment env) {
        if (x instanceof Symbol) {
            return env.lookup((Symbol)x);
        }
        if (!U.isPair(x)) {
            return new Object[]{Symbol.QUOTE, x};
        }
        Object f = U.first(x);
        int len = ((Pair)x).length();
        if (Symbol.LAMBDA == f && len >= 3) {
            Object args = U.second(x);
            Environment env2 = new Environment(args, null, env);
            return new Closure(args, Scheme.analyze(Scheme.toBody(U.rest(U.rest(x))), env2), env);
        }
        if (Symbol.MACRO == f && len >= 3) {
            Object args = U.second(x);
            Environment env2 = new Environment(args, null, env);
            return new Macro(args, Scheme.analyze(Scheme.toBody(U.rest(U.rest(x))), env2), env);
        }
        if (2 == len && Symbol.BEGIN == f) {
            return Scheme.analyze(U.second(x), env);
        }
        Object xm = Macro.expand((Pair)x);
        if (x != xm) {
            return Scheme.analyze(xm, env);
        }
        if (Symbol.OR == f && len == 1) {
            return new Object[]{Symbol.QUOTE, U.FALSE};
        }
        if (Symbol.IF == f && len == 3) {
            return Scheme.analyze(U.append(U.list(x, U.list(U.FALSE))), env);
        }
        if (Symbol.QUOTE == f && len == 2) {
            return new Object[]{Symbol.QUOTE, U.second(x)};
        }
        Scheme.checkLength(f, len, x);
        Object[] xv = U.listToVector(x);
        if (!Scheme.isSpecial(f)) {
            xv[0] = Scheme.analyze(xv[0], env);
        }
        int i = 1;
        while (i < xv.length) {
            xv[i] = Scheme.analyze(xv[i], env);
            ++i;
        }
        return xv;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object execute(Object x, Environment env) {
        while (true) {
            block16: {
                if (!(x instanceof Object[])) {
                    if (x instanceof Symbol) {
                        return ((Symbol)x).getGlobalValue();
                    }
                    if (x instanceof LocalVariable) {
                        return env.get((LocalVariable)x);
                    }
                    return ((Closure)x).copy(env);
                }
                xv = (Object[])x;
                f = xv[0];
                if (f == Symbol.QUOTE) {
                    return xv[1];
                }
                if (f == Symbol.IF) {
                    x = U.to_bool(Scheme.execute(xv[1], env)) != false ? xv[2] : xv[3];
                    continue;
                }
                if (f == Symbol.BEGIN) {
                    x = Scheme.executeButLast(xv, env);
                    continue;
                }
                if (f != Symbol.OR) break block16;
                xvlm1 = xv.length - 1;
                i = 1;
                if (true) ** GOTO lbl46
            }
            if (f == Symbol.SET && xv[1] instanceof Symbol) {
                return ((Symbol)xv[1]).setGlobalValue(Scheme.execute(xv[2], env));
            }
            if (f == Symbol.SET && xv[1] instanceof LocalVariable) {
                return env.set((LocalVariable)xv[1], Scheme.execute(xv[2], env));
            }
            try {
                f = Scheme.execute(f, env);
                if (!(f instanceof Closure)) {
                    p = U.toProc(f);
                    return p.apply(p.makeArgArray(xv, env));
                }
                c = (Closure)f;
                x = c.body;
                env = new Environment(c.parms, c.makeArgArray(xv, env), c.env);
            }
            catch (RuntimeException e) {
                if (e.getMessage() == "continuation") {
                    throw e;
                }
                if (e instanceof JschemeThrowable && e.getMessage() == null) {
                    throw e;
                }
                throw new BacktraceException(e, xv, env);
            }
            do {
                if (U.toBool(result = Scheme.execute(xv[i], env)) != U.FALSE) {
                    return result;
                }
                ++i;
lbl46:
                // 2 sources

            } while (i < xvlm1);
            x = xv[xvlm1];
        }
    }

    private static boolean isSpecial(Object f) {
        return f == Symbol.SET || f == Symbol.IF || f == Symbol.BEGIN || f == Symbol.OR || f == Symbol.QUOTE;
    }

    private static void checkLength(Object f, int len, Object x) {
        if (f == Symbol.LAMBDA && len < 3 || f == Symbol.MACRO && len < 3 || f == Symbol.SET && len != 3 || f == Symbol.IF && len != 4 || f == Symbol.BEGIN && len <= 2 || f == Symbol.OR && len < 2 || f == Symbol.QUOTE && len != 2) {
            E.warn("wrong number of arguments for syntax:", x);
        }
    }

    private static Object toBody(Object exps) {
        Pair parts = Scheme.extractDefines(Pair.EMPTY, U.toPair(exps));
        Pair defines = (Pair)parts.first;
        Pair body = (Pair)parts.rest;
        if (U.isPair(defines)) {
            Pair vars = Pair.EMPTY;
            Pair sets = Pair.EMPTY;
            Pair vals = Pair.EMPTY;
            Pair ds = defines;
            while (U.isPair(ds)) {
                Pair d = (Pair)ds.first;
                ds = (Pair)ds.rest;
                vars = new Pair(U.second(d), vars);
                sets = new Pair(U.list(Symbol.SET, d.second(), d.third()), sets);
                vals = new Pair(U.FALSE, vals);
            }
            Pair begin = new Pair(Symbol.BEGIN, U.append(U.list(sets.reverse(), body)));
            return new Pair(U.list(Symbol.LAMBDA, vars.reverse(), begin), vals);
        }
        return new Pair(Symbol.BEGIN, body);
    }

    private static Pair extractDefines(Pair defines, Pair body) {
        if (!U.isPair(body)) {
            return new Pair(defines.reverse(), body);
        }
        if (Scheme.startsWith(body.first, Symbol.BEGIN)) {
            return Scheme.extractDefines(defines, (Pair)U.append(U.list(U.rest(U.first(body)), body.rest)));
        }
        if (Scheme.startsWith(body.first, Symbol.DEFINE)) {
            return Scheme.extractDefines(new Pair(Scheme.simplifyDefine((Pair)body.first), defines), U.toList(body.rest));
        }
        return new Pair(defines.reverse(), Scheme.checkForDefines(body));
    }

    private static Object checkForDefines(Pair body) {
        if (!U.isPair(body)) {
            return body;
        }
        if (Scheme.startsWith(body.first, Symbol.BEGIN)) {
            return Scheme.checkForDefines((Pair)U.append(U.list(U.rest(U.first(body)), body.rest)));
        }
        if (Scheme.startsWith(body.first, Symbol.DEFINE)) {
            return E.error("Jscheme requires all embedded defines to appear first in procedure bodies\nYou must move " + U.stringify(U.first(body)) + " up\n");
        }
        return new Pair(body.first, Scheme.checkForDefines((Pair)body.rest));
    }

    private static boolean startsWith(Object list, Object atom) {
        return U.isPair(list) && U.first(list) == atom;
    }

    private static Pair simplifyDefine(Pair definition) {
        Object var = U.second(definition);
        if (var instanceof Pair) {
            Pair var2 = (Pair)var;
            Object name = var2.first;
            Object args = var2.rest;
            Object body = U.rest(U.rest(definition));
            return new Pair(Symbol.DEFINE, new Pair(name, U.list(new Pair(Symbol.LAMBDA, new Pair(args, body)))));
        }
        return definition;
    }

    private static Object executeButLast(Object[] xv, Environment env) {
        int i = 1;
        while (i < xv.length - 1) {
            Scheme.execute(xv[i], env);
            ++i;
        }
        return xv[xv.length - 1];
    }

    public static final Object[] makeArgArray(Procedure p, Pair args) {
        Object[] argArray = new Object[p.nParms()];
        int nargs = args.length();
        if (nargs < p.minArgs) {
            E.error("\nToo few arguments to procedure " + p.name + " expected at least " + p.minArgs + ", but found " + nargs + " arguments:\n***************\n    " + U.stringify(args) + "\n************\n");
        }
        if (nargs > p.maxArgs) {
            E.error("\nToo many arguments to procedure " + p.name + " expected at most " + p.maxArgs + ", but found " + nargs + " arguments:\n***************\n    " + U.stringify(args) + "\n************\n");
        }
        int i = 0;
        while (i < p.minArgs) {
            argArray[i] = args.first;
            ++i;
            args = U.toList(args.rest);
        }
        if (p.maxArgs > p.minArgs) {
            argArray[p.minArgs] = p.maxArgs == p.minArgs + 1 ? (U.isPair(args) ? args.first : U.MISSING) : args;
        }
        return argArray;
    }

    static {
        if (!Primitive.primitives_loaded) {
            Primitive.loadPrimitives();
        }
    }
}

