/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import java.io.PrintWriter;
import java.io.StringReader;
import jscheme.REPL;
import jsint.E;
import jsint.Environment;
import jsint.Import;
import jsint.InputPort;
import jsint.Invoke;
import jsint.JschemeThrowable;
import jsint.Macro;
import jsint.Op;
import jsint.Pair;
import jsint.Procedure;
import jsint.RawConstructor;
import jsint.RawMethod;
import jsint.Scheme;
import jsint.Symbol;
import jsint.U;

public class Primitive
extends Procedure {
    int opcode;
    static boolean primitives_loaded = false;

    public Primitive(String name, int opcode, int minArgs, int maxArgs) {
        this.name = name;
        this.opcode = opcode;
        this.minArgs = minArgs;
        this.maxArgs = maxArgs;
        if (maxArgs != minArgs && maxArgs != minArgs + 1 && maxArgs != Integer.MAX_VALUE) {
            E.warn("Bad value of maxArgs: " + maxArgs, name);
        }
        Symbol.intern(name).setGlobalValue(this);
    }

    public Object apply(Object[] args) {
        int nArgs = args.length;
        Object x = nArgs >= 1 ? args[0] : U.MISSING;
        Symbol y = nArgs >= 2 ? args[1] : U.MISSING;
        Symbol z = nArgs >= 3 ? args[2] : U.MISSING;
        switch (this.opcode) {
            case 1: {
                return U.toBool(U.FALSE.equals(x));
            }
            case 2: {
                return U.toBool(x instanceof Boolean);
            }
            case 3: {
                return U.toBool(U.eqv(x, y));
            }
            case 4: {
                return U.toBool(x == y || U.TRUE.equals(x) && U.TRUE.equals(y) || U.FALSE.equals(x) && U.FALSE.equals(y));
            }
            case 5: {
                return U.toBool(U.equal(x, y));
            }
            case 6: {
                return U.toBool(U.isPair(x));
            }
            case 7: {
                return new Pair(x, y);
            }
            case 8: {
                return U.toList((Object)x).first;
            }
            case 9: {
                return U.toList((Object)x).rest;
            }
            case 10: {
                U.toPair((Object)x).first = y;
                return U.toPair((Object)x).first;
            }
            case 11: {
                U.toPair((Object)x).rest = y;
                return U.toPair((Object)x).rest;
            }
            case 12: {
                return U.toList(x).second();
            }
            case 13: {
                return U.toList(x).third();
            }
            case 14: {
                int i = this.name.length() - 2;
                while (i >= 1) {
                    x = this.name.charAt(i) == 'a' ? U.toList((Object)x).first : U.toList((Object)x).rest;
                    --i;
                }
                return x;
            }
            case 15: {
                return U.toBool(x == Pair.EMPTY);
            }
            case 16: {
                return U.toBool(U.isList(x));
            }
            case 17: {
                return x;
            }
            case 18: {
                return U.toNum(U.toList(x).length());
            }
            case 19: {
                return U.append(U.toList(x));
            }
            case 20: {
                return U.toList(x).reverse();
            }
            case 21: {
                return U.toList(x).listTail(U.toInt(y));
            }
            case 22: {
                return U.toList(x).nth(U.toInt(y));
            }
            case 23: {
                return U.memberAssoc(x, y, true, 1);
            }
            case 24: {
                return U.memberAssoc(x, y, true, 2);
            }
            case 25: {
                return U.memberAssoc(x, y, true, 3);
            }
            case 26: {
                return U.memberAssoc(x, y, false, 1);
            }
            case 27: {
                return U.memberAssoc(x, y, false, 2);
            }
            case 28: {
                return U.memberAssoc(x, y, false, 3);
            }
            case 29: {
                return U.toBool(x instanceof Symbol);
            }
            case 30: {
                return U.toSym(x).toString();
            }
            case 31: {
                return Symbol.intern(U.toStr(x));
            }
            case 32: {
                return U.toBool(x instanceof Number);
            }
            case 33: {
                return U.toBool(x instanceof Integer || x instanceof Double && U.toReal(x) == (double)Math.round(U.toReal(x)));
            }
            case 34: {
                return U.toBool(x instanceof Integer);
            }
            case 35: {
                return U.toBool(x instanceof Double);
            }
            case 36: {
                return U.toBool(U.numCompute(x, U.toList(y), '='));
            }
            case 37: {
                return U.toBool(U.numCompute(x, U.toList(y), '<'));
            }
            case 38: {
                return U.toBool(U.numCompute(x, U.toList(y), '>'));
            }
            case 39: {
                return U.toBool(U.numCompute(x, U.toList(y), 'L'));
            }
            case 40: {
                return U.toBool(U.numCompute(x, U.toList(y), 'G'));
            }
            case 41: {
                return U.toBool(U.ZERO.equals(x) || U.toNum(0).equals(x));
            }
            case 42: {
                return U.toBool(U.toReal(x) > 0.0);
            }
            case 43: {
                return U.toBool(U.toReal(x) < 0.0);
            }
            case 44: {
                return U.toBool(Math.abs(U.toInt(x)) % 2 != 0);
            }
            case 45: {
                return U.toBool(Math.abs(U.toInt(x)) % 2 == 0);
            }
            case 46: {
                return U.numCompute(x, U.toList(y), 'X');
            }
            case 47: {
                return U.numCompute(x, U.toList(y), 'N');
            }
            case 48: {
                return Op.addMulti(U.toList(x));
            }
            case 49: {
                return Op.mulMulti(U.toList(x));
            }
            case 50: {
                return y == U.MISSING ? (Number)Op.sub(U.toNum(0), x) : (Number)Op.sub(x, y);
            }
            case 51: {
                return Op.div(x, y);
            }
            case 52: {
                if (x instanceof Integer) {
                    return U.toNum(Math.abs(U.toInt(x)));
                }
                return U.toNum(Math.abs(U.toReal(x)));
            }
            case 53: {
                return U.toNum(U.toInt(x) / U.toInt(y));
            }
            case 54: {
                return U.toNum(U.toInt(x) % U.toInt(y));
            }
            case 55: {
                int xi = U.toInt(x);
                int yi = U.toInt(y);
                int m = xi % yi;
                return U.toNum(m > 0 == yi > 0 || m == 0 ? m : m + yi);
            }
            case 56: {
                return nArgs == 0 ? (Number)U.toNum(0) : (Number)U.toNum(Math.abs(U.gcd((Pair)x)));
            }
            case 57: {
                return nArgs == 0 ? (Number)U.toNum(1) : (Number)U.toNum(Math.abs(U.lcm((Pair)x)));
            }
            case 58: {
                return U.toNum(Math.floor(U.toReal(x)));
            }
            case 59: {
                return U.toNum(Math.ceil(U.toReal(x)));
            }
            case 60: {
                double d = U.toReal(x);
                return U.toNum(d < 0.0 ? Math.ceil(d) : Math.floor(d));
            }
            case 61: {
                return U.toNum(Math.round(U.toReal(x)));
            }
            case 62: {
                return U.toNum(Math.exp(U.toReal(x)));
            }
            case 63: {
                return U.toNum(Math.log(U.toReal(x)));
            }
            case 64: {
                return U.toNum(Math.sin(U.toReal(x)));
            }
            case 65: {
                return U.toNum(Math.cos(U.toReal(x)));
            }
            case 66: {
                return U.toNum(Math.tan(U.toReal(x)));
            }
            case 67: {
                return U.toNum(Math.asin(U.toReal(x)));
            }
            case 68: {
                return U.toNum(Math.acos(U.toReal(x)));
            }
            case 69: {
                return U.toNum(Math.atan(U.toReal(x)));
            }
            case 70: {
                return U.toNum(Math.sqrt(U.toReal(x)));
            }
            case 71: {
                return U.toNum(Math.pow(U.toReal(x), U.toReal(y)));
            }
            case 72: {
                return U.toNum(U.toReal(x));
            }
            case 73: {
                return U.toNum(U.toInt(x));
            }
            case 74: {
                return U.numberToString(x, y);
            }
            case 75: {
                return U.stringToNumber(x, y);
            }
            case 76: {
                return U.toBool(x instanceof Character);
            }
            case 77: {
                return U.toBool(U.to_char(x) == U.to_char(y));
            }
            case 78: {
                return U.toBool(U.to_char(x) < U.to_char(y));
            }
            case 79: {
                return U.toBool(U.to_char(x) > U.to_char(y));
            }
            case 80: {
                return U.toBool(U.to_char(x) >= U.to_char(y));
            }
            case 81: {
                return U.toBool(U.to_char(x) <= U.to_char(y));
            }
            case 82: {
                return U.toBool(U.to_lc_char(x) == U.to_lc_char(y));
            }
            case 83: {
                return U.toBool(U.to_lc_char(x) < U.to_lc_char(y));
            }
            case 84: {
                return U.toBool(U.to_lc_char(x) > U.to_lc_char(y));
            }
            case 85: {
                return U.toBool(U.to_lc_char(x) >= U.to_lc_char(y));
            }
            case 86: {
                return U.toBool(U.to_lc_char(x) <= U.to_lc_char(y));
            }
            case 87: {
                return U.toBool(Character.isLetter(U.to_char(x)));
            }
            case 88: {
                return U.toBool(Character.isDigit(U.to_char(x)));
            }
            case 89: {
                return U.toBool(Character.isWhitespace(U.to_char(x)));
            }
            case 90: {
                return U.toBool(Character.isUpperCase(U.to_char(x)));
            }
            case 91: {
                return U.toBool(Character.isLowerCase(U.to_char(x)));
            }
            case 92: {
                return U.toNum(U.to_char(x));
            }
            case 93: {
                return U.toChar((char)U.toInt(x));
            }
            case 94: {
                return U.toChar(Character.toUpperCase(U.to_char(x)));
            }
            case 95: {
                return U.toChar(Character.toLowerCase(U.to_char(x)));
            }
            case 96: {
                return U.toBool(x instanceof String);
            }
            case 97: {
                return U.makeString(U.toInt(x), y);
            }
            case 98: {
                return U.listToString(x);
            }
            case 99: {
                return U.toNum(U.toStr(x).length());
            }
            case 100: {
                return U.toChar(U.toStr(x).charAt(U.toInt(y)));
            }
            case 101: {
                return E.error("string-set! not implemented", args);
            }
            case 102: {
                return U.toBool(U.toStr(x).equals(y));
            }
            case 103: {
                return U.toBool(U.toStr(x).equalsIgnoreCase(U.toStr(y)));
            }
            case 104: {
                return U.toBool(U.toStr(x).compareTo(U.toStr(y)) < 0);
            }
            case 105: {
                return U.toBool(U.toStr(x).compareTo(U.toStr(y)) > 0);
            }
            case 106: {
                return U.toBool(U.toStr(x).compareTo(U.toStr(y)) >= 0);
            }
            case 107: {
                return U.toBool(U.toStr(x).compareTo(U.toStr(y)) <= 0);
            }
            case 108: {
                return U.toBool(U.stringCompareIgnoreCase(x, y) < 0);
            }
            case 109: {
                return U.toBool(U.stringCompareIgnoreCase(x, y) > 0);
            }
            case 110: {
                return U.toBool(U.stringCompareIgnoreCase(x, y) >= 0);
            }
            case 111: {
                return U.toBool(U.stringCompareIgnoreCase(x, y) <= 0);
            }
            case 112: {
                int start = U.toInt(y);
                return U.toStr(x).substring(start, U.toInt(z));
            }
            case 113: {
                return U.stringAppend(U.toList(x));
            }
            case 114: {
                return U.stringToList(x);
            }
            case 115: {
                return U.listToString(x);
            }
            case 116: {
                return U.toBool(x instanceof Object[] || x != null && x.getClass().isArray());
            }
            case 117: {
                return y == U.MISSING ? U.makeVector(x) : U.makeVector(x, y);
            }
            case 118: {
                return U.listToVector(x);
            }
            case 119: {
                return U.vectorLength(x);
            }
            case 120: {
                return U.vectorRef(x, y);
            }
            case 121: {
                return U.vectorSet(x, y, z);
            }
            case 122: {
                return U.vectorToList(U.toVec(x));
            }
            case 123: {
                return U.listToVector(x);
            }
            case 124: {
                return U.toBool(x instanceof Procedure);
            }
            case 125: {
                Procedure p = U.toProc(x);
                return p.apply(U.toList(y));
            }
            case 126: {
                return U.map(U.toProc(x), new Pair(y, z), U.list(U.TRUE));
            }
            case 127: {
                return U.map(U.toProc(x), new Pair(y, z), Pair.EMPTY);
            }
            case 128: {
                return !(x instanceof Procedure) ? x : U.toProc(x).apply(U.NO_ARGS);
            }
            case 129: {
                return U.callCC(U.toProc(x));
            }
            case 130: {
                return Scheme.eval(x, Environment.GLOBAL);
            }
            case 131: {
                return U.callWithInputFile(x, U.toProc(y));
            }
            case 132: {
                return U.callWithOutputFile(x, U.toProc(y));
            }
            case 133: {
                return U.toBool(x instanceof InputPort);
            }
            case 134: {
                return U.toBool(x instanceof PrintWriter);
            }
            case 135: {
                return U.toInPort(U.MISSING);
            }
            case 136: {
                return U.toOutPort(U.MISSING);
            }
            case 137: {
                return U.openInputFile(x);
            }
            case 138: {
                return U.openOutputFile(x);
            }
            case 139: {
                return U.toInPort(x).close();
            }
            case 140: {
                U.toOutPort(x).close();
                return U.TRUE;
            }
            case 141: {
                return U.toInPort(x).read();
            }
            case 142: {
                return U.toInPort(x).readChar();
            }
            case 143: {
                return U.toInPort(x).peekChar();
            }
            case 144: {
                return U.toBool(x == InputPort.EOF);
            }
            case 145: {
                return U.write(x, U.toOutPort(y), true);
            }
            case 146: {
                return U.write(x, U.toOutPort(y), false);
            }
            case 147: {
                U.toOutPort(x).println();
                U.toOutPort(x).flush();
                return U.TRUE;
            }
            case 148: {
                U.toOutPort(y).print(U.to_char(x));
                return U.TRUE;
            }
            case 149: {
                return Scheme.load(x);
            }
            case 150: {
                ((Procedure)x).setName(y);
                return x;
            }
            case 151: {
                return Macro.expand(U.toPair(x));
            }
            case 152: {
                return E.error("", x);
            }
            case 153: {
                return U.maybeToClass(x);
            }
            case 154: {
                Import.addImport(U.toStr(x));
                return U.TRUE;
            }
            case 155: {
                return new RawConstructor(Invoke.findConstructor(x, U.toList(y)));
            }
            case 156: {
                return new RawMethod(Invoke.findMethod(U.toStr(x), y, (Pair)((Object)z)));
            }
            case 157: {
                return Invoke.invokeConstructor(U.toClass(x).getName(), U.listToVector(y));
            }
            case 158: {
                return Invoke.invokeInstance(x, y, U.listToVector(z));
            }
            case 159: {
                return Invoke.invokeStatic(U.toClass(x), y, U.listToVector(z));
            }
            case 160: {
                return Invoke.peek(x, U.toStr(y));
            }
            case 161: {
                return Invoke.peekStatic(U.toClass(x), U.toStr(y));
            }
            case 162: {
                return Invoke.poke(x, U.toStr(y), z);
            }
            case 163: {
                return Invoke.pokeStatic(U.toClass(x), U.toStr(y), z);
            }
            case 164: {
                Scheme.EXIT = true;
                return U.toBool(true);
            }
            case 165: {
                return U.timeCall(U.toProc(x), U.toInt(y, 1));
            }
            case 166: {
                return U.listToArray(U.toClass(x), U.toList(y));
            }
            case 167: {
                return U.arrayToList(x);
            }
            case 168: {
                return Op.mod(x, y);
            }
            case 169: {
                return Op.and(x, y);
            }
            case 170: {
                return Op.or(x, y);
            }
            case 171: {
                return Op.xor(x, y);
            }
            case 172: {
                return Op.complement(x);
            }
            case 173: {
                return U.toBool(Op.ne(x, y));
            }
            case 174: {
                return Op.leftShift(x, y);
            }
            case 175: {
                return Op.rightShift(x, y);
            }
            case 176: {
                return Op.rightShiftZ(x, y);
            }
            case 177: {
                return Procedure.throwRuntimeException(new JschemeThrowable(x));
            }
            case 178: {
                return Procedure.synchronize(x, U.toProc(y));
            }
            case 179: {
                return x == null ? null : ((Pair)REPL.parseScheme((String)((String)x))).first;
            }
            case 180: {
                return x == null ? null : REPL.parseScheme((String)x);
            }
        }
        return E.error("internal error: unknown primitive opcode" + this.opcode + " applied to " + args);
    }

    static void loadPrimitives() {
        int n = Integer.MAX_VALUE;
        new Primitive("string->exprlist", 180, 1, 1);
        new Primitive("string->expr", 179, 1, 1);
        new Primitive("synchronize", 178, 2, 2);
        new Primitive("throw", 177, 1, 1);
        new Primitive(">>>", 176, 2, 2);
        new Primitive(">>", 175, 2, 2);
        new Primitive("<<", 174, 2, 2);
        new Primitive("!=", 173, 2, 2);
        new Primitive("~", 172, 1, 1);
        new Primitive("^", 171, 2, 2);
        new Primitive("|", 170, 2, 2);
        new Primitive("&", 169, 2, 2);
        new Primitive("%", 168, 2, 2);
        new Primitive("array->list", 167, 1, 1);
        new Primitive("list->array", 166, 2, 2);
        new Primitive("time-call", 165, 2, 2);
        new Primitive("exit", 164, 0, 0);
        new Primitive("poke-static", 163, 3, 3);
        new Primitive("poke", 162, 3, 3);
        new Primitive("peek-static", 161, 2, 2);
        new Primitive("peek", 160, 2, 2);
        new Primitive("invoke-static", 159, 2, n);
        new Primitive("invoke", 158, 2, n);
        new Primitive("new", 157, 1, n);
        new Primitive("method", 156, 2, n);
        new Primitive("constructor", 155, 1, n);
        new Primitive("import", 154, 1, 1);
        new Primitive("class", 153, 1, 1);
        new Primitive("error", 152, 0, n);
        new Primitive("macroexpand", 151, 1, 1);
        new Primitive("set-procedure-name!", 150, 2, 2);
        new Primitive("load", 149, 1, 1);
        new Primitive("write-char", 148, 1, 2);
        new Primitive("newline", 147, 0, 1);
        new Primitive("display", 146, 1, 2);
        new Primitive("write", 145, 1, 2);
        new Primitive("eof-object?", 144, 1, 1);
        new Primitive("peek-char", 143, 0, 1);
        new Primitive("read-char", 142, 0, 1);
        new Primitive("read", 141, 0, 1);
        new Primitive("close-output-port", 140, 1, 1);
        new Primitive("close-input-port", 139, 1, 1);
        new Primitive("open-output-file", 138, 1, 1);
        new Primitive("open-input-file", 137, 1, 1);
        new Primitive("current-output-port", 136, 0, 0);
        new Primitive("current-input-port", 135, 0, 0);
        new Primitive("output-port?", 134, 1, 1);
        new Primitive("input-port?", 133, 1, 1);
        new Primitive("call-with-output-file", 132, 2, 2);
        new Primitive("call-with-input-file", 131, 2, 2);
        new Primitive("eval", 130, 1, 1);
        new Primitive("call-with-current-continuation", 129, 1, 1);
        new Primitive("call/cc", 129, 1, 1);
        new Primitive("force", 128, 1, 1);
        new Primitive("for-each", 127, 2, n);
        new Primitive("map", 126, 2, n);
        new Primitive("apply", 125, 2, 2);
        new Primitive("procedure?", 124, 1, 1);
        new Primitive("list->vector", 123, 1, 1);
        new Primitive("vector->list", 122, 1, 1);
        new Primitive("vector-set!", 121, 3, 3);
        new Primitive("vector-ref", 120, 2, 2);
        new Primitive("vector-length", 119, 1, 1);
        new Primitive("vector", 118, 0, n);
        new Primitive("make-vector", 117, 1, 2);
        new Primitive("vector?", 116, 1, 1);
        new Primitive("list->string", 115, 1, 1);
        new Primitive("string->list", 114, 1, 1);
        new Primitive("string-append", 113, 0, n);
        new Primitive("substring", 112, 3, 3);
        new Primitive("string-ci<=?", 111, 2, 2);
        new Primitive("string-ci>=?", 110, 2, 2);
        new Primitive("string-ci>?", 109, 2, 2);
        new Primitive("string-ci<?", 108, 2, 2);
        new Primitive("string<=?", 107, 2, 2);
        new Primitive("string>=?", 106, 2, 2);
        new Primitive("string>?", 105, 2, 2);
        new Primitive("string<?", 104, 2, 2);
        new Primitive("string-ci=?", 103, 2, 2);
        new Primitive("string=?", 102, 2, 2);
        new Primitive("string-set!", 101, 3, 3);
        new Primitive("string-ref", 100, 2, 2);
        new Primitive("string-length", 99, 1, 1);
        new Primitive("string", 98, 0, n);
        new Primitive("make-string", 97, 1, 2);
        new Primitive("string?", 96, 1, 1);
        new Primitive("char-downcase", 95, 1, 1);
        new Primitive("char-upcase", 94, 1, 1);
        new Primitive("integer->char", 93, 1, 1);
        new Primitive("char->integer", 92, 1, 1);
        new Primitive("char-lower-case?", 91, 1, 1);
        new Primitive("char-upper-case?", 90, 1, 1);
        new Primitive("char-whitespace?", 89, 1, 1);
        new Primitive("char-numeric?", 88, 1, 1);
        new Primitive("char-alphabetic?", 87, 1, 1);
        new Primitive("char-ci<=?", 86, 2, 2);
        new Primitive("char-ci>=?", 85, 2, 2);
        new Primitive("char-ci>?", 84, 2, 2);
        new Primitive("char-ci<?", 83, 2, 2);
        new Primitive("char-ci=?", 82, 2, 2);
        new Primitive("char<=?", 81, 2, 2);
        new Primitive("char>=?", 80, 2, 2);
        new Primitive("char>?", 79, 2, 2);
        new Primitive("char<?", 78, 2, 2);
        new Primitive("char=?", 77, 2, 2);
        new Primitive("char?", 76, 1, 1);
        new Primitive("string->number", 75, 1, 2);
        new Primitive("number->string", 74, 1, 2);
        new Primitive("inexact->exact", 73, 1, 1);
        new Primitive("exact->inexact", 72, 1, 1);
        new Primitive("expt", 71, 2, 2);
        new Primitive("sqrt", 70, 1, 1);
        new Primitive("atan", 69, 1, 1);
        new Primitive("acos", 68, 1, 1);
        new Primitive("asin", 67, 1, 1);
        new Primitive("tan", 66, 1, 1);
        new Primitive("cos", 65, 1, 1);
        new Primitive("sin", 64, 1, 1);
        new Primitive("log", 63, 1, 1);
        new Primitive("exp", 62, 1, 1);
        new Primitive("round", 61, 1, 1);
        new Primitive("truncate", 60, 1, 1);
        new Primitive("ceiling", 59, 1, 1);
        new Primitive("floor", 58, 1, 1);
        new Primitive("lcm", 57, 0, n);
        new Primitive("gcd", 56, 0, n);
        new Primitive("modulo", 55, 2, 2);
        new Primitive("remainder", 54, 2, 2);
        new Primitive("quotient", 53, 2, 2);
        new Primitive("abs", 52, 1, 1);
        new Primitive("/", 51, 2, 2);
        new Primitive("-", 50, 1, 2);
        new Primitive("*", 49, 0, n);
        new Primitive("+", 48, 0, n);
        new Primitive("min", 47, 1, n);
        new Primitive("max", 46, 1, n);
        new Primitive("even?", 45, 1, 1);
        new Primitive("odd?", 44, 1, 1);
        new Primitive("negative?", 43, 1, 1);
        new Primitive("positive?", 42, 1, 1);
        new Primitive("zero?", 41, 1, 1);
        new Primitive(">=", 40, 1, n);
        new Primitive("<=", 39, 1, n);
        new Primitive(">", 38, 1, n);
        new Primitive("<", 37, 1, n);
        new Primitive("=", 36, 1, n);
        new Primitive("inexact?", 35, 1, 1);
        new Primitive("exact?", 34, 1, 1);
        new Primitive("integer?", 33, 1, 1);
        new Primitive("rational?", 33, 1, 1);
        new Primitive("real?", 32, 1, 1);
        new Primitive("complex?", 32, 1, 1);
        new Primitive("number?", 32, 1, 1);
        new Primitive("string->symbol", 31, 1, 1);
        new Primitive("symbol->string", 30, 1, 1);
        new Primitive("symbol?", 29, 1, 1);
        new Primitive("assoc", 28, 2, 2);
        new Primitive("assv", 27, 2, 2);
        new Primitive("assq", 26, 2, 2);
        new Primitive("member", 25, 2, 2);
        new Primitive("memv", 24, 2, 2);
        new Primitive("memq", 23, 2, 2);
        new Primitive("list-ref", 22, 2, 2);
        new Primitive("list-tail", 21, 2, 2);
        new Primitive("reverse", 20, 1, 1);
        new Primitive("append", 19, 0, n);
        new Primitive("length", 18, 1, 1);
        new Primitive("list", 17, 0, n);
        new Primitive("list?", 16, 1, 1);
        new Primitive("null?", 15, 1, 1);
        new Primitive("cddddr", 14, 1, 1);
        new Primitive("cdddar", 14, 1, 1);
        new Primitive("cddadr", 14, 1, 1);
        new Primitive("cddaar", 14, 1, 1);
        new Primitive("cdaddr", 14, 1, 1);
        new Primitive("cdadar", 14, 1, 1);
        new Primitive("cdaadr", 14, 1, 1);
        new Primitive("cdaaar", 14, 1, 1);
        new Primitive("cadddr", 14, 1, 1);
        new Primitive("caddar", 14, 1, 1);
        new Primitive("cadadr", 14, 1, 1);
        new Primitive("cadaar", 14, 1, 1);
        new Primitive("caaddr", 14, 1, 1);
        new Primitive("caadar", 14, 1, 1);
        new Primitive("caaadr", 14, 1, 1);
        new Primitive("caaaar", 14, 1, 1);
        new Primitive("cdddr", 14, 1, 1);
        new Primitive("cddar", 14, 1, 1);
        new Primitive("cdadr", 14, 1, 1);
        new Primitive("cdaar", 14, 1, 1);
        new Primitive("cadar", 14, 1, 1);
        new Primitive("caadr", 14, 1, 1);
        new Primitive("caaar", 14, 1, 1);
        new Primitive("cddr", 14, 1, 1);
        new Primitive("cdar", 14, 1, 1);
        new Primitive("caar", 14, 1, 1);
        new Primitive("third", 13, 1, 1);
        new Primitive("caddr", 13, 1, 1);
        new Primitive("second", 12, 1, 1);
        new Primitive("cadr", 12, 1, 1);
        new Primitive("set-cdr!", 11, 2, 2);
        new Primitive("set-car!", 10, 2, 2);
        new Primitive("rest", 9, 1, 1);
        new Primitive("cdr", 9, 1, 1);
        new Primitive("first", 8, 1, 1);
        new Primitive("car", 8, 1, 1);
        new Primitive("cons", 7, 2, 2);
        new Primitive("pair?", 6, 1, 1);
        new Primitive("equal?", 5, 2, 2);
        new Primitive("eq?", 4, 2, 2);
        new Primitive("eqv?", 3, 2, 2);
        new Primitive("boolean?", 2, 1, 1);
        new Primitive("not", 1, 1, 1);
        String derived = "(begin (set! define (set-procedure-name! (macro (var . body) (if (pair? var) (list 'set! (first var) (list 'set-procedure-name! (cons 'lambda (cons (rest var) body)) (list 'quote (first var)))) (cons 'set! (cons var body)))) 'define)) (define cond (macro clauses (define (process-clause clause else-part) (if (not (pair? clause)) (error '(bad cond clause:) clause) (if (null? (rest clause)) (list 'or (first clause) else-part) (if (eq? (second clause) '=>) ((lambda (tempvar) (list (list 'lambda (list tempvar) (list 'if tempvar (list (third clause) tempvar) else-part)) (first clause))) (string->symbol \"temp var\")) (if (member (first clause) '(#t else)) (cons 'begin (rest clause)) (list 'if (first clause) (cons 'begin (rest clause)) else-part)))))) (if (null? clauses) #f (process-clause (first clauses) (cons 'cond (rest clauses)))))) (define tryCatch (macro args (list 'jsint.Procedure.tryCatch (list 'lambda () (first args)) (second args)))) (define and (macro args (cond ((null? args) #t) ((null? (rest args)) (first args)) (else (list 'if (first args) (cons 'and (rest args)) #f))))) (define quasiquote (macro (x) (define (constant? exp) (if (pair? exp) (eq? (car exp) 'quote) (not (symbol? exp)))) (define (combine-skeletons left right exp) (cond ((and (constant? left) (constant? right)) (if (and (eqv? (eval left) (car exp)) (eqv? (eval right) (cdr exp))) (list 'quote exp) (list 'quote (cons (eval left) (eval right))))) ((null? right) (list 'list left)) ((and (pair? right) (eq? (car right) 'list)) (cons 'list (cons left (cdr right)))) (else (list 'cons left right)))) (define (expand-quasiquote exp nesting) (cond ((vector? exp) (list 'apply 'vector (expand-quasiquote (vector->list exp) nesting))) ((not (pair? exp)) (if (constant? exp) exp (list 'quote exp))) ((and (eq? (car exp) 'unquote) (= (length exp) 2)) (if (= nesting 0) (second exp) (combine-skeletons ''unquote (expand-quasiquote (cdr exp) (- nesting 1)) exp))) ((and (eq? (car exp) 'quasiquote) (= (length exp) 2)) (combine-skeletons ''quasiquote (expand-quasiquote (cdr exp) (+ nesting 1)) exp)) ((and (pair? (car exp)) (eq? (caar exp) 'unquote-splicing) (= (length (car exp)) 2)) (if (= nesting 0) (list 'append (second (first exp)) (expand-quasiquote (cdr exp) nesting)) (combine-skeletons (expand-quasiquote (car exp) (- nesting 1)) (expand-quasiquote (cdr exp) nesting) exp))) (else (combine-skeletons (expand-quasiquote (car exp) nesting) (expand-quasiquote (cdr exp) nesting) exp)))) (expand-quasiquote x 0))) (define let (macro (bindings . body) (define (named-let name bindings body) `(let ((,name #f)) (set! ,name (lambda ,(map first bindings) unquote body)) (,name unquote (map second bindings)))) (if (symbol? bindings) (named-let bindings (first body) (rest body)) `((lambda ,(map first bindings) unquote body) unquote (map second bindings))))) (define let* (macro (bindings . body) (if (null? bindings) `((lambda () unquote body)) `(let (,(first bindings)) (let* ,(rest bindings) unquote body))))) (define letrec (macro (bindings . body) (let ((vars (map first bindings)) (vals (map second bindings))) `(let ,(map (lambda (var) `(,var #f)) vars) ,@(map (lambda (var val) `(set! ,var ,val)) vars vals) unquote body)))) (define case (macro (exp . cases) (let ((tempvar (string->symbol \"temp var\"))) (define (do-case case) (cond ((not (pair? case)) (error '(bad syntax in case:) case)) ((eq? (first case) 'else) case) (else `((member ,tempvar ',(first case)) unquote (rest case))))) `(let ((,tempvar ,exp)) (cond unquote (map do-case cases)))))) (define do (macro (bindings test-and-result . body) (let ((variables (map first bindings)) (inits (map second bindings)) (steps (map (lambda (clause) (if (null? (cddr clause)) (first clause) (third clause))) bindings)) (result (if (null? (cdr test-and-result)) ''unspecified `(begin unquote (cdr test-and-result))))) (let ((tempvar '<loop>)) `(letrec ((,tempvar (lambda ,variables (if ,(first test-and-result) ,result (begin ,@body (,tempvar unquote steps)))))) (,tempvar unquote inits)))))) (define delay (macro (exp) (define (make-promise proc) (let ((result-ready? #f) (result #f)) (lambda () (if result-ready? result (let ((x (proc))) (if result-ready? result (begin (set! result-ready? #t) (set! result x) result))))))) `(,make-promise (lambda () ,exp)))) (define time (macro (exp . rest) `(time-call (lambda () ,exp) unquote rest))) (define define-macro (macro (spec . body) (if (pair? spec) `(define ,(first spec) (macro ,(rest spec) unquote body)) `(define ,spec (macro ,(second (first body)) ,@(rest (rest (first body)))))))) (define (missing-classes classes sofar) (if (null? classes) sofar (missing-classes (cdr classes) (if (eq? (class (car classes)) #null) (cons (car classes) sofar) sofar)))) (define-macro (if-classes classes then else) (if (null? (missing-classes classes '())) then else)) (define-macro (when-classes classes . then) `(if-classes ,classes (begin ,@then) #f)) (define-macro (class-case varlist . clauses) (define (runtimeClassName c) (string->symbol (string-append (.getName (class c)) \".class\"))) (define (instanceof v c) `(.isInstance ,(runtimeClassName c) ,v)) `(cond ,@(map (lambda (clause) (if (equal? (first clause) 'else) clause `((and ,@(map instanceof varlist (first clause))) ,@(rest clause)))) clauses))) (define (define-method-runtime name type-names f name-args) (let ((missing (missing-classes type-names '()))) (if (null? missing) (jsint.Generic.defineMethod name type-names f) (jsint.E.warn (string-append \"Can't define-method \" name-args \" classes \" missing \" do not exist.\"))))) (define define-method (macro (name-args . body) (define (arg-name x) (if (pair? x) (car x) x)) (define (maybe-second x default) (if (and (pair? x) (pair? (cdr x))) (cadr x) default)) (define (arg-type x) (maybe-second x 'java.lang.Object)) (let* ((name (car name-args)) (args (cdr name-args)) (arg-types (map arg-type args))) `(define-method-runtime ',name ',arg-types (lambda ,(map arg-name args) ,@body) ',name-args)))) (define package (macro args #t)) (define (array a-class . args) (let ((v (make-array a-class (length args)))) (let loop ((i 0) (as args)) (if (null? as) v (begin (vector-set! v i (car as)) (loop (+ i 1) (cdr as))))))) (define (make-array a-class size) (java.lang.reflect.Array.newInstance a-class size)))";
        Scheme.load(new InputPort(new StringReader(derived)));
        primitives_loaded = true;
    }

    static {
        Primitive.loadPrimitives();
    }
}

