/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import jsint.E;
import jsint.Import;
import jsint.Invoke;
import jsint.Pair;
import jsint.Procedure;
import jsint.StaticReflector;
import jsint.Symbol;
import jsint.U;

public class Generic
extends StaticReflector {
    private Object[] methodTable;

    public Object[] getMethodTable() {
        return this.methodTable;
    }

    public Generic(String name) {
        this.name = name;
    }

    private void addMethod(Class[] types, Procedure p) {
        if (this.methodTable == null) {
            this.methodTable = new Object[2];
            this.install(0, types, p);
        } else {
            int i = 0;
            while (i < this.methodTable.length) {
                if (Invoke.parameterTypesMatch((Class[])this.methodTable[i], types)) {
                    this.install(i, types, p);
                    return;
                }
                i += 2;
            }
            this.grow();
            this.install(this.methodTable.length - 2, types, p);
        }
    }

    private void install(int i, Class[] types, Procedure p) {
        this.methodTable[i] = types;
        this.methodTable[i + 1] = p;
    }

    private void grow() {
        Object[] ms = new Object[this.methodTable.length + 2];
        System.arraycopy(this.methodTable, 0, ms, 0, this.methodTable.length);
        this.methodTable = ms;
    }

    private static Generic ensureGeneric(Symbol name) {
        if (name.isDefined()) {
            Object v = name.getGlobalValue();
            if (!(v instanceof Generic)) {
                return (Generic)E.error(name + " is already bound to " + v);
            }
            return (Generic)v;
        }
        Generic g = new Generic(name.toString());
        name.setGlobalValue(g);
        return g;
    }

    public static synchronized Generic defineMethod(Symbol name, Pair types, Procedure p) {
        Generic g = Generic.ensureGeneric(name);
        g.addMethod(Invoke.toClassArray(types, 0), p);
        return g;
    }

    public Object apply(Object[] args) {
        Procedure m = (Procedure)Invoke.findMethodNoOpt(this.methodTable, args);
        if (m.minArgs == 0 && m.maxArgs == Integer.MAX_VALUE) {
            return m.apply(new Object[]{U.vectorToList(args)});
        }
        return m.apply(args);
    }

    protected synchronized void reset() {
        int i = 0;
        while (i < this.methodTable.length) {
            this.methodTable[i] = this.resetParameters((Class[])this.methodTable[i]);
            i += 2;
        }
    }

    private Object[] resetParameters(Class[] parameters) {
        Object[] parameters2 = new Class[parameters.length];
        int i = 0;
        while (i < parameters2.length) {
            parameters2[i] = Import.forName(parameters[i].getName());
            ++i;
        }
        return parameters2;
    }
}

