/*
 * Decompiled with CFR 0.152.
 */
package jsint;

import jsint.E;
import jsint.Environment;
import jsint.Pair;
import jsint.Procedure;
import jsint.Scheme;
import jsint.U;

public class Closure
extends Procedure
implements Cloneable {
    Object body;
    Environment env;
    Object parms;

    public Closure(Object parms, Object body, Environment env) {
        this.parms = parms;
        this.body = body;
        this.env = env;
        this.computeArgs(parms, 0);
    }

    private void computeArgs(Object parms, int min) {
        if (U.isPair(parms)) {
            this.computeArgs(((Pair)parms).rest, min + 1);
        } else if (parms == Pair.EMPTY) {
            this.minArgs = min;
            this.maxArgs = min;
        } else {
            this.minArgs = min;
            this.maxArgs = Integer.MAX_VALUE;
        }
    }

    public Object apply(Object[] args) {
        return Scheme.execute(this.body, new Environment(this.parms, args, this.env));
    }

    public Closure copy(Environment env) {
        Closure c = null;
        try {
            c = (Closure)this.clone();
        }
        catch (CloneNotSupportedException e) {
            E.error("internal error: no clone");
        }
        c.env = env;
        return c;
    }

    public String toString() {
        return "{" + this.getClass().getName() + " " + this.name + this.toStringArgs() + " " + U.stringify(this.parms) + "}";
    }
}

