/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.logutil;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import jsint.Pair;

public class IndentingPrintWriter
extends PrintWriter {
    private int level = 0;
    private int indentWidth = 4;
    private String indentString = "";

    public void printMsg(String string, Pair pair) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "@", true);
        StringBuffer stringBuffer = new StringBuffer();
        Object object = pair.first;
        Pair pair2 = (Pair)pair.rest;
        String string2 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("@")) {
                if (object != null) {
                    stringBuffer.append(object);
                    object = pair2.first;
                    pair2 = (Pair)pair2.rest;
                    continue;
                }
                throw new Error("List too short for message");
            }
            stringBuffer.append(string2);
        }
        this.print(stringBuffer);
        this.println();
    }

    public IndentingPrintWriter(Writer writer) {
        super(writer, true);
    }

    public IndentingPrintWriter(Writer writer, boolean bl) {
        super(writer, bl);
    }

    public IndentingPrintWriter(OutputStream outputStream) {
        super(outputStream, true);
    }

    public IndentingPrintWriter(OutputStream outputStream, boolean bl) {
        super((Writer)new BufferedWriter(new OutputStreamWriter(outputStream)), bl);
    }

    public void setIndentWidth(int n) {
        this.indentWidth = n;
        this.updateIndentString();
    }

    public void indent() {
        ++this.level;
        this.updateIndentString();
    }

    public void undent() {
        if (this.level > 0) {
            --this.level;
            this.updateIndentString();
        }
    }

    private void updateIndentString() {
        int n = this.level * this.indentWidth;
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(" ");
            ++n2;
        }
        this.indentString = stringBuffer.toString();
    }

    public void println() {
        super.println();
        this.print(this.indentString);
    }
}

