#
# openh323u.mak
#
# Make symbols include file for Open H323 library
#
# Copyright (c) 1998-2000 Equivalence Pty. Ltd.
#
# The contents of this file are subject to the Mozilla Public License
# Version 1.0 (the "License"); you may not use this file except in
# compliance with the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS"
# basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
# the License for the specific language governing rights and limitations
# under the License.
#
# The Original Code is Open H323 library.
#
# The Initial Developer of the Original Code is Equivalence Pty. Ltd.
#
# Contributor(s): ______________________________________.
#
# $Log: openh323u.mak,v $
# Revision 1.28  2002/01/14 15:38:09  rogerh
# Look for telephony.h in /usr/local/include/sys (which is where the
# FreeBSD Ports Tree copy of the ixj driver puts the header files)
#
# Revision 1.27  2001/11/27 22:48:40  robertj
# Changed to make system to better support non-shared library building.
#
# Revision 1.26  2001/10/09 09:05:24  robertj
# Added LIBDIRS variable so can go "make libs" to build openh323 & pwlib
#
# Revision 1.25  2001/10/05 03:28:18  robertj
# Fixed the inclusion of VPB support if can find the library somewhere.
#
# Revision 1.24  2001/09/11 08:33:05  robertj
# Prevented inclusion of xJack if cross compiling to Nucleus, thanks Nick Hoath
#
# Revision 1.23  2001/09/11 01:24:36  robertj
# Added conditional compilation to remove video and/or audio codecs.
#
# Revision 1.22  2001/05/16 07:35:10  robertj
# New minor version
#
# Revision 1.21  2001/05/03 01:43:55  rogerh
# There is no need to test for X11 as the openh323 library does not use it
#
# Revision 1.20  2001/03/15 11:29:52  rogerh
# use NO_XWINDOWS=1 to compile without X11 support on systems with X11 installed
#
# Revision 1.19  2001/02/10 04:01:50  robertj
# Fixed build system so application can be built NOTRACE to separate directory.
#
# Revision 1.18  2001/02/09 04:44:37  craigs
# Added ability create a NOTRACE version of an exectuable with seperate
# libraries
#
# Revision 1.17  2000/10/30 00:23:56  robertj
# Added auto inclusion of ptlib make rules
#


ifndef PWLIBDIR
PWLIBDIR=$(HOME)/pwlib
endif

LIBDIRS += $(OPENH323DIR)


ifndef PWLIB_FILE
ifdef NOTRACE
ifndef OH323_LIBRARY_MAKEFILE
OBJDIR_SUFFIX := n
endif
endif
include $(PWLIBDIR)/make/ptlib.mak
endif


#OH323_SUPPRESS_H235	= 1


OH323_SRCDIR = $(OPENH323DIR)/src
OH323_INCDIR = $(OPENH323DIR)/include
OH323_LIBDIR = $(OPENH323DIR)/lib


ifdef NOTRACE
STDCCFLAGS += -DPASN_NOPRINTON -DPASN_LEANANDMEAN
OH323_SUFFIX = n
else
STDCCFLAGS += -DPTRACING
RCFLAGS	   += -DPTRACING
OH323_SUFFIX = $(OBJ_SUFFIX)
endif

ifdef NOAUDIOCODECS
STDCCFLAGS += -DNO_H323_AUDIO_CODECS
endif

ifdef NOVIDEO
STDCCFLAGS += -DNO_H323_VIDEO
endif



OH323_BASE  = h323_$(PLATFORM_TYPE)_$(OH323_SUFFIX)$(LIB_TYPE)
OH323_FILE  = lib$(OH323_BASE).$(LIB_SUFFIX)

LDFLAGS	    += -L$(OH323_LIBDIR)
LDLIBS	    := -l$(OH323_BASE) $(LDLIBS)

STDCCFLAGS  += -I$(OH323_INCDIR)


ifneq ($(OS),Nucleus)

ifdef	OH323_SUPPRESS_H235
STDCCFLAGS  += -DOH323_SUPPRESS_H235
endif

ifneq (,$(wildcard /usr/include/linux/telephony.h))
HAS_IXJ	    = 1
STDCCFLAGS += -DHAS_IXJ
endif

ifneq (,$(wildcard /usr/include/sys/telephony.h))
HAS_IXJ	    = 1
STDCCFLAGS += -DHAS_IXJ
endif

ifneq (,$(wildcard /usr/local/include/sys/telephony.h))
HAS_IXJ	    = 1
STDCCFLAGS += -DHAS_IXJ -I/usr/local/include
endif

ifneq (,$(wildcard /usr/include/linux/soundcard.h))
HAS_OSS	    = 1
STDCCFLAGS += -DHAS_OSS
endif

endif # !Nucleus



VPB_LIB := vpb
ifneq (,$(wildcard /usr/lib/lib$(VPB_LIB).a))
VPB_LIB_PATH=/usr/lib
else
ifneq (,$(wildcard /usr/local/lib/lib$(VPB_LIB).a))
VPB_LIB_PATH=/usr/local/lib
else
ifeq ($(OSTYPE),linux)
ifneq (,$(wildcard $(OH323_SRCDIR)/lib$(VPB_LIB).a))
VPB_LIB_PATH=$(OH323_SRCDIR)
else
ifneq (,$(wildcard ./lib$(VPB_LIB).a))
VPB_LIB_PATH=.
endif # current directory
endif # openhrer/src
endif # linux
endif # /usr/local/lib
endif # /usr/lib

ifdef VPB_LIB_PATH
HAS_VPB    := 1
STDCCFLAGS += -DHAS_VPB
LDFLAGS	   += -L$(VPB_LIB_PATH)
LDLIBS	   += -l$(VPB_LIB)
endif


$(TARGET) :	$(OH323_LIBDIR)/$(OH323_FILE)

ifndef OH323_LIBRARY_MAKEFILE
ifdef DEBUG
$(OH323_LIBDIR)/$(OH323_FILE):
	$(MAKE) -C $(OH323_SRCDIR) debug
else
$(OH323_LIBDIR)/$(OH323_FILE):
	$(MAKE) -C $(OH323_SRCDIR) opt
endif
endif


# End of file

