/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <opencm.h>

void
wireu_serialize(SDR_stream *strm, const void *ob)
{
  const WireUnsigned *p = ob;
  
  sdr_w_u64("value", strm, p->value);
  
} /* end wireu_serialize */

void *
wireu_deserialize(const DeserializeInfo *di, SDR_stream *strm)
{
  WireUnsigned *p = (WireUnsigned *) GC_MALLOC(sizeof(WireUnsigned));

  ser_init(p, &WireUnsigned_SerType, di->ver);
  p->value          = sdr_r_u64("value", strm);

  return p;
} /* end wireu_deserialize */

void
wireu_mark(Repository *r, const void *container,
	   const void *ob, rbtree *memObs)
{
  assert(container == ob);
  /* Leaf object. Nothing to do */
}

WireUnsigned *
wireu_create(uint64_t argument)
{
  WireUnsigned *p = (WireUnsigned *) GC_MALLOC(sizeof(WireUnsigned));

  ser_init(p, &WireUnsigned_SerType, WireUnsigned_SerType.ver);
  p->value = argument;

  SER_MODIFIED(p);

  return p;
} /* end stringarg_create */

OC_bool
wireu_check(const void *v)
{
  return TRUE;
}

void
wireu_show(const void *ob)
{
  const WireUnsigned *p = ob;
  report(0, "Value:     %s\n", 
	  xunsigned64_str(p->value));
}
