/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <opencm.h>

OC_bool
user_check(const void *v)
{
  return TRUE;
}

void
user_show(const void *ob)
{
  const User *u = ob;
  
  report(0, "PubKey:      %s\n", ser_getTrueName(u->pubKey));
  report(0, "DirURI:     %s\n", u->dirURI);
}

void
user_serialize(SDR_stream *strm, const void *ob)
{
  const User *u = ob;
  
  sdr_write("pubKey", strm, u->pubKey);
  sdr_w_string("dirURI", strm, u->dirURI);
}

void *
user_deserialize(const DeserializeInfo *di, SDR_stream *strm)
{
  User *u = (User *) GC_MALLOC(sizeof(User));

  ser_init(u, &User_SerType, di->ver);

  u->pubKey     = sdr_read("pubKey", strm);
  u->dirURI     = sdr_r_string("dirURI", strm);

  SER_MODIFIED(u);
  return u;
}

void
user_mark(Repository *r, const void *container, 
	  const void *ob, rbtree *memObs)
{
  const User *u = ob;

  assert(container == ob);
  ser_mark(r, container, u->pubKey, memObs);
  mark_addmark(container, memObs, u->dirURI);
}

User *
user_create(PubKey *pk, const char *dirURI)
{
  User *u = (User *) GC_MALLOC(sizeof(User));

  ser_init(u, &User_SerType, User_SerType.ver);

  u->pubKey     = pk;
  u->dirURI     = dirURI;

  SER_MODIFIED(u);
  return u;
}

User *
user_dup(User *u)
{
  User *newU = (User *) GC_MALLOC(sizeof(User));
  memcpy(newU, u, sizeof(*u));

  return newU;
}

#if 0
User *
user_create(X509 *x)
{
  long num = 0;
  void *tmpbuf = NULL;
  char *data;
  User *p = (User *) GC_MALLOC(sizeof(User));
  BIO *inMem = BIO_new(BIO_s_mem());

  if (x == NULL)
    return NULL;

  if (!PEM_write_bio_X509(inMem, x))
    return NULL;

  if ((num = BIO_get_mem_data(inMem, &tmpbuf)) == 0)
    return NULL;

  data = (char *)GC_MALLOC_ATOMIC(sizeof(char) * (num + 1));
  memcpy(data, tmpbuf, num);
  data[num] = 0;

  p->serType = &User_SerType;
  p->cert = data;
  p->cache_cert = NULL;

  BIO_set_close(inMem, BIO_NOCLOSE);
  BIO_free(inMem);

  SER_MODIFIED(p);

  return p;
} 
#endif

