/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* Format: LOGTYPE(<class>, <name>, <level>), where "level" is the
   trace level at which this gets turned on by default. Debugging
   traces normally need to be turned on explicitly, so use level -1. */

#ifndef LOGDBG
#define DEBUGGING_TRACE_LEVEL -1
#define LOGDBG(NM)       LOGTYPE(LTY_trace, DBG, NM, DEBUGGING_TRACE_LEVEL)
#define LOGTRACE(NM,LVL) LOGTYPE(LTY_trace, TRC, NM, LVL)
#define LOGERR(NM)       LOGTYPE(LTY_error, ERR, NM, 0)
#endif

LOGDBG(PATH)
LOGDBG(CACHE)
LOGDBG(LOCK)
LOGDBG(COMMIT)
     /* Things that go bump in the repository */
LOGDBG(WALK)
LOGDBG(REQUEST)
LOGDBG(URI)
LOGDBG(COMPRESS)
LOGDBG(RESOLVER)
LOGDBG(REPOS)
LOGDBG(REPOS_CREATE)
LOGDBG(REPOS_NOTRAILS)
LOGDBG(XDFS)
LOGDBG(SXDELTA)
LOGDBG(USER_CREATE)
LOGDBG(CHANGE_ANCESTOR)
LOGDBG(MERGE)
LOGDBG(STARTUP)
LOGDBG(GC)
LOGDBG(RBTREE)
LOGDBG(RPMVERSION)
LOGDBG(SUBPROC)
LOGDBG(PROTO)
LOGDBG(UPGRADE)

     /* Messages related to server upgrades show by default */
LOGTRACE(UPGRADE, 0)
     /* Messages related to server startup and shutdown */
LOGTRACE(SERVER, 0)
     /* Messages related to client-side setup show by default */
LOGTRACE(SETUP, 0)
     /* Help messages show by default. Upgrade the level to remove
      * diagnostics the user can't understand anyway. :-) */
LOGTRACE(HELP, 0)
     /* Bugs are things we want to hear about. */
LOGTRACE(BUG, 0)
     /* Things that impact CWD get announced by default */
LOGTRACE(CHDIR, 0)
     /* Server crypto errors show at trace level 0 */
LOGTRACE(CRYPTO, 0)
     /* Channel tracing at level 0, because it only happens in
	response to an explicit request */
LOGTRACE(CHANNELS, 0)
     /* Server permissions complaints show at trace level 0 */
LOGTRACE(PERMISSIONS, 0)
     /* SSL *errors* show at trace level 0 */
LOGTRACE(SSL, 0)
     /* Server COMM complaints show at trace level 1 */
LOGTRACE(COMM, 1)
     /* Client workspace complaints show at trace level 1 */
LOGTRACE(WORKSPACE, 2)

     /* Server COMM errors */
LOGERR(COMM)
     /* Server startup errors */
LOGERR(SERVER)
     /* Server GC Errors */
LOGERR(GC)
     /* RBtree errors */
LOGERR(RBTREE)
     /* SHA1 errors */
LOGERR(SHA1)
     /* XDCS errors */
LOGERR(SXDELTA)
     /* Unimplemented stuff */
LOGERR(UNIMPL)
