#ifndef COMMON_ENTITY_H
#define COMMON_ENTITY_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* Entity -- description of a particular entity
 */

#define EPRM_EXEC  0x1u		/* file should be executable */

struct Entity {
  Serializable ser;
  
  const char *familyNID;
  tnhash_t famNidHash;		/* not serialized */
  
  /* Note that the content true name is a cryptographic hash, and
   * therefore doubles as a means to determine whether this content
   * has changed or not.
   */
  
  const char *contentTrueName;
  uint32_t length;		/* length of object */

  /* Miscellaneous per-entity meta information. Much of this is
   * contained in the Change record, but it isn't accessable to the
   * merge algorithm there.
   */
  
  const char *commitInfoTrueName; /* Description (for humans) of this
				   * commit */

  const char *fsName;		/* location in file system */
  
  unsigned char entityType;	/* type of content */

  uint32_t entityPerms;	        /* permissions flags */

  const char *parent;	       /* preceding Entity (on same Branch) */
  const char *mergeParent;     /* merged, preceding Entity (if any) */
 
  const char *change_parent;   /* name of Change that contains 'parent' */
  const char *change_mergeParent; /* name of Change that contains
				     'mergeParent' */

  /* Added in object version 1: */
  const char *modTime;     /* modification time */
} ;

Entity *entity_dup(const Entity *);
Entity *entity_create(char eType, const char *famNID);
const char *entity_CreateFamNID(void);

#endif /* COMMON_ENTITY_H */
