#ifndef COMMON_BUFFER_H
#define COMMON_BUFFER_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

typedef struct Buffer Buffer;

Buffer *buffer_create(void);
void buffer_append(Buffer *, const void *, ocmoff_t len);
void buffer_appendString(Buffer *, const char *s);
void buffer_freeze(Buffer *);
ocmoff_t buffer_length(const Buffer *);

/* Extract a buffer that is a subrange of some existing buffer. */
Buffer *buffer_fromBuffer(const Buffer *in, ocmoff_t start, ocmoff_t len);

/* Following exists to facilitate conversion of SDR file streams: */
Buffer *buffer_FromFilePtr(const char *name, FILE *f);
Buffer *buffer_FromFile(const char *fileName, unsigned char eType);
void buffer_ToFile(const Buffer *buf, const char *fileName, 
		   unsigned char eType);

#define DEFAULT_COMPRESS 3

/* Currently, only zlib compression is supported. */
Buffer *buffer_compress(Buffer *, int level);
Buffer *buffer_decompress(Buffer *);

typedef struct BufferChunk BufferChunk;
struct BufferChunk {
  const unsigned char *ptr;
  ocmoff_t len;
};

BufferChunk buffer_getChunk(const Buffer *, ocmoff_t pos, ocmoff_t len);

void buffer_read(const Buffer *, void *vp, ocmoff_t pos, ocmoff_t len);
int buffer_getc(const Buffer *, ocmoff_t pos);

char *buffer_asString(const Buffer *);

const char *buffer_getContentTrueName(const Buffer *);
#endif /* COMMON_BUFFER_H */
