/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

typedef uint32_t phash_t;

phash_t psum(const unsigned char *buf, size_t len);

phash_t psum_incremental(phash_t sum, const unsigned char *buf, size_t len);

/* psum_progressive is a variant implementation used by sxdelta to
   incrementally compute a sum over a moving window of the input. It
   is included in phash.c because it needs to make reference to the
   same magic number table. /cold/ is the character that is being
   removed from the "front" of the window as the window moves
   forward. /cnew/ is the character that is being appended to the end
   of the window as a result of the window moving. /lg2chunkSz/ is the
   base 2 log of the window size.

   The idea is that the progressively computed result will match the
   non-incrementally computed result on the window that would be
   produced by psum().

   The progressive sum computation works only for windows that are a
   power of two in size, and then only up to windows of size 2^6 (64
   bytes). Beyond that the implementation will generate internal
   overflows. */
phash_t psum_progressive(phash_t sum, unsigned lg2winSz,
			 unsigned char cold, unsigned char cnew);

#define psum(buf,len) psum_incremental(0u, buf, len)
