#ifndef COMMON_INTTYPES_H
#define COMMON_INTTYPES_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* 
  Try to get some basic typedefs to prevent us from being totally screwed on
  64-bit systems, etc. If we can, use the system's stdint.h or inttypes.h.
  stdint.h is from C99, and will (in the future) be the most widely supported
  such header. IIRC even Windows has it now.

  inttypes.h is a Unix thing (I think it was in SUS or maybe POSIX-2000)

  If we have neither, do a "best guess". See below for further comments on
  this.
*/

#if HAVE_STDINT_H
  #include <stdint.h>
#elif HAVE_INTTYPES_H
  #include <inttypes.h>
#endif

/* The size of these underlying types depends on the system and the compiler,
   but char/short/int works for most 32-bit and 64-bit systems. Won't work on
   DOS or Win 3.x. If you're using those systems: <rude comment deleted>
*/
#if !defined(HAVE_STDINT_H) && !defined(HAVE_INTTYPES_H)
  typedef unsigned char uint8_t;
  typedef unsigned short uint16_t;
  typedef unsigned int uint32_t;

  #if SIZEOF_UNSIGNED_LONG_LONG == 8
    typedef unsigned long long uint64_t;
  #elif SIZEOF___UINT64 == 8
    typedef __uint64 uint64_t;
  #else
    #error "OpenCM requires a 64-bit unsigned type."
  #endif /* PICK A LONG LONG */
#endif /* END: No stdint.h or inttypes.h */

/* We may want to replace these ocmoff_t's with uint64_t, given that the
   size MUST be 64 bits or the code breaks anyway
*/
typedef uint64_t ocmoff_t;

/* This is the old name, before we started using stdint.h
   Most of the references to it have been removed but there might be
   a few left. FIX: Remove them and then remove this typedef
*/
typedef uint64_t oc_uint64_t;

#endif /* COMMON_INTTYPES_H */
