#ifndef COMMON_SSLCOMMON_H
#define COMMON_SSLCOMMON_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef HAVE_OPENSSL
  #error "Configure script did not locate OpenSSL"
#endif

#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/rand.h>

#ifndef OPENSSL_VERSION_NUMBER
  #error "OPENSSL_VERSION_NUMBER is not defined!"
#endif

/*
   opensslv.h documents this format: it should match 0.9.6-dev or higher
   versions, which seems about right. We need 0.9.6 cause PRNG.c wants
   to use RAND_egd_bytes, which is not available in 0.9.5 or previous versions.

   A couple other (older) version formats are mentioned in the header. However,
   all of them should result in a version code less than x09060000, so we should
   be OK.
*/
#if (OPENSSL_VERSION_NUMBER < 0x00906000)
  #error "OpenSSL 0.9.6 or higher is required by OpenCM"
#endif

extern BIO *bio_err;
int berr_exit(char *);
int err_exit(char *);

SSL_CTX *ssl_init_ctx(const char *keyfile, const char *certfile);

void ssl_destroy_ctx(SSL_CTX *ctx);

extern X509 *ssl_read_cert_file(const char *keyfile);
void ssl_write_cert_file(const char *keyfile, X509 *cert);

#endif /* COMMON_SSLCOMMON_H */
