#ifndef OPENCM_H
#define OPENCM_H

/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "../config.h"

#ifndef __GNUC__
#define __attribute(x)__ 
#endif /* __GNUC__ */

#include <sys/time.h>
#include <sys/stat.h>

#include <ctype.h>
#include <errno.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <limits.h>
#include <dirent.h>
#include <assert.h>
#include <setjmp.h>
#include <fcntl.h>
#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <signal.h>
#ifdef HAVE_PATHS_H
#include <paths.h>
#endif

/* #define GC_DEBUG */
#include "../gc6.0/include/gc.h"

/* #define USE_BASE16 */

#define CM_APPNAME   "opencm"
#define CM_VARPREFIX   "OPENCM"
#define CM_CONFIG_DIR "." CM_APPNAME
#define CM_USER_SUBDIR "users"
#define CM_SERVER_SUBDIR "servers"
#define CM_DEFAULT_USER "default"

/* protocol versions */
#define CM_PROTO_NOCOMMONVER 0	/* no common version found */
#define CM_LEAST_PROTO_VER 1	/* least version still supported by this
				   source base */
#define CM_PROTO_VER       4	/* current protocol version */

#undef max
#define max(a,b) ((a) > (b) ? (a) : (b))
#undef min
#define min(a,b) ((a) < (b) ? (a) : (b))

typedef struct Mutable Mutable;
typedef struct Change Change;
typedef struct CommitInfo CommitInfo;
typedef struct OPENCM_SHA OPENCM_SHA;
typedef struct SerialType SerialType;
typedef struct Serializable Serializable;
typedef struct Entity Entity;
typedef struct WorkSpace WorkSpace;
typedef struct SubProcess SubProcess;
typedef struct PubKey PubKey;
typedef struct Repository Repository;

typedef struct command command;

#if SIZEOF_UNSIGNED_LONG_LONG == 8
typedef unsigned long long oc_uint64_t;
#elif SIZEOF___UINT64 == 8
typedef __uint64 oc_uint64_t;
#error "OpenCM requires a 64-bit unsigned type."
#endif

#define OC_UINT64_MAX (~ ((oc_uint64_t) 0) )

typedef oc_uint64_t ocmoff_t;

/* exit codes */
#define N_FAILED  1

#include "common/bool.h"
#include "common/except.h"
#include "common/glob.h"
#include "common/Buffer.h"
#include "common/SDR.h"
#include "common/Serializable.h"
#include "common/rbtree.h"
#include "common/EntityCache.h"
#include "common/ObDict.h"
#include "common/encode.h"
#include "common/Report.h"
#include "common/Mutable.h"
#include "common/User.h"
#include "common/Revision.h"
#include "common/PtrArray.h"
#include "common/CommitInfo.h"
#include "common/Change.h"
#include "common/TrueName.h"
#include "common/Entity.h"
#include "common/SSLcommon.h"
#include "common/Group.h"
#include "common/PubKey.h"
#include "common/Dirent.h"
#include "common/Directory.h"
#include "common/SubProcess.h"
#include "common/Version.h"
#include "common/FsDir.h"
#include "common/phash.h"
#include "common/sxdelta.h"

#include "globals.h"
#include "common/path.h"
#include "common/os.h"
#include "common/sha1.h"

#include "common/opencm_opcode.h"
#include "common/URI.h"
#include "common/Channel.h"
#include "common/ServerRequest.h"
#include "common/ServerReply.h"
#include "common/WireString.h"
#include "common/WireUnsigned.h"
#include "common/WireException.h"
#include "libdiff/libdiff.h"

#ifndef __unix__
#define BROKEN_FS_ENTITIES
#endif

#endif /* OPENCM_H */
