/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <opencm.h>

void
user_show(const void *ob)
{
  const User *u = ob;
  
  xprintf("PubKey:      %s\n", ser_getTrueName(u->pubKey));
  xprintf("DirURI:     %s\n", u->dirURI);
}

void
user_serialize(SDR_stream *strm, const void *ob)
{
  const User *u = ob;
  
  sdr_write("pubKey", strm, u->pubKey);
  sdr_w_string("dirURI", strm, u->dirURI);
}

void *
user_deserialize(const DeserializeInfo *di, SDR_stream *strm)
{
  User *u = (User *) GC_MALLOC(sizeof(User));

  u->serType        = &User_SerType;

  u->pubKey     = sdr_read("pubKey", strm);
  u->dirURI     = sdr_r_string("dirURI", strm);

  SER_MODIFIED(u);
  return u;
}

#if 0
X509 *
user_GetCert(User *u)
{
  X509 *cert;
  BIO *inMem = BIO_new(BIO_s_mem());

  if (u == NULL)
    return NULL;

  if (u->cache_cert)
    return u->cache_cert;

  BIO_puts(inMem, u->cert);
  cert = PEM_read_bio_X509(inMem, NULL, NULL, NULL);
  u->cache_cert = cert;
  BIO_set_close(inMem, BIO_NOCLOSE);
  BIO_free(inMem);
  return cert;
}
#endif

#if 0
const char *
user_GetCertIssuer(User *u)
{
  long num = 0;
  void *tmpbuf = NULL;
  X509 *x = user_GetCert(u);
  char *expires = NULL;
  char *efix = NULL;
  char *ret = NULL;
  char CN[100];
  BIO *inMem = BIO_new(BIO_s_mem());

  /* Get the expiration date of user's cert */
  ASN1_TIME_print(inMem, X509_get_notAfter(x));
  if ((num = BIO_get_mem_data(inMem, &tmpbuf)) == 0)
    return NULL;

  expires = (char *)GC_MALLOC_ATOMIC(sizeof(char) * (num + 1));
  memcpy(expires, tmpbuf, num);
  expires[num] = 0;

  /* Get rid of extraneous characters */
  if (expires != NULL) {
    efix = strstr(expires, "GMT");
    efix = efix + 3;
    *efix = 0;
  }

  X509_NAME_get_text_by_NID(X509_get_issuer_name(x), NID_commonName, CN, 100);
  ret = xstrdup(CN);
  ret = xstrcat(ret, "; Expires: ");
  ret = xstrcat(ret, expires);

  BIO_set_close(inMem, BIO_NOCLOSE);
  BIO_free(inMem);
  return ret;
}
#endif

#if 0
const char *
user_GetDescription(User *u)
{
  X509 *x = user_GetCert(u);
  char CN[100];
  char ST[100];
  char L[100];
  char O[100];
  char OU[100];
  char Email[100];
  char *ret = NULL;
  const char *SEPARATOR = ", ";

  X509_NAME_get_text_by_NID(X509_get_subject_name(x), NID_commonName, CN, 100);
  X509_NAME_get_text_by_NID(X509_get_subject_name(x), NID_stateOrProvinceName, 
      ST, 100);
  X509_NAME_get_text_by_NID(X509_get_subject_name(x), NID_localityName, L, 100);
  X509_NAME_get_text_by_NID(X509_get_subject_name(x), NID_organizationName, 
      O, 100);
  X509_NAME_get_text_by_NID(X509_get_subject_name(x), 
      NID_organizationalUnitName, OU, 100);
  Email[0] = '\0';
  X509_NAME_get_text_by_NID(X509_get_subject_name(x), NID_pkcs9_emailAddress, 
      Email, 100);

  ret = xstrdup(CN);
  if (Email[0] != '\0') {
    ret = xstrcat(ret, " (");
    ret = xstrcat(ret, Email);
    ret = xstrcat(ret, ")");
  }
  ret = xstrcat(ret, SEPARATOR);
  ret = xstrcat(ret, O);
  ret = xstrcat(ret, SEPARATOR);
  ret = xstrcat(ret, ST);

  return ret;
}
#endif

#if 0
const char *
user_GetFP(User *u)
{
  EVP_PKEY *pubkey;
  OPENCM_SHA *sha;
  char *pemkey;
  const char *strkey;
  void *tmpbuf;
  long num = 0;
  unsigned int n;
  int j;
  int offset = 0;
  char *fp;
  BIO *bio = BIO_new(BIO_s_mem());

  if (u == NULL)
    return NULL;

  if (u->cache_fp)
    return u->cache_fp;

  pubkey = X509_get_pubkey(user_GetCert(u));
  if (!PEM_write_bio_PUBKEY(bio, pubkey))
    report_error(ExIoTruncated,"Error retrieving user's public key");

  if ((num = BIO_get_mem_data(bio, &tmpbuf)) == 0)
    report_error(ExIoTruncated,"BIO error retrieving user's public key");

  pemkey = (char *)GC_MALLOC_ATOMIC(sizeof(char) * (num + 1));
  memcpy(pemkey, tmpbuf, num);
  pemkey[num] = 0;  /* null terminated */
  sha = sha_create_from_string(pemkey);
  strkey = sha_hexdigest(sha);

  /* Allocate space for: 2 hex digits per, 1 colon after, and
   * then one final NULL */
  n = strlen(strkey);
  fp = (char *)GC_MALLOC_ATOMIC((n*2) + (n-1) + 1);

  for (j=0; j<(int)n; j++) {
    sprintf(fp+offset,"%02X%c", strkey[j], (j+1 == (int)n) ? '\0':':');
    offset = offset + 3;
  }

  BIO_set_close(bio, BIO_NOCLOSE);
  BIO_free(bio);

  /* Cache the result */
  u->cache_fp = fp;
  return fp;
}
#endif

User *
user_create(PubKey *pk, const char *dirURI)
{
  User *u = (User *) GC_MALLOC(sizeof(User));

  u->serType        = &User_SerType;

  u->pubKey     = pk;
  u->dirURI     = dirURI;

  SER_MODIFIED(u);
  return u;
}

#if 0
User *
user_create(X509 *x)
{
  long num = 0;
  void *tmpbuf = NULL;
  char *data;
  User *p = (User *) GC_MALLOC(sizeof(User));
  BIO *inMem = BIO_new(BIO_s_mem());

  if (x == NULL)
    return NULL;

  if (!PEM_write_bio_X509(inMem, x))
    return NULL;

  if ((num = BIO_get_mem_data(inMem, &tmpbuf)) == 0)
    return NULL;

  data = (char *)GC_MALLOC_ATOMIC(sizeof(char) * (num + 1));
  memcpy(data, tmpbuf, num);
  data[num] = 0;

  p->serType = &User_SerType;
  p->cert = data;
  p->cache_cert = NULL;

  BIO_set_close(inMem, BIO_NOCLOSE);
  BIO_free(inMem);

  SER_MODIFIED(p);

  return p;
} 
#endif

