/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <opencm.h>

void
revision_show(const void *vp)
{
  const Revision *r = vp;
  
  xprintf("mutURI:     %s\n", r->mutURI);
  xprintf("Seq Num:    0x%08x%08x\n",
      (unsigned long) (r->seq_number >> 32),
      (unsigned long) (r->seq_number));
  xprintf("ReviseTime: %s\n", r->reviseTime);
  xprintf("Revisor:    %s\n", r->revisor);
  xprintf("NewObject:  %s\n", r->newObject);

  xprintf("Signature:  %s\n", r->signature);
}

void
revision_serialize(SDR_stream *strm, const void *vp)
{
  const Revision *r = vp;

  sdr_w_obname("mutURI", strm, r->mutURI);
  sdr_w_u64("seqnum", strm, r->seq_number);
  sdr_w_obname("reviseTime", strm, r->reviseTime);
  sdr_w_obname("revisor", strm, r->revisor);
  sdr_w_obname("newObject", strm, r->newObject);
  sdr_w_obname("signature", strm, r->signature);
}

void *
revision_deserialize(const DeserializeInfo *di, SDR_stream *strm)
{
  Revision *r = (Revision *) GC_MALLOC(sizeof(Revision));

  r->serType        = &Revision_SerType;
  
  r->mutURI         = sdr_r_obname("mutURI", strm);
  r->seq_number     = sdr_r_u64("seqnum", strm);
  r->reviseTime     = sdr_r_obname("reviseTime", strm);
  r->revisor        = sdr_r_obname("revisor", strm);
  r->newObject      = sdr_r_obname("newObject", strm);
  r->signature      = sdr_r_obname("signature", strm);

  SER_MODIFIED(r);
  return r;
}

Revision *
revision_create(const char *mutURI, const char *userName,
		const char *trueName)
{
  Revision *r = (Revision *)GC_MALLOC(sizeof(Revision));

  r->mutURI = mutURI;
  r->serType = &Revision_SerType;

  r->seq_number = 0llu;
  r->reviseTime = os_GetISOTime();
  r->revisor = userName;
  r->newObject = trueName;
  r->signature = 0;

  SER_MODIFIED(r);
  return r;
}

