/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <opencm.h>

Change *
change_create(const char *parent, CommitInfo *ci)
{
  Change *chg = (Change *) GC_MALLOC(sizeof(Change));

  chg->serType = &Change_SerType;
  SER_MODIFIED(chg);

  chg->commitInfoTrueName = ci ? ser_getTrueName(ci) : NULL;
  //ZZZ  chg->entNames = tnvec_create();
  chg->entities = obvec_create();
  chg->parent = parent;
  chg->mergeParent = 0;		/* unknown! */
  chg->isPartialMerge = FALSE;	/* until proven otherwise */
  chg->mergeHist = strvec_create();
  chg->fileACLs = 0;

  chg->filterSetName = 0;

  return chg;
}

#if 0
void
change_append_entity(Change *chg, const char* s)
{
  SER_MODIFIED(chg);
  tnvec_append(chg->entNames, s);
}
#endif

void
change_append_entity(Change *chg, const Entity *e)
{
  assert(e);
  SER_MODIFIED(chg);
  obvec_append(chg->entities, e);
}

void
change_show(const void *vp)
{
  int i;
  const Change *chg = vp;
  
  xprintf("Change:       \"%s\"\n", ser_getTrueName(chg));
  xprintf("File ACLs:    \"%s\"\n", chg->fileACLs);
  xprintf("CommitInfo:   \"%s\"\n", chg->commitInfoTrueName);
  xprintf("Parent:       \"%s\"\n", chg->parent);
  xprintf("Merge Parent%s: \"%s\"\n",
	 chg->isPartialMerge ? "(partial)" : "",
	  chg->mergeParent);
  xprintf("Filterset:    \"%s\"\n", chg->filterSetName);

  /* FIX: mergeHist */
#if 0
  tnvec_sort(chg->entNames);

  xprintf("Entities:\n", ser_getTrueName(chg));
  for (i = 0; i < vec_size(chg->entNames); i++)
    xprintf("%4u  %s\n", i, vec_fetch(chg->entNames, i));
#endif

  xprintf("Entities:\n");
  for (i = 0; i < vec_size(chg->entities); i++) {
    Entity *ent = (Entity *)vec_fetch(chg->entities, i);
    sdr_show(ent);
  }
   
}

/* NOTE: commitInfoTrueName always changes, and either parent or
 * mergeParent changes (sometimes both), therefore this I/O ordering
 * yields the most favorable delta compression. */
void
change_serialize(SDR_stream *strm, const void *vp)
{
  const Change *chg = vp;

  sdr_w_obname("parent", strm, chg->parent);
  sdr_w_obname("fileACLs", strm, chg->fileACLs);
  sdr_w_obname("commitInfoTrueName", strm, chg->commitInfoTrueName);
  sdr_w_obname("mergeParent", strm, chg->mergeParent);
  sdr_w_u8("isPartialMerge", strm, chg->isPartialMerge);
  sdr_write("mergeHist", strm, chg->mergeHist);

#if 0
  tnvec_sort(chg->entNames);

  sdr_write("entNames", strm, chg->entNames);
#endif

  obvec_sort(chg->entities);

  sdr_write("entities", strm, chg->entities);
  sdr_w_obname("filterSetName", strm, chg->filterSetName);
}

void *
change_deserialize(const DeserializeInfo *di, SDR_stream *strm)
{
  Change *chg = (Change *) GC_MALLOC(sizeof(Change));

  chg->serType = &Change_SerType;
  SER_MODIFIED(chg);

  chg->parent             = sdr_r_obname("parent", strm);
  chg->fileACLs           = sdr_r_obname("fileACLs", strm);
  chg->commitInfoTrueName = sdr_r_obname("commitInfoTrueName", strm);
  chg->mergeParent        = sdr_r_obname("mergeParent", strm);
  chg->isPartialMerge     = sdr_r_u8("isPartialMerge", strm);
  chg->mergeHist          = sdr_read("mergeHist", strm);

#if 0
  chg->entNames           = sdr_read("entNames", strm);
#endif

  chg->entities           = sdr_read("entities", strm);
  chg->filterSetName      = sdr_r_obname("filterSetName", strm);

  return chg;
}
