/*
 * Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
 * University. All rights reserved.
 * 
 * This software was developed to support the EROS secure operating
 * system project (http://www.eros-os.org). The latest version of
 * the OpenCM software can be found at http://www.opencm.org.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials
 *    provided with the distribution.
 * 
 * 3. Neither the name of the The EROS Group, LLC nor the name of
 *    Johns Hopkins University, nor the names of its contributors
 *    may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <opencm.h>
#include "browseconfig.h"

static unsigned int beginning_of_line = 1;
static unsigned int cur_line = 1;
static unsigned int cur_pos = 0;

void
html_output_init(void)
{
  beginning_of_line = 1;
  cur_line = 1;
  cur_pos = 1;
}

static void output_line_start(SDR_stream *strm, int n)
{
  char strline[20];
  char *lnptr = strline;
  
  sprintf(strline, "% 5d", n);

  stream_printf(strm, "<font color=\"brown\" class=\"lineno\">");
  stream_printf(strm, "<a name=\"%d\">", cur_line);

  while (*lnptr == ' ') {
    stream_printf(strm, "&nbsp;");
    lnptr++;
  }

  stream_printf(strm, "<a href=\"#%d\">", cur_line);
  while (*lnptr)
    stream_putc(strm, *lnptr++);
  
  stream_printf(strm, "</a>");
  stream_printf(strm, "</a>");
  stream_printf(strm, "</font>");
  stream_printf(strm, "&nbsp;");
  stream_printf(strm, "&nbsp;");
}

void
html_end(SDR_stream *strm, const char *s)
{
  stream_printf(strm, s);
}

void
html_begin(SDR_stream *strm, const char *s)
{
  if (beginning_of_line) {
    output_line_start(strm, cur_line);
    beginning_of_line = 0;
  }
  stream_printf(strm, s);
}

void
do_html_output(SDR_stream *strm, const char *s, unsigned len)
{
  unsigned i;

  if (beginning_of_line) {
    output_line_start(strm, cur_line);
    beginning_of_line = 0;
  }
 
  for (i = 0; i < len; i++) {
    int c = s[i];
    switch (c) {
    case '<':
      stream_printf(strm, "&lt;");
      break;
    case '>':
      stream_printf(strm, "&gt;");
      break;
    case '&':
      stream_printf(strm, "&amp;");
      break;
    case '\n':
      stream_printf(strm, "<br>");
      beginning_of_line = 1;
      cur_pos = 0;
      cur_line++;
      break;

    case ' ':
    case '\t':
      stream_printf(strm, "&nbsp;");
      break;
    default:
      stream_printf(strm, "%c", c);
      break;
    }
    cur_pos ++;

    /* Pad tabs to the nearest multiple of 8 characters: */
    if (c == '\t') {
      while ((cur_pos % 8) != 7) {
	stream_printf(strm, "&nbsp;");
	cur_pos++;
      }
    }
  }
}

