#!/bin/sh
# Copyright (c) 2002, The EROS Group, LLC and Johns Hopkins
# University. All rights reserved.
# 
# This software was developed to support the EROS secure operating
# system project (http://www.eros-os.org). The latest version of
# the OpenCM software can be found at http://www.opencm.org.
# 
# Redistribution and use in source and binary forms, with or
# without modification, are permitted provided that the following
# conditions are met:
# 
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above
#    copyright notice, this list of conditions and the following
#    disclaimer in the documentation and/or other materials
#    provided with the distribution.
# 
# 3. Neither the name of the The EROS Group, LLC nor the name of
#    Johns Hopkins University, nor the names of its contributors
#    may be used to endorse or promote products derived from this
#    software without specific prior written permission.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
# CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
# ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

#
# Script to generate a spec file for opencm. Most of this is simply a 'here'
# document containing the actual specfile.
#

VERSION="$1"
BUILD="$2"

cat - <<EOF
Summary: A distributed configuration management system.
Name: opencm
EOF

echo "Version: ${VERSION}"
echo "Release: ${BUILD}"

cat - <<EOF
URL: http://www.opencm.org
Source0: http://www.opencm.org/pub/%{name}-%{version}-%{release}.tar.gz
License: GPL
Group: Development/Tools
Vendor: The EROS Group
Packager: The EROS Group
BuildRoot: %{_tmppath}/%{name}-buildroot
Prereq: /sbin/chkconfig, /usr/sbin/useradd

# Suppress annoying RedHat behavior:
# (It seems that pre-gzipping the info file avoids the problem,
#  so restore the RedHat behavior by commenting this out. Leave
#  it here as a reminder in case I ever get messed up by this again.
#  like when I get around to writing man pages, for example.)
#%define __os_install_post %{nil}
%define _target_platform %{nil}

%description
OpenCM is a powerful configuration management system providing
security and integrity protection for managed content. It simplifies
disconnected development and facilitates cross-organizational
collaboration.

OpenCM is designed as a successor to CVS.

%prep
%setup

%build
%configure
make

%install
rm -rf \$RPM_BUILD_ROOT
%makeinstall

%clean
rm -rf \$RPM_BUILD_ROOT

%post
/sbin/chkconfig --add opencm

%pre
# Add the "opencm" user
/usr/sbin/useradd -m -c "OpenCM" \
	-s /bin/false -r -d /var/opencm opencm 2> /dev/null || :

%preun
if [ $1 = 0 ]; then
	/sbin/service opencm stop > /dev/null 2>&1
	/sbin/chkconfig --del opencm
fi

%files
%defattr(-,root,root)
EOF

cat - <<EOF
%config(noreplace) /etc/opencm.conf
/etc/rc.d/init.d/opencm
/usr/bin/cm
/usr/share/info/opencm.info.gz
%dir /usr/share/opencm
%dir /usr/share/opencm/help
%dir /usr/share/opencm/tools
EOF
ls src/help/*.help | sed 's@src/help@/usr/share/opencm/help@' | sort
ls tools/*.py | sed 's@tools@/usr/share/opencm/tools@' | sort
