/*
   Nils Nordman 2001 <nino@nforced.com>
*/

#include <stdio.h>
#include <stdlib.h>

#include <glibtop.h>
#include <glibtop/open.h>
/*  #include <glibtop/close.h> */
#include <glibtop/xmalloc.h>

/*  #include <glibtop/parameter.h> */

/*  #include <glibtop/union.h> */
/*  #include <glibtop/sysdeps.h> */

#include <glibtop/cpu.h>
#include <glibtop/proclist.h>
#include <glibtop/mem.h>
#include <glibtop/swap.h>
#include <glibtop/procstate.h>
/* #include <glibtop/.h>*/


/*  #define TEST_ALL */
/*  #define TEST_CPU */
/*  #define TEST_MEM */
#define TEST_PROCLIST
/*  #define TEST_SWAP */
#define TEST_PROCSTATE
#define TEST_

#ifdef TEST_PROCSTATE
#define TEST_PROCLIST
#endif

void header( char *s )
{
	printf( "==============================================\n" );
	printf( "%s:\n", s );
	printf( "==============================================\n" );
}

int MB( int i ) { return (i / 1024) / 1024; }

int main(int argc, char *argv[])
{
	glibtop_proclist procbuf;
	glibtop_cpu cpubuf;
	glibtop_mem membuf;
	glibtop_swap swapbuf;
	glibtop_proc_state procstatebuf;
	unsigned *plist;
	int i;

	glibtop_init_r(&glibtop_global_server, 0, GLIBTOP_FEATURES_NO_SERVER);

#if defined(TEST_ALL) || defined(TEST_CPU)
	
#endif

#if defined(TEST_ALL) || defined(TEST_PROCLIST)

	if( !(plist = glibtop_get_proclist (&procbuf, GLIBTOP_KERN_PROC_ALL, 0) ) ) {
		printf( "could not get proclist!\n" );
		exit(1);
	}
	header( "PROCLIST" );
	printf( "\nnumber: %i\n\n", (int)procbuf.number );
	for( i = 0; i < procbuf.number; ++i ) {
		printf( "pid: %8i", plist[i] );
#if defined(TEST_ALL) || defined(TEST_PROCSTATE)
		glibtop_get_proc_state( &procstatebuf, plist[i] );
		printf( ",  " );
#if LIBGTOP_VERSION_CODE >= 1001000
		printf( "ruid: %5i,  ", procstatebuf.ruid );
		printf( "rgid: %5i,  ", procstatebuf.rgid );
#endif
		printf( "uid: %5i,  ", procstatebuf.uid );
		printf( "gid: %5i,  ", procstatebuf.gid );
		printf( "%c,  ", procstatebuf.state );
		printf( "cmd: %s\n", procstatebuf.cmd );
#endif
	}
	glibtop_free( plist );

#endif

#if defined(TEST_ALL) || defined(TEST_MEM)

	glibtop_get_mem( &membuf );
	header( "MEMORY" );
	printf( "total: %i (%iMB)\n", (int)membuf.total, MB( (int)membuf.total ) );
	printf( "used: %i (%iMB)\n", (int)membuf.used, MB( (int)membuf.used ) );
	printf( "free: %i (%iMB)\n", (int)membuf.free, MB( (int)membuf.free ) );

#endif

#if defined(TEST_ALL) || defined(TEST_SWAP)

	glibtop_get_swap( &swapbuf );
	header( "SWAP" );
	printf( "total: %i (%iMB)\n", (int)swapbuf.total, MB( (int)swapbuf.total ) );
	printf( "used: %i (%iMB)\n", (int)swapbuf.used, MB( (int)swapbuf.used ) );
	printf( "free: %i (%iMB)\n", (int)swapbuf.free, MB( (int)swapbuf.free ) );

#endif

	return 0;
}


#if defined(TEST_ALL) || defined(TEST_)

#endif
