/* OGMRip - A DVD Encoder for GNOME
 * Copyright (C) 2004-2006 Olivier Rolland <billl@users.sf.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __OGMRIP_OPTIONS_H__
#define __OGMRIP_OPTIONS_H__

#include <gtk/gtk.h>
#include <ogmdvd.h>

G_BEGIN_DECLS

enum
{
  OGMRIP_OPTIONS_ERROR = -1,
  OGMRIP_OPTIONS_AUTOMATIC,
  OGMRIP_OPTIONS_MANUAL
};

GtkWidget * ogmrip_options_new              (OGMDvdTitle *title);

gint        ogmrip_options_get_bitrate      (GtkWidget   *dialog, 
                                             guint       *bitrate);
gint        ogmrip_options_get_scale        (GtkWidget   *dialog, 
                                             guint       *width, 
                                             guint       *height);
gint        ogmrip_options_get_crop         (GtkWidget   *dialog, 
                                             guint       *x, 
                                             guint       *y, 
                                             guint       *width, 
                                             guint       *height);
gint        ogmrip_options_get_framestep    (GtkWidget   *dialog);
gint        ogmrip_options_get_deinterlacer (GtkWidget   *dialog);
gboolean    ogmrip_options_get_progressive  (GtkWidget   *dialog);
gboolean    ogmrip_options_get_pullup       (GtkWidget   *dialog);

G_END_DECLS

#endif /* __OGMRIP_OPTIONS_H__ */

