/* OGMRip - A DVD Encoder for GNOME
 * Copyright (C) 2004-2006 Olivier Rolland <billl@users.sf.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __OGMRIP_HELPER_H__
#define __OGMRIP_HELPER_H__

#include <gtk/gtk.h>
#include <sys/types.h>
#include <glade/glade.h>
#include <gconf/gconf-client.h>
#include <nautilus-burn-drive.h>

G_BEGIN_DECLS

#define GTK_BOX_CHILD(b) ((GtkBoxChild *) (b))

#define OGMRIP_ERROR ogmrip_error_quark ()

typedef enum
{
  OGMRIP_ERROR_NONE,
  OGMRIP_ERROR_INTERNAL
} OGMRipError;

/*
 * GConf
 */

gint     gconf_client_get_int_default      (GConfClient    *client,
                                            const gchar    *key,
                                            gint           def);
gboolean gconf_client_get_bool_default     (GConfClient    *client,
                                            const gchar    *key,
                                            gboolean       def);
gchar *  gconf_client_get_string_default   (GConfClient    *client,
                                            const gchar    *key,
                                            const gchar    *def);
gchar *  gconf_client_get_filename_default (GConfClient    *client,
                                            const gchar    *key,
                                            const gchar    *def);

/*
 * Gtk+
 */

void        gtk_window_set_parent          (GtkWindow      *window, 
                                            GtkWindow      *parent);
void        gtk_window_set_icon_from_stock (GtkWindow      *window,
                                            const gchar    *stock_id);
gint        gtk_radio_button_get_active    (GtkRadioButton *radio);
void        gtk_radio_button_set_active    (GtkRadioButton *radio, 
                                            guint          index);
gboolean    gtk_tree_model_iter_prev       (GtkTreeModel   *tree_model,
                                            GtkTreeIter    *iter);
void        gtk_label_set_int              (GtkLabel       *label,
                                            gint           value);
gint        gtk_label_get_int              (GtkLabel       *label);
GtkWidget * gtk_box_get_child              (GtkBox         *box,
                                            guint          n);

/*
 * OGMRip
 */

GQuark      ogmrip_error_quark    (void);

gint        ogmrip_message_dialog (GtkWindow      *parent, 
                                   GtkMessageType type, 
                                   const gchar    *format, 
                                   ...);

G_END_DECLS

#endif /* __OGMRIP_HELPER_H__ */

