/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2006 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "config.h"

#include "ogmrip-fs.h"
#include "ogmrip-xvid.h"
#include "ogmrip-backend.h"

#include "ogmjob-enums.h"
#include "ogmjob-exec.h"

#include <stdio.h>
#include <unistd.h>

#include <glib/gstdio.h>

#define OGMRIP_XVID_GET_PRIVATE(o) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((o), OGMRIP_TYPE_XVID, OGMRipXvidPriv))

static gint ogmrip_xvid_run (OGMJobSpawn *spawn);

struct _OGMRipXvidPriv
{
  gboolean gmc;
};

G_DEFINE_TYPE (OGMRipXvid, ogmrip_xvid, OGMRIP_TYPE_VIDEO)

static void
ogmrip_xvid_class_init (OGMRipXvidClass *klass)
{
  OGMJobSpawnClass *spawn_class;

  spawn_class = OGMJOB_SPAWN_CLASS (klass);

  spawn_class->run = ogmrip_xvid_run;

  g_type_class_add_private (klass, sizeof (OGMRipXvidPriv));
}

static void
ogmrip_xvid_init (OGMRipXvid *xvid)
{
  xvid->priv = OGMRIP_XVID_GET_PRIVATE (xvid);
}

static gint
ogmrip_xvid_run (OGMJobSpawn *spawn)
{
  OGMJobSpawn *child;
  gchar **argv;
  gint result;

#if MPLAYER_PRE < 8
  gchar *cwd;
#endif /* MPLAYER_PRE */

  argv = ogmrip_backend_xvid_command (OGMRIP_VIDEO (spawn), NULL, NULL, NULL);
  if (!argv)
    return OGMJOB_RESULT_ERROR;

  child = ogmjob_exec_newv (argv);
  ogmjob_exec_add_watch_full (OGMJOB_EXEC (child), (OGMJobWatch) ogmrip_backend_xvid_watch, spawn, TRUE, FALSE, FALSE);
  ogmjob_container_add (OGMJOB_CONTAINER (spawn), child);
  g_object_unref (child);

#if MPLAYER_PRE < 8
  /*
   * Workaround against xvid pass log file
   */
  cwd = g_get_current_dir ();
  g_chdir (g_get_tmp_dir ());
#endif /* MPLAYER_PRE */

  result = OGMJOB_SPAWN_CLASS (ogmrip_xvid_parent_class)->run (spawn);

#if MPLAYER_PRE < 8
  /*
   * Return in cwd
   */
  g_chdir (cwd);
  g_free (cwd);
#endif /* MPLAYER_PRE */

  ogmjob_container_remove (OGMJOB_CONTAINER (spawn), child);

  return result;
}

OGMJobSpawn *
ogmrip_xvid_new (OGMDvdTitle *title, const gchar *output)
{
  OGMJobSpawn *spawn;

  spawn = g_object_new (OGMRIP_TYPE_XVID, NULL);
  ogmrip_codec_set_output (OGMRIP_CODEC (spawn), output);
  ogmrip_codec_set_input (OGMRIP_CODEC (spawn), title);

  return spawn;
}

void
ogmrip_xvid_set_gmc (OGMRipXvid *xvid, gboolean gmc)
{
  g_return_if_fail (OGMRIP_IS_XVID (xvid));

  xvid->priv->gmc = gmc;
}

gboolean
ogmrip_xvid_get_gmc (OGMRipXvid *xvid)
{
  g_return_val_if_fail (OGMRIP_IS_XVID (xvid), FALSE);

  return xvid->priv->gmc;
}

