/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2006 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMRIP_XML_H__
#define __OGMRIP_XML_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define OGMRIP_TYPE_XML          (ogmrip_xml_get_type ())
#define OGMRIP_XML(obj)          (G_TYPE_CHECK_INSTANCE_CAST ((obj), OGMRIP_TYPE_XML, OGMRipXml))
#define OGMRIP_XML_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST ((klass), OGMRIP_TYPE_XML, OGMRipXmlClass))
#define OGMRIP_IS_XML(obj)       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), OGMRIP_TYPE_XML))
#define OGMRIP_IS_XML_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE ((klass), OGMRIP_TYPE_XML))

typedef struct _OGMRipXml      OGMRipXml;
typedef struct _OGMRipXmlPriv  OGMRipXmlPriv;
typedef struct _OGMRipXmlClass OGMRipXmlClass;

typedef void (* OGMRipXmlFunc)    (GType         type,
                                   const gchar   *name,
                                   const gchar   *description,
                                   gpointer      data);
typedef gint (* OGMRipXmlCmpFunc) (GType         type,
                                   const gchar   *name,
                                   const gchar   *description,
                                   gconstpointer data);

struct _OGMRipXml
{
  GObject parent_instance;

  OGMRipXmlPriv *priv;
};

struct _OGMRipXmlClass
{
  GObjectClass parent_class;
};

GType       ogmrip_xml_get_type                     (void);
OGMRipXml * ogmrip_xml_new                          (const gchar      *filename);

gint        ogmrip_xml_get_n_containers             (OGMRipXml        *xml);
void        ogmrip_xml_foreach_container            (OGMRipXml        *xml,
                                                     OGMRipXmlFunc    func,
                                                     gpointer         data);
GType       ogmrip_xml_find_container               (OGMRipXml        *xml,
                                                     OGMRipXmlCmpFunc func,
                                                     gconstpointer    data);
GType       ogmrip_xml_get_nth_container            (OGMRipXml        *xml,
                                                     guint            n);
gint        ogmrip_xml_get_container_max_audio      (OGMRipXml        *xml,
                                                     GType            container);
gint        ogmrip_xml_get_container_max_subp       (OGMRipXml        *xml,
                                                     GType            container);
G_CONST_RETURN
gchar *     ogmrip_xml_get_container_name           (OGMRipXml        *xml,
                                                     GType            container);

gint        ogmrip_xml_get_n_video_codecs           (OGMRipXml        *xml);
void        ogmrip_xml_foreach_video_codec          (OGMRipXml        *xml,
                                                     OGMRipXmlFunc    func,
                                                     gpointer         data);
GType       ogmrip_xml_find_video_codec             (OGMRipXml        *xml,
                                                     OGMRipXmlCmpFunc func,
                                                     gconstpointer    data);
GType       ogmrip_xml_get_nth_video_codec          (OGMRipXml        *xml,
                                                     guint             n);
G_CONST_RETURN
gchar *     ogmrip_xml_get_video_codec_name         (OGMRipXml        *xml,
                                                     GType            codec);

gint        ogmrip_xml_get_n_audio_codecs           (OGMRipXml        *xml);
void        ogmrip_xml_foreach_audio_codec          (OGMRipXml        *xml,
                                                     OGMRipXmlFunc    func,
                                                     gpointer         data);
GType       ogmrip_xml_find_audio_codec             (OGMRipXml        *xml,
                                                     OGMRipXmlCmpFunc func,
                                                     gconstpointer    data);
GType       ogmrip_xml_get_nth_audio_codec          (OGMRipXml        *xml,
                                                     guint            n);
G_CONST_RETURN
gchar *     ogmrip_xml_get_audio_codec_name         (OGMRipXml        *xml,
                                                     GType            codec);

gint        ogmrip_xml_get_n_subp_codecs            (OGMRipXml        *xml);
void        ogmrip_xml_foreach_subp_codec           (OGMRipXml        *xml,
                                                     OGMRipXmlFunc    func,
                                                     gpointer         data);
GType       ogmrip_xml_find_subp_codec              (OGMRipXml        *xml,
                                                     OGMRipXmlCmpFunc func,
                                                     gconstpointer    data);
GType       ogmrip_xml_get_nth_subp_codec           (OGMRipXml        *xml,
                                                     guint            n);
G_CONST_RETURN
gchar *     ogmrip_xml_get_subp_codec_name          (OGMRipXml        *xml,
                                                     GType            codec);
gboolean    ogmrip_xml_get_subp_codec_text          (OGMRipXml        *xml,
                                                     GType            codec);

gboolean    ogmrip_xml_can_contain_video            (OGMRipXml        *xml,
                                                     GType            container,
                                                     GType            codec);
gboolean    ogmrip_xml_can_contain_audio            (OGMRipXml        *xml,
                                                     GType            container,
                                                     GType            codec);
gboolean    ogmrip_xml_can_contain_subp             (OGMRipXml        *xml,
                                                     GType            container,
                                                     GType            codec);

gboolean    ogmrip_xml_can_contain_n_audio          (OGMRipXml        *xml,
                                                     GType            container,
                                                     guint            ncodec);
gboolean    ogmrip_xml_can_contain_n_subp           (OGMRipXml        *xml,
                                                     GType            container,
                                                     guint            ncodec);

G_END_DECLS

#endif /* __OGMRIP_XML_H__ */

