/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2006 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "ogmrip-x264.h"
#include "ogmrip-backend.h"

#include "ogmjob-enums.h"
#include "ogmjob-exec.h"

#include <stdio.h>
#include <unistd.h>

static gint ogmrip_x264_run (OGMJobSpawn *spawn);

G_DEFINE_TYPE (OGMRipX264, ogmrip_x264, OGMRIP_TYPE_VIDEO)

static void
ogmrip_x264_class_init (OGMRipX264Class *klass)
{
  OGMJobSpawnClass *spawn_class;

  spawn_class = OGMJOB_SPAWN_CLASS (klass);

  spawn_class->run = ogmrip_x264_run;
}

static void
ogmrip_x264_init (OGMRipX264 *x264)
{
}

static gint
ogmrip_x264_run (OGMJobSpawn *spawn)
{
  OGMJobSpawn *child;
  gchar **argv;
  gint result;

  argv = ogmrip_backend_x264_command (OGMRIP_VIDEO (spawn), NULL, NULL, NULL);
  if (!argv)
    return OGMJOB_RESULT_ERROR;

  child = ogmjob_exec_newv (argv);
  ogmjob_exec_add_watch_full (OGMJOB_EXEC (child), (OGMJobWatch) ogmrip_backend_x264_watch, spawn, TRUE, FALSE, FALSE);
  ogmjob_container_add (OGMJOB_CONTAINER (spawn), child);
  g_object_unref (child);

  result = OGMJOB_SPAWN_CLASS (ogmrip_x264_parent_class)->run (spawn);

  ogmjob_container_remove (OGMJOB_CONTAINER (spawn), child);

  return result;
}

OGMJobSpawn *
ogmrip_x264_new (OGMDvdTitle *title, const gchar *output)
{
  OGMJobSpawn *spawn;

  spawn = g_object_new (OGMRIP_TYPE_X264, NULL);
  ogmrip_codec_set_output (OGMRIP_CODEC (spawn), output);
  ogmrip_codec_set_input (OGMRIP_CODEC (spawn), title);

  return spawn;
}

