/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2006 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMRIP_VIDEO_H__
#define __OGMRIP_VIDEO_H__

#include <ogmrip-codec.h>

G_BEGIN_DECLS

#define OGMRIP_TYPE_VIDEO          (ogmrip_video_get_type ())
#define OGMRIP_VIDEO(obj)          (G_TYPE_CHECK_INSTANCE_CAST ((obj), OGMRIP_TYPE_VIDEO, OGMRipVideo))
#define OGMRIP_VIDEO_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST ((klass), OGMRIP_TYPE_VIDEO, OGMRipVideoClass))
#define OGMRIP_IS_VIDEO(obj)       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), OGMRIP_TYPE_VIDEO))
#define OGMRIP_IS_VIDEO_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE ((klass), OGMRIP_TYPE_VIDEO))

typedef enum
{
  OGMRIP_SCALER_FAST_BILINEAR,
  OGMRIP_SCALER_BILINEAR,
  OGMRIP_SCALER_BICUBIC,
  OGMRIP_SCALER_EXPERIMENTAL,
  OGMRIP_SCALER_NEAREST_NEIGHBOUR,
  OGMRIP_SCALER_AREA,
  OGMRIP_SCALER_LUMA_BICUBIC_CHROMA_BILINEAR,
  OGMRIP_SCALER_GAUSS,
  OGMRIP_SCALER_SINCR,
  OGMRIP_SCALER_LANCZOS,
  OGMRIP_SCALER_BICUBIC_SPLINE
} OGMRipScalerType;

typedef enum
{
  OGMRIP_DEINT_NONE,
  OGMRIP_DEINT_LINEAR_BLEND,
  OGMRIP_DEINT_LINEAR_INTERPOLATING,
  OGMRIP_DEINT_CUBIC_INTERPOLATING,
  OGMRIP_DEINT_MEDIAN,
  OGMRIP_DEINT_FFMPEG,
  OGMRIP_DEINT_KERNEL
} OGMRipDeintType;

typedef enum
{
  OGMRIP_QUALITY_VERY_HIGH,
  OGMRIP_QUALITY_HIGH,
  OGMRIP_QUALITY_FAST
} OGMRipQualityType;

typedef struct _OGMRipVideo      OGMRipVideo;
typedef struct _OGMRipVideoPriv  OGMRipVideoPriv;
typedef struct _OGMRipVideoClass OGMRipVideoClass;

struct _OGMRipVideo
{
  OGMRipCodec parent_instance;

  OGMRipVideoPriv *priv;
};

struct _OGMRipVideoClass
{
  OGMRipCodecClass parent_class;
};

GType     ogmrip_video_get_type             (void);

G_CONST_RETURN
gchar *   ogmrip_video_get_log              (OGMRipVideo       *video);
void      ogmrip_video_set_log              (OGMRipVideo       *video,
                                             const gchar       *log);
void      ogmrip_video_set_angle            (OGMRipVideo       *video,
                                             guint             angle);
gint      ogmrip_video_get_angle            (OGMRipVideo       *video);
void      ogmrip_video_set_bitrate          (OGMRipVideo       *video,
                                             guint             bitrate);
gint      ogmrip_video_get_bitrate          (OGMRipVideo       *video);
void      ogmrip_video_set_pass             (OGMRipVideo       *video,
                                             guint             pass);
gint      ogmrip_video_get_pass             (OGMRipVideo       *video);
void      ogmrip_video_set_scaler           (OGMRipVideo       *video,
                                             OGMRipScalerType  scaler);
gint      ogmrip_video_get_scaler           (OGMRipVideo       *video);
void      ogmrip_video_set_deinterlacer     (OGMRipVideo       *video,
                                             OGMRipDeintType   deint);
gint      ogmrip_video_get_deinterlacer     (OGMRipVideo       *video);
void      ogmrip_video_set_pullup           (OGMRipVideo       *video,
                                             gboolean          pullup);
gboolean  ogmrip_video_get_pullup           (OGMRipVideo       *video);
void      ogmrip_video_set_trellis          (OGMRipVideo       *video,
                                             gboolean          trellis);
gboolean  ogmrip_video_get_trellis          (OGMRipVideo       *video);
void      ogmrip_video_set_4mv              (OGMRipVideo       *video,
                                             gboolean          v4mv);
gboolean  ogmrip_video_get_4mv              (OGMRipVideo       *video);
void      ogmrip_video_set_qpel             (OGMRipVideo       *video,
                                             gboolean          qpel);
gboolean  ogmrip_video_get_qpel             (OGMRipVideo       *video);
void      ogmrip_video_set_turbo            (OGMRipVideo       *video,
                                             gboolean          turbo);
gboolean  ogmrip_video_get_turbo            (OGMRipVideo       *video);
void      ogmrip_video_set_grayscale        (OGMRipVideo       *video,
                                             gboolean          grayscale);
gboolean  ogmrip_video_get_grayscale        (OGMRipVideo       *video);
void      ogmrip_video_set_cartoon          (OGMRipVideo       *video,
                                             gboolean          cartoon);
gboolean  ogmrip_video_get_cartoon          (OGMRipVideo       *video);
void      ogmrip_video_set_denoise          (OGMRipVideo       *video,
                                             gboolean          denoise);
gboolean  ogmrip_video_get_denoise          (OGMRipVideo       *video);
void      ogmrip_video_set_max_b_frames     (OGMRipVideo       *video,
                                             guint             max_b_frames);
gint      ogmrip_video_get_max_b_frames     (OGMRipVideo       *video);
void      ogmrip_video_set_quality          (OGMRipVideo       *video,
                                             OGMRipQualityType quality);
gint      ogmrip_video_get_quality          (OGMRipVideo       *video);
void      ogmrip_video_get_raw_size         (OGMRipVideo       *video,
                                             guint             *width,
                                             guint             *height);
void      ogmrip_video_get_crop_size        (OGMRipVideo       *video,
                                             guint             *x,
                                             guint             *y,
                                             guint             *width,
                                             guint             *height);
void      ogmrip_video_set_crop_size        (OGMRipVideo       *video,
                                             guint             x,
                                             guint             y,
                                             guint             width,
                                             guint             height);
void      ogmrip_video_get_scale_size       (OGMRipVideo       *video,
                                             guint             *width,
                                             guint             *height);
void      ogmrip_video_set_scale_size       (OGMRipVideo       *video,
                                             guint             width,
                                             guint             height);
void      ogmrip_video_autocrop             (OGMRipVideo       *video,
                                             guint             nframes);
void      ogmrip_video_autoscale            (OGMRipVideo       *video);
void      ogmrip_video_autobitrate          (OGMRipVideo       *video, 
                                             guint64           nonvideo_size,
                                             guint64           overhead_size,
                                             guint64           total_size);

OGMDvdAudioStream * ogmrip_video_get_ensure_sync      (OGMRipVideo       *video);
void                ogmrip_video_set_ensure_sync      (OGMRipVideo       *video,
                                                       OGMDvdAudioStream *stream);

G_END_DECLS

#endif /* __OGMRIP_VIDEO_H__ */

