/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2006 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "ogmrip-backend.h"
#include "ogmjob-enums.h"
#include "ogmjob-exec.h"
#include "ogmrip-ogg.h"

#include <unistd.h>
#include <math.h>

#include <glib/gstdio.h>

static gint ogmrip_ogg_run (OGMJobSpawn *spawn);

G_DEFINE_TYPE (OGMRipOgg, ogmrip_ogg, OGMRIP_TYPE_CONTAINER)

static void
ogmrip_ogg_class_init (OGMRipOggClass *klass)
{
  OGMJobSpawnClass *spawn_class;
  OGMRipContainerClass *container_class;

  spawn_class = OGMJOB_SPAWN_CLASS (klass);
  container_class = OGMRIP_CONTAINER_CLASS (klass);

  spawn_class->run = ogmrip_ogg_run;
}

static void
ogmrip_ogg_init (OGMRipOgg *ogg)
{
}

static gint
ogmrip_ogg_run (OGMJobSpawn *spawn)
{
  OGMJobSpawn *child;
  gchar **argv, *file;
  gint result, fd;
  guint tnumber;

  fd = 0;
  file = NULL;
  result = OGMJOB_RESULT_ERROR;

  ogmrip_container_get_split (OGMRIP_CONTAINER (spawn), &tnumber, NULL);
  if (tnumber > 1)
  {
    OGMRipVideo *video;
    const gchar *tmpname;
    gchar *dirname;

    video = ogmrip_container_get_video (OGMRIP_CONTAINER (spawn));
    tmpname = ogmrip_codec_get_output (OGMRIP_CODEC (video));
    dirname = g_path_get_dirname (tmpname);

    file = g_build_filename (dirname, "merge.XXXXXX", NULL);
    g_free (dirname);

    fd = g_mkstemp (file);
    if (fd < 0)
    {
      g_free (file);
      return OGMJOB_RESULT_ERROR;
    }
  }

  argv = ogmrip_backend_ogg_merge_command (OGMRIP_CONTAINER (spawn), file);
  if (argv)
  {
    child = ogmjob_exec_newv (argv);
    ogmjob_exec_add_watch_full (OGMJOB_EXEC (child), (OGMJobWatch) ogmrip_backend_ogg_merge_watch, spawn, TRUE, FALSE, FALSE);
    ogmjob_container_add (OGMJOB_CONTAINER (spawn), child);
    g_object_unref (child);

    result = OGMJOB_SPAWN_CLASS (ogmrip_ogg_parent_class)->run (spawn);

    ogmjob_container_remove (OGMJOB_CONTAINER (spawn), child);
  }

  if (tnumber > 1 && result == OGMJOB_RESULT_COMPLETED)
  {
    argv = ogmrip_backend_ogg_split_command (OGMRIP_CONTAINER (spawn), file);
    if (argv)
    {
      child = ogmjob_exec_newv (argv);
      ogmjob_exec_add_watch_full (OGMJOB_EXEC (child), (OGMJobWatch) ogmrip_backend_ogg_split_watch, spawn, TRUE, FALSE, FALSE);
      ogmjob_container_add (OGMJOB_CONTAINER (spawn), child);
      g_object_unref (child);

      result = OGMJOB_SPAWN_CLASS (ogmrip_ogg_parent_class)->run (spawn);

      ogmjob_container_remove (OGMJOB_CONTAINER (spawn), child);
    }
  }

  if (file)
  {
    g_unlink (file);
    g_free (file);
  }

  if (fd)
    close (fd);

  return result;
}

OGMJobSpawn *
ogmrip_ogg_new (const gchar *output)
{
  OGMRipOgg *ogg;

  g_return_val_if_fail (output && *output, NULL);

  ogg = g_object_new (OGMRIP_TYPE_OGG, NULL);
  ogmrip_container_set_output (OGMRIP_CONTAINER (ogg), output);

  return OGMJOB_SPAWN (ogg);
}

