/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2006 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMRIP_INIT_H__
#define __OGMRIP_INIT_H__

#include <glib-object.h>

G_BEGIN_DECLS

typedef void (* OGMRipFunc)    (GType         type,
                                const gchar   *name,
                                const gchar   *description,
                                gpointer      data);
typedef gint (* OGMRipCmpFunc) (GType         type,
                                const gchar   *name,
                                const gchar   *description,
                                gconstpointer data);

void     ogmrip_init                         (void);
void     ogmrip_uninit                       (void);

gint     ogmrip_get_n_containers             (void);
void     ogmrip_foreach_container            (OGMRipFunc    func,
                                              gpointer      data);
GType    ogmrip_find_container               (OGMRipCmpFunc func,
                                              gconstpointer data);
GType    ogmrip_get_nth_container            (guint         n);
G_CONST_RETURN
gchar *  ogmrip_get_container_name           (GType         container);
gint     ogmrip_get_container_max_audio      (GType         container);
gint     ogmrip_get_container_max_subp       (GType         container);

gint     ogmrip_get_n_video_codecs           (void);
void     ogmrip_foreach_video_codec          (OGMRipFunc    func,
                                              gpointer      data);
GType    ogmrip_find_video_codec             (OGMRipCmpFunc func,
                                              gconstpointer data);
GType    ogmrip_get_nth_video_codec          (guint         n);
G_CONST_RETURN
gchar *  ogmrip_get_video_codec_name         (GType         codec);

gint     ogmrip_get_n_audio_codecs           (void);
void     ogmrip_foreach_audio_codec          (OGMRipFunc    func,
                                              gpointer      data);
GType    ogmrip_find_audio_codec             (OGMRipCmpFunc func,
                                              gconstpointer data);
GType    ogmrip_get_nth_audio_codec          (guint         n);
G_CONST_RETURN
gchar *  ogmrip_get_audio_codec_name         (GType         codec);

gint     ogmrip_get_n_subp_codecs            (void);
void     ogmrip_foreach_subp_codec           (OGMRipFunc    func,
                                              gpointer      data);
GType    ogmrip_find_subp_codec              (OGMRipCmpFunc func,
                                              gconstpointer data);
GType    ogmrip_get_nth_subp_codec           (guint         n);
G_CONST_RETURN
gchar *  ogmrip_get_subp_codec_name          (GType         codec);
gboolean ogmrip_get_subp_codec_text          (GType         codec);

gboolean ogmrip_can_contain_video            (GType         container,
                                              GType         codec);
gboolean ogmrip_can_contain_audio            (GType         container,
                                              GType         codec);
gboolean ogmrip_can_contain_subp             (GType         container,
                                              GType         codec);

gboolean ogmrip_can_contain_n_audio          (GType         container,
                                              guint         ncodec);
gboolean ogmrip_can_contain_n_subp           (GType         container,
                                              guint         ncodec);

G_END_DECLS

#endif /* __OGMRIP_INIT_H__ */

