/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2006 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "ogmrip.h"
#include "ogmrip-xml.h"

#define OGMRIP_XML_FILE "ogmrip/ogmrip.xml"

OGMRipXml *xml;

void
ogmrip_init (void)
{
  if (!xml)
  {
    /*
     * TODO
     * How to initialize (more) cleanly ?
     */

    ogmrip_xvid_get_type ();
    ogmrip_lavc_get_type ();
#ifdef HAVE_X264_SUPPORT
    ogmrip_x264_get_type ();
#endif
#ifdef HAVE_THEORA_SUPPORT
    ogmrip_theora_get_type ();
#endif

    ogmrip_vorbis_get_type ();
    ogmrip_mp3_get_type ();
    ogmrip_audio_copy_get_type ();
    ogmrip_wav_get_type ();
#ifdef HAVE_AAC_SUPPORT
    ogmrip_aac_get_type ();
#endif

    ogmrip_vobsub_get_type ();
#ifdef HAVE_SRT_SUPPORT
    ogmrip_srt_get_type ();
#endif

    ogmrip_ogg_get_type ();
    ogmrip_avi_get_type ();
#ifdef HAVE_LAVF_SUPPORT
    ogmrip_mp4_get_type ();
#endif
#ifdef HAVE_MKV_SUPPORT
    ogmrip_matroska_get_type ();
#endif

    xml = ogmrip_xml_new (OGMRIP_DATA_DIR "/" OGMRIP_XML_FILE);
  }
}

void
ogmrip_uninit (void)
{
  if (xml)
  {
    g_object_unref (xml);
    xml = NULL;
  }
}

gint
ogmrip_get_n_containers (void)
{
  return ogmrip_xml_get_n_containers (xml);
}

void
ogmrip_foreach_container (OGMRipFunc func, gpointer data)
{
  ogmrip_xml_foreach_container (xml, func, data);
}

GType
ogmrip_find_container (OGMRipCmpFunc func, gconstpointer data)
{
  return ogmrip_xml_find_container (xml, func, data);
}

GType
ogmrip_get_nth_container (guint n)
{
  return ogmrip_xml_get_nth_container (xml, n);
}

G_CONST_RETURN gchar *
ogmrip_get_container_name (GType container)
{
  return ogmrip_xml_get_container_name (xml, container);
}

gint
ogmrip_get_n_video_codecs (void)
{
  return ogmrip_xml_get_n_video_codecs (xml);
}

void
ogmrip_foreach_video_codec (OGMRipFunc func, gpointer data)
{
  ogmrip_xml_foreach_video_codec (xml, func, data);
}

GType
ogmrip_find_video_codec (OGMRipCmpFunc func, gconstpointer data)
{
  return ogmrip_xml_find_video_codec (xml, func, data);
}

GType
ogmrip_get_nth_video_codec (guint n)
{
  return ogmrip_xml_get_nth_video_codec (xml, n);
}

G_CONST_RETURN gchar *
ogmrip_get_video_codec_name (GType codec)
{
  return ogmrip_xml_get_video_codec_name (xml, codec);
}

gint
ogmrip_get_n_audio_codecs (void)
{
  return ogmrip_xml_get_n_audio_codecs (xml);
}

void
ogmrip_foreach_audio_codec (OGMRipFunc func, gpointer data)
{
  ogmrip_xml_foreach_audio_codec (xml, func, data);
}

GType
ogmrip_find_audio_codec (OGMRipCmpFunc func, gconstpointer data)
{
  return ogmrip_xml_find_audio_codec (xml, func, data);
}

GType
ogmrip_get_nth_audio_codec (guint n)
{
  return ogmrip_xml_get_nth_audio_codec (xml, n);
}

G_CONST_RETURN gchar *
ogmrip_get_audio_codec_name (GType codec)
{
  return ogmrip_xml_get_audio_codec_name (xml, codec);
}

gint
ogmrip_get_n_subp_codecs (void)
{
  return ogmrip_xml_get_n_subp_codecs (xml);
}

void
ogmrip_foreach_subp_codec (OGMRipFunc func, gpointer data)
{
  ogmrip_xml_foreach_subp_codec (xml, func, data);
}

GType
ogmrip_find_subp_codec (OGMRipCmpFunc func, gconstpointer data)
{
  return ogmrip_xml_find_subp_codec (xml, func, data);
}

GType
ogmrip_get_nth_subp_codec (guint n)
{
  return ogmrip_xml_get_nth_subp_codec (xml, n);
}

G_CONST_RETURN gchar *
ogmrip_get_subp_codec_name (GType codec)
{
  return ogmrip_xml_get_subp_codec_name (xml, codec);
}

gboolean
ogmrip_can_contain_video (GType container, GType codec)
{
  return ogmrip_xml_can_contain_video (xml, container, codec);
}

gboolean
ogmrip_can_contain_audio (GType container, GType codec)
{
  return ogmrip_xml_can_contain_audio (xml, container, codec);
}

gboolean
ogmrip_can_contain_subp (GType container, GType codec)
{
  return ogmrip_xml_can_contain_subp (xml, container, codec);
}

gboolean
ogmrip_can_contain_n_audio (GType container, guint ncodec)
{
  return ogmrip_xml_can_contain_n_audio (xml, container, ncodec);
}

gboolean
ogmrip_can_contain_n_subp (GType container, guint ncodec)
{
  return ogmrip_xml_can_contain_n_subp (xml, container, ncodec);
}

gboolean
ogmrip_get_subp_codec_text (GType codec)
{
  return ogmrip_xml_get_subp_codec_text (xml, codec);
}

gint
ogmrip_get_container_max_audio (GType container)
{
  return ogmrip_xml_get_container_max_audio (xml, container);
}

gint
ogmrip_get_container_max_subp (GType container)
{
  return ogmrip_xml_get_container_max_subp (xml, container);
}

