/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2006 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMRIP_CONTAINER_H__
#define __OGMRIP_CONTAINER_H__

#include <ogmjob-bin.h>

#include <ogmrip-chapters.h>
#include <ogmrip-video.h>
#include <ogmrip-audio.h>
#include <ogmrip-subp.h>

G_BEGIN_DECLS

#define OGMRIP_TYPE_CONTAINER           (ogmrip_container_get_type ())
#define OGMRIP_CONTAINER(obj)           (G_TYPE_CHECK_INSTANCE_CAST ((obj), OGMRIP_TYPE_CONTAINER, OGMRipContainer))
#define OGMRIP_CONTAINER_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST ((klass), OGMRIP_TYPE_CONTAINER, OGMRipContainerClass))
#define OGMRIP_IS_CONTAINER(obj)        (G_TYPE_CHECK_INSTANCE_TYPE ((obj), OGMRIP_TYPE_CONTAINER))
#define OGMRIP_IS_CONTAINER_CLASS(obj)  (G_TYPE_CHECK_CLASS_TYPE ((klass), OGMRIP_TYPE_CONTAINER))
#define OGMRIP_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), OGMRIP_TYPE_CONTAINER, OGMRipContainerClass))

typedef enum
{
  OGMRIP_AUDIO_DEMUXER_AUTO = 0,
  OGMRIP_AUDIO_DEMUXER_AC3  = 0x2000,
  OGMRIP_AUDIO_DEMUXER_DTS  = 0x2001
} OGMRipAudioDemuxer;

typedef enum
{
  OGMRIP_SUBP_DEMUXER_AUTO,
  OGMRIP_SUBP_DEMUXER_VOBSUB
} OGMRipSubpDemuxer;

typedef struct _OGMRipContainer      OGMRipContainer;
typedef struct _OGMRipContainerPriv  OGMRipContainerPriv;
typedef struct _OGMRipContainerClass OGMRipContainerClass;

typedef void (* OGMRipContainerFunc) (OGMRipContainer *container,
                                      OGMRipCodec     *codec,
                                      guint           demuxer,
                                      gint            language,
                                      gpointer        user_data);

struct _OGMRipContainer
{
  OGMJobBin parent_instance;

  OGMRipContainerPriv *priv;
};

struct _OGMRipContainerClass
{
  OGMJobBinClass parent_class;
};

GType            ogmrip_container_get_type             (void);

G_CONST_RETURN
gchar *          ogmrip_container_get_output           (OGMRipContainer     *container);
void             ogmrip_container_set_output           (OGMRipContainer     *container,
                                                        const gchar         *output);
G_CONST_RETURN
gchar *          ogmrip_container_get_label            (OGMRipContainer     *container);
void             ogmrip_container_set_label            (OGMRipContainer     *container,
                                                        const gchar         *label);

G_CONST_RETURN
gchar *          ogmrip_container_get_fourcc           (OGMRipContainer     *container);
void             ogmrip_container_set_fourcc           (OGMRipContainer     *container,
                                                        const gchar         *fourcc);

OGMRipVideo *    ogmrip_container_get_video            (OGMRipContainer     *container);
void             ogmrip_container_set_video            (OGMRipContainer     *container,
                                                        OGMRipVideo         *video);

void             ogmrip_container_add_audio            (OGMRipContainer     *container,
                                                        OGMRipAudio         *audio,
                                                        OGMRipAudioDemuxer  demuxer,
                                                        gint                language);
GList *          ogmrip_container_get_audio            (OGMRipContainer     *container);
OGMRipAudio *    ogmrip_container_get_nth_audio        (OGMRipContainer     *container,
                                                        gint                n);
gint             ogmrip_container_get_n_audio          (OGMRipContainer     *container);
void             ogmrip_container_foreach_audio        (OGMRipContainer     *container, 
                                                        OGMRipContainerFunc func, 
                                                        gpointer            data);

void             ogmrip_container_add_subp             (OGMRipContainer     *container,
                                                        OGMRipSubp          *subp,
                                                        OGMRipSubpDemuxer   demuxer,
                                                        gint                language);
GList *          ogmrip_container_get_subp             (OGMRipContainer     *container);
gint             ogmrip_container_get_n_subp           (OGMRipContainer     *container);
OGMRipSubp *     ogmrip_container_get_nth_subp         (OGMRipContainer     *container,
                                                        gint                n);
void             ogmrip_container_foreach_subp         (OGMRipContainer     *container, 
                                                        OGMRipContainerFunc func, 
                                                        gpointer            data);

void             ogmrip_container_add_chapters         (OGMRipContainer     *container,
                                                        OGMRipChapters      *chapters);
GList *          ogmrip_container_get_chapters         (OGMRipContainer     *container);
OGMRipChapters * ogmrip_container_get_nth_chapters     (OGMRipContainer     *container,
                                                        gint                n);
gint             ogmrip_container_get_n_chapters       (OGMRipContainer     *container);
void             ogmrip_container_foreach_chapters     (OGMRipContainer     *container, 
                                                        OGMRipContainerFunc func, 
                                                        gpointer            data);

void             ogmrip_container_set_split            (OGMRipContainer     *container,
                                                        guint               number,
                                                        guint                size);
void             ogmrip_container_get_split            (OGMRipContainer     *container,
                                                        guint               *number,
                                                        guint               *size);

gint64           ogmrip_container_get_overhead_size    (OGMRipContainer     *container);
gint64           ogmrip_container_get_nonvideo_size    (OGMRipContainer     *container);

G_END_DECLS

#endif /* __OGMRIP_CONTAINER_H__ */

